package cn.com.duiba.nezha.alg.feature.parse;

import cn.com.duiba.nezha.alg.common.enums.DateStyle;
import cn.com.duiba.nezha.alg.common.util.AssertUtil;
import cn.com.duiba.nezha.alg.common.util.DataUtil;
import cn.com.duiba.nezha.alg.common.util.DateUtil;
import cn.com.duiba.nezha.alg.common.util.LocalDateUtil;
import cn.com.duiba.nezha.alg.feature.vo.AdxFeatureDo;
import com.alibaba.fastjson.JSON;
import org.slf4j.LoggerFactory;


import java.time.LocalDateTime;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

/**
 * Created by pc on 2019/2/21.
 */
public class AdxFeatureParse {

    public static int F_MAX_SIZE = 64;
    private static final org.slf4j.Logger logger = LoggerFactory.getLogger(AdxFeatureParse.class);


    public static Map<String, String> generateFeatureMapStatic(AdxFeatureDo cf) {
        Map<String, String> retMap = new HashMap<>(F_MAX_SIZE);
        try {
            if (cf != null) {

                cf.setCurrentCreatTime(getStringToTimeStamp());

                //推广组
                retMap.put("f1010010", DataUtil.Long2String(cf.getGroupId())); // 推广组ID
                retMap.put("f1010020", DataUtil.Integer2String(cf.getAdxType())); // 平台类型
                retMap.put("f1010030", cf.getCat()); // 推广组对应类别
                retMap.put("f1010031", cf.getTuiaCat()); // 推啊平台的推广组对应类别(标准)
                retMap.put("f1010040", cf.getSectionCat()); // 推广组当前部分的类别
                retMap.put("f1010041", cf.getTuiaSectionCat()); // 推啊平台的推广组当前部分的类别(标准)
                retMap.put("f1010050", cf.getKeywords()); // 推广组关键词

                //资源位
                retMap.put("f2010010", DataUtil.Long2String(cf.getResourceId())); // 资源位ID
                retMap.put("f2010020", DataUtil.Integer2String(cf.getAdvertType())); // 广告类型
                retMap.put("f2010030", DataUtil.Integer2String(cf.getPosType())); // 广告位类型
                retMap.put("f2010040", DataUtil.Integer2String(cf.getPosStyle())); // 广告位样式

                //上下文
                retMap.put("f4010010", cf.getUa()); // ua
                retMap.put("f4010030", DataUtil.Long2String(cf.getAreaCode())); // 地域
                retMap.put("f4010040", DataUtil.Integer2String(cf.getDeviceType())); // 设备类型
                retMap.put("f4010041", DataUtil.Integer2String(cf.getTuiaDeviceType())); // 推啊平台的设备类型(标准)
                retMap.put("f4010050", cf.getMake()); // 设备厂商
                retMap.put("f4010060", cf.getModel()); // 设备型号
                retMap.put("f4010070", cf.getOs()); // 操作系统
                retMap.put("f4010080", cf.getCarrier()); // 运营商
                retMap.put("f4010090", DataUtil.Integer2String(cf.getConnectionType())); // 联网方式
                retMap.put("f4010091", DataUtil.Integer2String(cf.getTuiaConnectionType())); // 推啊平台的联网方式(标准)

                Integer hour = getTimeStampToHour(cf.getCurrentCreatTime());
                retMap.put("f4010121", DataUtil.Integer2String(hour)); // 竞价请求创建时间-小时

                Integer weekDay = getTimeStampToWeekDay(cf.getCurrentCreatTime());
                retMap.put("f4010122", DataUtil.Integer2String(weekDay)); // 竞价请求创建时间-星期几

                //用户
                retMap.put("f5010010", cf.getGender()); // 性别

            }

        } catch (Exception e) {

            logger.error("AdxFeatureParse.generateFeatureMapStatic error:" + e);
        }

        return retMap;
    }


    public static Map<String, String> generateFeatureMapDynamic(AdxFeatureDo cf, AdxFeatureDo staticCf) {
        Map<String, String> retMap = new HashMap<>(F_MAX_SIZE);
        try {
            if (cf != null) {

                //创意（素材）
                retMap.put("f3010010", DataUtil.Long2String(cf.getIdeaId()));
                retMap.put("f3010020", cf.getButtonText());
                retMap.put("f3010030", DataUtil.Integer2String(cf.getIconH()));
                retMap.put("f3010040", DataUtil.Integer2String(cf.getIconW()));
                retMap.put("f3010050", DataUtil.Integer2String(cf.getMjPicType()));
                retMap.put("f3010060", DataUtil.Integer2String(cf.getIdeaPicH1()));
                retMap.put("f3010070", DataUtil.Integer2String(cf.getIdeaPicW1()));
                retMap.put("f3010080", DataUtil.Integer2String(cf.getIdeaPicH2()));
                retMap.put("f3010090", DataUtil.Integer2String(cf.getIdeaPicW2()));
                retMap.put("f3010100", DataUtil.Integer2String(cf.getIdeaPicH3()));
                retMap.put("f3010110", DataUtil.Integer2String(cf.getIdeaPicW3()));
                retMap.put("f3010120", DataUtil.Integer2String(cf.getIdeaPicNum()));

            }
        }catch (Exception e) {
            logger.error("AdxFeatureParse.generateFeatureMapDynamic error:", e);

        }
        return retMap;
    }




    public static Integer getTimeStampToHour(Long timeStamp) {
        Integer ret = null;
        if (timeStamp != null) {
            Date date = new Date(timeStamp);

            if (date != null){
                LocalDateTime localDate = LocalDateUtil.dateToLocal(date);

                if (localDate != null) {
                    ret = LocalDateUtil.getHour(localDate);

                }
            }
        }
        return ret;
    }


    public static Integer getTimeStampToWeekDay(Long timeStamp) {
        Integer ret = null;
        if (timeStamp != null) {
            Date date = new Date(timeStamp);

            if (date != null){
                LocalDateTime localDate = LocalDateUtil.dateToLocal(date);

                if (localDate != null) {
                    ret =  LocalDateUtil.getDayOfWeek(localDate);

                }
            }
        }
        return ret;
    }


    //
    public static Long getStringToTimeStamp() {
        Long ret = null;
        String currentTime = LocalDateUtil.getCurrentLocalDateTime(DateStyle.YYYY_MM_DD_HH_MM_SS.getValue());

        if (currentTime != null) {
            ret = LocalDateUtil.getTimeMillis(currentTime, DateStyle.YYYY_MM_DD_HH_MM_SS.getValue());

        }
        return ret;
    }



    //测试
    public static void main(String[] args) {

        Long currentGmtCreateTime1 = new Date().getTime();
        System.out.println("time:"+currentGmtCreateTime1);

        Integer hour = getTimeStampToHour(currentGmtCreateTime1);
        System.out.println("hour:"+DataUtil.Integer2String(hour));

        Integer weekDay = getTimeStampToWeekDay(currentGmtCreateTime1);
        System.out.println("weekday:"+DataUtil.Integer2String(weekDay));

        Long currentTime1 = getStringToTimeStamp();
        System.out.println("time1:"+currentTime1);


        AdxFeatureDo adxFeatureDo1 = new AdxFeatureDo();
        adxFeatureDo1.setCurrentCreatTime( new Date().getTime());
        Map<String, String> staticMap1 = new HashMap();
        staticMap1 = AdxFeatureParse.generateFeatureMapStatic(adxFeatureDo1);
        System.out.println("staticMap1=" + JSON.toJSONString(staticMap1));

    }

}