package cn.com.duiba.nezha.alg.feature.coder;


import cn.com.duiba.nezha.alg.common.util.MathUtil;
import cn.com.duiba.nezha.alg.feature.type.FeatureBaseType;
import cn.com.duiba.nezha.alg.feature.vo.CodeResult;
import cn.com.duiba.nezha.alg.feature.vo.Feature;
import cn.com.duiba.nezha.alg.feature.vo.FeatureCodeInfo;
import cn.com.duiba.nezha.alg.feature.vo.FeatureMapDo;
import com.alibaba.fastjson.JSON;

import java.lang.reflect.Array;
import java.util.*;

public class FeatureCoder extends FeatureCoderBase {

    private static int F_MAX_SIZE = 64;

    public static Map tmpMap = new HashMap();


    public static CodeResult code(List<FeatureBaseType> list, Map<String, String> featureMap) throws Exception {

        return code(list, featureMap, null);
    }

    public static CodeResult code(List<FeatureBaseType> list, FeatureMapDo featureMap) throws Exception {

        if (featureMap == null) {
            return code(list, null, null);
        } else {
            return code(list, featureMap.staticFeatureMap, featureMap.dynamicFeatureMap);
        }
    }


    public static CodeResult code(List<FeatureBaseType> list, Map<String, String> staticFeatureMap, Map<String, String> dynamicFeatureMap) throws Exception {

        CodeResult codeResult = new CodeResult();


        List<Integer> indices = new ArrayList<>(F_MAX_SIZE);//field起始+field内编码
        List<Double> values = new ArrayList<>(F_MAX_SIZE);
        List<String> fields = new ArrayList<>(F_MAX_SIZE);
        List<Integer> pLenList = new ArrayList<>(F_MAX_SIZE);//field起始
        List<Set<Integer>> ret = new ArrayList<>(F_MAX_SIZE);

        if (staticFeatureMap == null) {
            staticFeatureMap = tmpMap;
        }
        if (dynamicFeatureMap == null) {
            dynamicFeatureMap = tmpMap;
        }
        for (FeatureBaseType featureBaseType : list) {

            String value = dynamicFeatureMap.get(featureBaseType.getName());
            if (value == null) {
                value = staticFeatureMap.get(featureBaseType.getName());
            }


            Set<Integer> retSub = featureBaseType.code(value, pLenList, indices, values);
            ret.add(retSub);
            for (int i = 0; i < retSub.size(); i++) {
                fields.add(featureBaseType.getName());
            }
//            System.out.println("fieldName="+featureBaseType.getName()+",fieldValue="+value+","+JSON.toJSONString(pLenList)+","+JSON.toJSONString(indices));

        }

        codeResult.setFeature(FeatureCoderBase.toFeature(indices, values, pLenList, fields));
        codeResult.setFeatureSet(ret);
        return codeResult;
    }

    public static CodeResult codeOfEachField(List<FeatureBaseType> list, Map<String, String> staticFeatureMap, Map<String, String> dynamicFeatureMap) throws Exception {

        CodeResult codeResult = new CodeResult();

        List<Integer> indices = new ArrayList<>(F_MAX_SIZE);
        List<Double> values = new ArrayList<>(F_MAX_SIZE);
        List<String> fields = new ArrayList<>(F_MAX_SIZE);
        List<Set<Integer>> ret = new ArrayList<>(F_MAX_SIZE);

        if (staticFeatureMap == null) {
            staticFeatureMap = tmpMap;
        }
        if (dynamicFeatureMap == null) {
            dynamicFeatureMap = tmpMap;
        }

        Map<String, Map<Integer, Double>> fieldFeatureMap = new HashMap<>();

        for (FeatureBaseType featureBaseType : list) {

            String value = dynamicFeatureMap.get(featureBaseType.getName());
            if (value == null) {
                value = staticFeatureMap.get(featureBaseType.getName());
            }


            Set<Integer> retSub = featureBaseType.code(value);
            ret.add(retSub);
            List<Integer> retSubList = new ArrayList<>(retSub);

            Map<Integer, Double> subFieldFeatureMap = new HashMap<>();
            for (int i = 0; i < retSub.size(); i++) {
                indices.add(retSubList.get(i));

                double weight = MathUtil.division(1.0, retSub.size(), 6);
                values.add(weight);
                fields.add(featureBaseType.getName());

                subFieldFeatureMap.put(retSubList.get(i), weight);

            }

            fieldFeatureMap.put(featureBaseType.getName(), subFieldFeatureMap);
        }

        codeResult.setFeature(FeatureCoderBase.toFeature(indices, values, fields, 10000 * 1000));
        codeResult.setFeatureSet(ret);
        codeResult.setFieldFeatureMap(fieldFeatureMap);
        return codeResult;
    }


    public static CodeResult codeOfEachField(List<FeatureBaseType> list, Map<String, String> featureMap) throws Exception {
        return codeOfEachField(list, featureMap, null);
    }

    public static CodeResult codeOfEachField(List<FeatureBaseType> list, FeatureMapDo featureMap) throws Exception {

        if (featureMap == null) {
            return codeOfEachField(list, null, null);
        } else {
            return codeOfEachField(list, featureMap.staticFeatureMap, featureMap.dynamicFeatureMap);
        }
    }

    public static Map<String, Set<String>> getFeatures(List<FeatureBaseType> list, Map<String, String> featureMap) throws Exception {
        Map<String, Set<String>> ret = new HashMap<>();

        for (FeatureBaseType featureBaseType : list) {

            String value = featureMap.get(featureBaseType.getName());

            Set<String> retSub = featureBaseType.parseFeatureValues(value);

            ret.put(featureBaseType.getName(), retSub);
        }
        return ret;
    }

    public static void main(String[] args) {
        Map<String, String> featureMap = new HashMap<>();
        featureMap.put("f101001", "16601,18491,23105,24732,7967,300");
        featureMap.put("f101002", "100");
        featureMap.put("f305001", "8");
        featureMap.put("f501001", "UNKONWN");
        featureMap.put(null, "2");


        FeatureBaseType featureBaseType1 = new FeatureBaseType();
        featureBaseType1.setCodeType(11);
        featureBaseType1.setName("f101001");
        featureBaseType1.setDenseLen(10000);
        featureBaseType1.setSubLen(1000000);
        featureBaseType1.setHashNums(1);
        featureBaseType1.setSeq(",");

        FeatureBaseType featureBaseType2 = new FeatureBaseType();
        featureBaseType2.setCodeType(21);
        featureBaseType2.setName("f101002");
        featureBaseType2.setDenseLen(10000);
        featureBaseType2.setSubLen(100000);
        featureBaseType2.setHashNums(1);
        featureBaseType2.setSeq(",");


        List<FeatureBaseType> list = Arrays.asList(featureBaseType1, featureBaseType2);

        System.out.println(JSON.toJSONString(featureMap));
        try {
            String a = null;
            String b = null;
            System.out.println(JSON.toJSONString(FeatureCoder.code(list, featureMap)));

        } catch (Exception e) {

        }


    }

}
