package cn.com.duiba.nezha.alg.feature.coder;


import cn.com.duiba.nezha.alg.feature.util.HashUtil;
import com.alibaba.fastjson.JSON;
import org.slf4j.LoggerFactory;

import java.util.*;

public class FeatureUtil {

    //    public static Map<String, Map<Long, Set<String>>> hash = new HashMap<>();
    private static final org.slf4j.Logger logger = LoggerFactory.getLogger(FeatureUtil.class);


    public static int[] seed = {3, 7, 11, 17, 19, 31, 41};


    /**
     * 无调用
     */
//    public static void printConflictTest() {
//        for (String feature : hash.keySet()) {
//
//            int[] test = new int[100];
//            Map<Long, Set<String>> valMap = hash.get(feature);
//
//            boolean status = false;
//            for (Long fId : valMap.keySet()) {
//                int setSize = Math.min(valMap.get(fId).size(), 99);
//                test[setSize] = test[setSize] + 1;
//                if (setSize > 1) {
//                    status = true;
//                    System.out.println("feature=" + feature + ",fId=" + fId + ",set=" + JSON.toJSONString(valMap.get(fId)));
//                }
//
//            }
//
//
//            System.out.println("feature=" + feature + ",conflict status=" + JSON.toJSONString(test));
//
//
//        }
//    }

//    public static void addHashConflictTest(String feature, String fStr, Long fId) {

//        if (hash.get(feature) == null) {
//            hash.put(feature, new HashMap<>());
//        }
//
//        if (hash.get(feature).get(fId) == null) {
//            hash.get(feature).put(fId, new HashSet<>());
//        }
//        hash.get(feature).get(fId).add(fStr);

//    }
    public static int[] getHashSubFId(String feature, String str, int size, int nums) throws Exception {

        if (nums > seed.length) {
            logger.warn("nums is larger than seed size,invalid");
            return null;
        }
        str = std(str);
        int[] ret = new int[nums];
        for (int i = 0; i < nums; i++) {
            ret[i] = i * size + HashUtil.hash(str, size, seed[i]);

//            System.out.println("featureId="+feature+",str="+str+",ret="+ret[i]);

//            addHashConflictTest(feature, str, ret[i] + 0L);
        }
        Arrays.sort(ret);


        return ret;
    }

    public static int[] getHashSubFIdNotSort(String feature, String str, int size, int nums) throws Exception {

        if (nums > seed.length) {
            logger.warn("nums is larger than seed size,invalid");
            return null;
        }
        str = std(str);
        int[] ret = new int[nums];
        for (int i = 0; i < nums; i++) {
            ret[i] = i * size + HashUtil.hash(str, size, seed[i]);

//            System.out.println("featureId="+feature+",str="+str+",ret="+ret[i]);

//            addHashConflictTest(feature, str, ret[i] + 0L);
        }

        return ret;
    }


    public static int[] getHashSubFIds(String feature, String[] str, int size, int nums) throws Exception {

        if (nums > seed.length) {
            logger.warn("hash nums is larger than seed size,invalid");
            return null;
        }

        if (str == null || str.length == 0) {
            str = new String[]{null};
        }


        Set<Integer> set = new HashSet<>();

        for (int i = 0; i < str.length; i++) {
            int[] tmp = getHashSubFIdNotSort(feature, str[i], size, nums);
            for (int j = 0; j < tmp.length; j++) {
                set.add(tmp[j]);
            }
        }


        Integer[] retI = set.toArray(new Integer[set.size()]);

        int[] ret = new int[retI.length];
        for (int i = 0; i < retI.length; i++) {
            ret[i] = retI[i];
        }

        Arrays.sort(ret);
        return ret;
    }


    public static int[] getHashSubFIdsWithSeq(String feature, String[] str, int size, int nums) throws Exception {

        if (nums > seed.length) {
            logger.warn("hash nums is larger than seed size,invalid");
            return null;
        }

        if (str == null || str.length == 0) {
            str = new String[]{null};
        }


        Set<Integer> set = new HashSet<>();
        List<Integer> list = new ArrayList<>();

        for (int i = 0; i < str.length; i++) {
            int[] tmp = getHashSubFIdNotSort(feature, str[i], size, nums);
            for (int j = 0; j < tmp.length; j++) {

                if (!set.contains(tmp[j])) {
                    set.add(tmp[j]);
                    list.add(tmp[j]);
                }
            }
        }

        int[] ret = new int[list.size()];
        for (int i = 0; i < list.size(); i++) {
            ret[i] = list.get(i);
        }
        return ret;
    }


    public static int getDictSubFId(String feature, String str, int size, Map<String, Integer> dict) throws Exception {
        int ret = 0;
        str = stdDictKey(str);
        if (dict != null && str != null) {

            Integer tmp = dict.getOrDefault(str, 0);
            ret = tmp;
        }
//        addHashConflictTest(feature, str, ret + 0L);
        return ret;
    }

    public static int[] getDictSubFIds(String feature, String[] str, int size, Map<String, Integer> dict) throws Exception {

        if (str == null) {
            str = new String[]{null};
        }

        Set<Integer> set = new HashSet<>();

        for (int i = 0; i < str.length; i++) {
            int tmp = getDictSubFId(feature, str[i], size, dict);
            set.add(tmp);
        }
        Integer[] retI = set.toArray(new Integer[set.size()]);

        int[] ret = new int[retI.length];
        for (int i = 0; i < retI.length; i++) {
            ret[i] = retI[i];
        }

        Arrays.sort(ret);
        return ret;

    }

    public static int[] getDictSubFIdsWithSeq(String feature, String[] str, int size, Map<String, Integer> dict) throws Exception {

        if (str == null) {
            str = new String[]{null};
        }

        Set<Integer> set = new HashSet<>();
        List<Integer> list = new ArrayList<>();

        for (int i = 0; i < str.length; i++) {
            int tmp = getDictSubFId(feature, str[i], size, dict);

            if (!set.contains(tmp)) {
                set.add(tmp);
                list.add(tmp);
            }
        }

        int[] ret = new int[list.size()];
        for (int i = 0; i < list.size(); i++) {
            ret[i] = list.get(i);
        }
        return ret;

    }

    public static int[] getSubFIds(String feature, String[] str, int size) throws Exception {

        if (str == null) {
            str = new String[]{null};
        }
        Set<Integer> set = new HashSet<>();
        for (int i = 0; i < str.length; i++) {
            int tmp = getSubFId(feature, str[i], size);
            set.add(tmp);
        }
        Integer[] retI = set.toArray(new Integer[set.size()]);

        int[] ret = new int[retI.length];
        for (int i = 0; i < retI.length; i++) {
            ret[i] = retI[i];
        }
        Arrays.sort(ret);
        return ret;
    }

    public static int[] getSubFIdsWithSeq(String feature, String[] str, int size) throws Exception {

        if (str == null) {
            str = new String[]{null};
        }
        Set<Integer> set = new HashSet<>();
        List<Integer> list = new ArrayList<>();
        for (int i = 0; i < str.length; i++) {

            int tmp = getSubFId(feature, str[i], size);
            if (!set.contains(tmp)) {
                set.add(tmp);
                list.add(tmp);
            }
        }

        int[] ret = new int[list.size()];
        for (int i = 0; i < list.size(); i++) {
            ret[i] = list.get(i);
        }

        return ret;
    }


    public static int getSubFId(String feature, String str, int size) {
        int ret = 0;
        str = std(str);

        try {
            if (str != null) {
                Integer tmp = Integer.valueOf(str);

                if (tmp != null && tmp >= 0) {
//                System.out.println(((size - 1) + tmp.intValue()) & (size - 1));
                    ret = ((size - 1) + tmp) % (size - 1);
                    ret += 1;
                }
            }
        } catch (Exception e) {
            logger.warn("getSubFId() Integer.valueOf(str) happend error ,feature=" + feature + ",str=" + str, e);
        }

//        addHashConflictTest(feature, str, ret + 0L);
        return ret;
    }
//
//    public static Integer getNewSubFId(String feature, String str, int size) throws Exception {
//        Integer ret = 0;
//        str = std(str);
//
//        if (str != null) {
//            Integer tmp = Integer.valueOf(str);
//
//            if (tmp != null && tmp >= 0) {
////                System.out.println(((size - 1) + tmp.intValue()) & (size - 1));
//                ret = ((size - 1) + tmp) % (size - 1);
//                ret += 1;
//            }
//        }
////        addHashConflictTest(feature, str, ret + 0L);
//        return ret;
//    }


    public static int getDenseFId(String feature, String str, int size) throws Exception {
        int ret = 0;
        str = std(str);

        if (str != null) {
            ret = 1;
        }

//        addHashConflictTest(feature, str, ret + 0L);
        return ret;
    }

    public static String std(String oStr) {
        if (oStr == null) {
            return null;
        }
        String lowStr = oStr.toLowerCase();
        if (lowStr.length() == 0 ||
                lowStr.equals("\\n") ||
                lowStr.equals("\n") ||
                lowStr.equals("null") ||
                lowStr.equals("none")
                ) {
            return null;
        }
        return lowStr;
    }

    public static String stdDictKey(String oStr) {
        if (oStr == null) {
            return null;
        }
        String lowStr = std(oStr);
        if (lowStr != null && lowStr.length() > 0) {
            return lowStr.replace(".", "#");
        }
        return lowStr;
    }

    public static String[] toFeatures(String str, String seq) throws Exception {
        String[] ret = null;
        if (str != null) {
            ret = str.split(seq, 0);
        }
        return ret;
    }


}
