/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.alg.feature.parse;

import cn.com.duiba.nezha.alg.common.enums.DateStyle;
import cn.com.duiba.nezha.alg.common.util.AssertUtil;
import cn.com.duiba.nezha.alg.common.util.DataUtil;
import cn.com.duiba.nezha.alg.common.util.LocalDateUtil;
import cn.com.duiba.nezha.alg.feature.parse.FeatureBaseParse;
import cn.com.duiba.nezha.alg.feature.parse.FeatureParse;
import cn.com.duiba.nezha.alg.feature.vo.AdxFeatureDo;
import cn.com.duiba.nezha.alg.feature.vo.AdxIdeaMaterialDo;
import cn.com.duiba.nezha.alg.feature.vo.AiQiYiFeature;
import cn.com.duiba.nezha.alg.feature.vo.BaiDuFeature;
import cn.com.duiba.nezha.alg.feature.vo.DmpFeature;
import cn.com.duiba.nezha.alg.feature.vo.MgTvFeature;
import com.alibaba.fastjson.JSON;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AdxFeatureParse {
    public static int F_MAX_SIZE = 64;
    private static final Logger logger = LoggerFactory.getLogger(AdxFeatureParse.class);
    public static Integer[] HUABEI_REGION = new Integer[]{80, 11, 12, 13, 14, 15};
    public static Integer[] DONGBEI_REGION = new Integer[]{81, 21, 22, 23};
    public static Integer[] HUADONG_REGION = new Integer[]{82, 31, 32, 33, 34, 35, 36, 37};
    public static Integer[] HUAZHONG_REGION = new Integer[]{83, 41, 42, 43};
    public static Integer[] HUANAN_REGION = new Integer[]{84, 44, 45, 46};
    public static Integer[] XINAN_REGION = new Integer[]{85, 50, 51, 52, 53, 54};
    public static Integer[] XIBEI_REGION = new Integer[]{86, 61, 62, 63, 64, 65};
    public static Integer[] HMT_REGION = new Integer[]{87, 71, 8100, 8200};
    public static Integer[] FIRST_TIER_CITY = new Integer[]{11, 12, 31, 50, 2101, 3201, 3202, 3205, 3301, 3302, 3702, 4101, 4201, 4301, 4401, 4403, 4419, 5101, 6101};
    public static Integer[] SECOND_TIER_CITY = new Integer[]{1301, 1306, 1401, 2102, 2201, 2301, 3203, 3204, 3206, 3303, 3304, 3306, 3307, 3310, 3401, 3501, 3502, 3505, 3601, 3701, 3706, 3707, 4406, 4413, 4420, 4501, 5201, 5301, 6201, 6501};
    public static Integer[] THIRD_TIER_CITY = new Integer[]{1309, 1303, 1502, 2202, 3207, 3209, 3305, 3412, 3509, 3611, 3708, 3703, 4114, 4110, 4210, 4307, 4306, 4407, 4408, 4601, 5107, 6104, 1304, 1302, 1501, 2306, 3212, 3210, 3403, 3407, 3503, 3607, 3609, 3713, 4103, 4107, 4108, 4206, 4304, 4302, 4452, 4412, 4503, 4602, 5203, 6301, 1310, 1305, 2103, 3208, 3213, 3211, 3411, 3402, 3506, 3604, 3717, 3710, 4113, 4115, 4211, 4205, 4303, 4451, 4405, 4404, 4502, 5106, 5303, 6401};
    public static int[] cntBucket = new int[]{0, 1, 3, 5, 10, 15, 20};
    public static Map<String, Integer> videoChannelCodes = new HashMap<String, Integer>(){
        {
            this.put("aiqiyi--1", 0);
            this.put("aiqiyi-0", 1);
            this.put("aiqiyi-1", 2);
            this.put("aiqiyi-2", 3);
            this.put("aiqiyi-3", 4);
            this.put("aiqiyi-4", 5);
            this.put("aiqiyi-5", 6);
            this.put("aiqiyi-6", 7);
            this.put("aiqiyi-7", 8);
            this.put("aiqiyi-8", 9);
            this.put("aiqiyi-9", 10);
            this.put("aiqiyi-10", 11);
            this.put("aiqiyi-11", 12);
            this.put("aiqiyi-12", 13);
            this.put("aiqiyi-13", 14);
            this.put("aiqiyi-14", 15);
            this.put("aiqiyi-15", 16);
            this.put("aiqiyi-16", 17);
            this.put("aiqiyi-17", 18);
            this.put("aiqiyi-18", 19);
            this.put("aiqiyi-19", 20);
            this.put("aiqiyi-20", 21);
            this.put("aiqiyi-21", 22);
            this.put("aiqiyi-22", 23);
            this.put("aiqiyi-23", 24);
            this.put("aiqiyi-24", 25);
            this.put("aiqiyi-25", 26);
            this.put("aiqiyi-26", 27);
            this.put("aiqiyi-27", 28);
            this.put("aiqiyi-28", 29);
            this.put("aiqiyi-29", 30);
            this.put("aiqiyi-30", 31);
            this.put("aiqiyi-31", 32);
            this.put("aiqiyi-32", 33);
            this.put("aiqiyi-33", 34);
            this.put("aiqiyi-34", 35);
            this.put("aiqiyi-89", 36);
            this.put("aiqiyi-91", 37);
            this.put("aiqiyi-92", 38);
            this.put("aiqiyi-96", 39);
            this.put("aiqiyi-97", 40);
            this.put("aiqiyi-99", 41);
            this.put("aiqiyi-8198", 42);
            this.put("aiqiyi-30001", 43);
            this.put("aiqiyi-30002", 44);
            this.put("aiqiyi-30003", 45);
            this.put("aiqiyi-30004", 46);
            this.put("aiqiyi-30005", 47);
            this.put("aiqiyi-30006", 48);
            this.put("aiqiyi-30007", 49);
            this.put("aiqiyi-30008", 50);
            this.put("aiqiyi-30009", 51);
            this.put("aiqiyi-30010", 52);
            this.put("aiqiyi-30011", 53);
            this.put("aiqiyi-30012", 54);
            this.put("aiqiyi-30013", 55);
            this.put("aiqiyi-30014", 56);
            this.put("aiqiyi-30015", 57);
            this.put("aiqiyi-30016", 58);
            this.put("aiqiyi-30017", 59);
            this.put("aiqiyi-30018", 60);
            this.put("aiqiyi-30019", 61);
            this.put("aiqiyi-30020", 62);
            this.put("aiqiyi-30021", 63);
            this.put("aiqiyi-30022", 64);
            this.put("aiqiyi-30030", 65);
            this.put("aiqiyi-40000", 66);
            this.put("aiqiyi-40001", 67);
            this.put("aiqiyi-40002", 68);
            this.put("aiqiyi-40004", 69);
            this.put("aiqiyi-49999", 70);
            this.put("aiqiyi-50000", 71);
            this.put("aiqiyi-50001", 72);
            this.put("aiqiyi-70001", 73);
            this.put("aiqiyi-70002", 74);
            this.put("aiqiyi-70003", 75);
            this.put("mango-0", 100);
            this.put("mango-1", 101);
            this.put("mango-2", 102);
            this.put("mango-3", 103);
            this.put("mango-20", 104);
            this.put("mango-50", 105);
            this.put("mango-51", 106);
            this.put("mango-99", 107);
            this.put("mango-104", 108);
            this.put("mango-105", 109);
            this.put("mango-106", 110);
            this.put("mango-111", 111);
            this.put("mango-115", 112);
            this.put("mango-116", 113);
            this.put("mango-117", 114);
            this.put("mango-118", 115);
            this.put("mango-120", 116);
        }
    };

    public static Map<String, String> generateFeatureMapStatic(AdxFeatureDo cf) {
        HashMap<String, String> retMap = new HashMap<String, String>(F_MAX_SIZE);
        try {
            if (cf != null) {
                cf.setCurrentCreatTime(AdxFeatureParse.getStringToTimeStamp());
                retMap.put("f1010010", DataUtil.Long2String((Long)cf.getGroupId()));
                retMap.put("f1010020", DataUtil.Integer2String((Integer)cf.getAdxType()));
                retMap.put("f1010030", cf.getCat());
                retMap.put("f1010031", cf.getTuiaCat());
                retMap.put("f1010040", cf.getSectionCat());
                retMap.put("f1010041", cf.getTuiaSectionCat());
                retMap.put("f1010050", cf.getKeywords());
                retMap.put("f2010010", DataUtil.Long2String((Long)cf.getResourceId()));
                retMap.put("f2010020", DataUtil.Integer2String((Integer)cf.getAdvertType()));
                retMap.put("f2010030", DataUtil.Integer2String((Integer)cf.getPosType()));
                retMap.put("f2010040", DataUtil.Integer2String((Integer)cf.getPosStyle()));
                retMap.put("f2010050", cf.getSpecCode());
                retMap.put("f3020000", DataUtil.Integer2String((Integer)cf.getPmpType()));
                retMap.put("f3020010", DataUtil.Long2String((Long)cf.getDealId()));
                retMap.put("f3020020", DataUtil.Long2String((Long)cf.getPrice()));
                retMap.put("f4010010", cf.getUa());
                retMap.put("f4010020", cf.getIp());
                retMap.put("f4010030", DataUtil.Long2String((Long)cf.getAreaCode()));
                Long regionLevel = AdxFeatureParse.getRegionLevel(cf.getAreaCode());
                retMap.put("f4010031", DataUtil.Long2String((Long)regionLevel));
                Long tierCityLevel = AdxFeatureParse.getTierCityLevel(cf.getAreaCode());
                retMap.put("f4010032", DataUtil.Long2String((Long)tierCityLevel));
                retMap.put("f4010040", DataUtil.Integer2String((Integer)cf.getDeviceType()));
                retMap.put("f4010041", DataUtil.Integer2String((Integer)cf.getTuiaDeviceType()));
                retMap.put("f4010050", cf.getMake());
                retMap.put("f4010060", cf.getModel());
                retMap.put("f4010070", cf.getOs());
                retMap.put("f4010080", cf.getCarrier());
                retMap.put("f4010090", DataUtil.Integer2String((Integer)cf.getConnectionType()));
                retMap.put("f4010091", DataUtil.Integer2String((Integer)cf.getTuiaConnectionType()));
                retMap.put("f4010100", AdxFeatureParse.getFloat2String(cf.getLat()));
                retMap.put("f4010110", AdxFeatureParse.getFloat2String(cf.getLon()));
                Integer hour = AdxFeatureParse.getTimeStampToHour(cf.getCurrentCreatTime());
                retMap.put("f4010121", DataUtil.Integer2String((Integer)hour));
                Integer weekDay = AdxFeatureParse.getTimeStampToWeekDay(cf.getCurrentCreatTime());
                retMap.put("f4010122", DataUtil.Integer2String((Integer)weekDay));
                retMap.put("f5010020", cf.getInterestKeyWords());
                retMap.put("f5010050", cf.getImei());
                retMap.put("f6010010", cf.getAppName());
                retMap.put("f6010020", cf.getAppBundle());
                retMap.put("f6010030", cf.getAppPageCat());
                retMap.put("f6010040", DataUtil.Integer2String((Integer)cf.getAppPaid()));
                retMap.put("f6010050", cf.getGeoCountry());
                retMap.put("f6010060", cf.getGeoRegion());
                retMap.put("f6010070", cf.getGeoCity());
                retMap.put("f6010080", DataUtil.Integer2String((Integer)cf.getGeoType()));
                retMap.put("f6010090", cf.getTagId());
                retMap.put("f6010100", DataUtil.Integer2String((Integer)cf.getTagIndex()));
                retMap.put("f6010110", cf.getAppIndustryId());
                if (cf.getStyleStandard() != null) {
                    retMap.put("f3010130", DataUtil.Integer2String((Integer)cf.getStyleStandard()));
                }
                AiQiYiFeature aiQiYiFeature = Optional.ofNullable(cf.getAiQiYiFeature()).orElse(new AiQiYiFeature());
                MgTvFeature mgTvFeature = Optional.ofNullable(cf.getMgTvFeature()).orElse(new MgTvFeature());
                BaiDuFeature baiDuFeature = Optional.ofNullable(cf.getBaiDuFeature()).orElse(new BaiDuFeature());
                retMap.put("f6020010", FeatureBaseParse.getAnyValue(cf.getAdxType(), aiQiYiFeature.getTitle(), mgTvFeature.getVideoName(), baiDuFeature.getTitle()));
                retMap.put("f6020020", FeatureBaseParse.getAnyValue(cf.getAdxType(), aiQiYiFeature.getUrl(), mgTvFeature.getVideoUrl(), baiDuFeature.getUrl()));
                retMap.put("f6020030", FeatureBaseParse.getAnyValue(cf.getAdxType(), aiQiYiFeature.getLen(), mgTvFeature.getDuration(), baiDuFeature.getContentLength()));
                retMap.put("f6020040", FeatureBaseParse.getCrossAnyValue(cf.getAdxType(), cf.getGroupId(), aiQiYiFeature.getChannelId(), mgTvFeature.getChannelId(), baiDuFeature.getChannelId()));
                retMap.put("f6020050", FeatureBaseParse.getCrossAnyValue(cf.getAdxType(), cf.getGroupId(), aiQiYiFeature.getAdTypeId(), mgTvFeature.getLocation(), baiDuFeature.getAdSlotType()));
                retMap.put("f6020060", FeatureBaseParse.getCrossAnyValue(cf.getAdxType(), cf.getGroupId(), aiQiYiFeature.getCountry(), null, null));
                retMap.put("f6020070", FeatureBaseParse.getCrossAnyValuePlus(cf.getAdxType(), cf.getGroupId(), aiQiYiFeature.getMetro(), null, baiDuFeature.getProvince()));
                retMap.put("f6020080", FeatureBaseParse.getCrossAnyValuePlus(cf.getAdxType(), cf.getGroupId(), aiQiYiFeature.getCity(), mgTvFeature.getCityCode(), baiDuFeature.getCity()));
                retMap.put("f6020090", FeatureBaseParse.getCrossAnyValuePlus(cf.getAdxType(), cf.getGroupId(), null, null, baiDuFeature.getDistrict()));
                retMap.put("f6020100", FeatureBaseParse.getCrossAnyValuePlus(cf.getAdxType(), cf.getGroupId(), null, null, baiDuFeature.getStreet()));
                retMap.put("f6030010", DataUtil.Integer2String((Integer)aiQiYiFeature.getAlbumId()));
                retMap.put("f6030020", DataUtil.Integer2String((Integer)aiQiYiFeature.getPlatformId()));
                retMap.put("f6040010", DataUtil.Integer2String((Integer)mgTvFeature.getVideoId()));
                retMap.put("f6040020", DataUtil.Integer2String((Integer)mgTvFeature.getCollectionId()));
                retMap.put("f6040030", mgTvFeature.getCollectionName());
                retMap.put("f6040040", mgTvFeature.getItemIds());
                retMap.put("f6040050", mgTvFeature.getItemNames());
                retMap.put("f6040060", DataUtil.Integer2String((Integer)mgTvFeature.getAreaId()));
                retMap.put("f6040070", mgTvFeature.getAreaName());
                retMap.put("f6040080", DataUtil.Integer2String((Integer)mgTvFeature.getYear()));
                retMap.put("f6040090", DataUtil.Integer2String((Integer)mgTvFeature.getVideoType()));
                retMap.put("f6050010", DataUtil.Integer2String((Integer)baiDuFeature.getPageType()));
                retMap.put("f6050020", baiDuFeature.getUserTagIdList());
                DmpFeature dmpFeature = Optional.ofNullable(cf.getDmpFeature()).orElse(new DmpFeature());
                retMap.put("f5010010", FeatureBaseParse.getDmpSexData(dmpFeature.getSex(), cf.getGender()));
                retMap.put("f5010030", FeatureBaseParse.getDmpData(dmpFeature.getAge(), cf.getYob()));
                retMap.put("f5010031", dmpFeature.getMarry());
                Long imeiDayBidTimes = AdxFeatureParse.getImeiDayTimes(cf.getImei(), 50L, cf.getImeiDayBidTimes());
                Long imeiDayBid = FeatureBaseParse.getCntLevel(dmpFeature.getImeiDayBidTimes(), 50L);
                retMap.put("f5010060", DataUtil.Long2String((Long)FeatureBaseParse.getDmpData(imeiDayBid, imeiDayBidTimes)));
                Long imeiDayExpTimes = AdxFeatureParse.getImeiDayTimes(cf.getImei(), 7L, cf.getImeiDayExpTimes());
                Long imeiDayExp = FeatureBaseParse.getCntLevel(dmpFeature.getImeiDayExpTimes(), 7L);
                retMap.put("f5010070", DataUtil.Long2String((Long)FeatureBaseParse.getDmpData(imeiDayExp, imeiDayExpTimes)));
                Long resoDayBidTimes = AdxFeatureParse.getResoDayTimes(cf.getResourceId(), cf.getImei(), 50L, cf.getResoDayBidTimes());
                Long resoDayBid = FeatureBaseParse.getCntLevel(dmpFeature.getResoDayBidTimes(), 50L);
                retMap.put("f5010080", DataUtil.Long2String((Long)FeatureBaseParse.getDmpData(resoDayBid, resoDayBidTimes)));
                Long resoDayExpTimes = AdxFeatureParse.getResoDayTimes(cf.getResourceId(), cf.getImei(), 7L, cf.getResoDayExpTimes());
                Long resoDayExp = FeatureBaseParse.getCntLevel(dmpFeature.getResoDayExpTimes(), 7L);
                retMap.put("f5010090", DataUtil.Long2String((Long)FeatureBaseParse.getDmpData(resoDayExp, resoDayExpTimes)));
                retMap.put("f5020010", FeatureBaseParse.getLTimesLevel(dmpFeature.getHistoryGroBid()));
                retMap.put("f5020020", FeatureBaseParse.getMTimesLevel(dmpFeature.getHistoryGroExp()));
                retMap.put("f5020030", FeatureBaseParse.getSTimesLevel(dmpFeature.getHistoryGroClick()));
                retMap.put("f5020040", FeatureBaseParse.getLTimesLevel(dmpFeature.getHistoryResoBid()));
                retMap.put("f5020050", FeatureBaseParse.getMTimesLevel(dmpFeature.getHistoryResoExp()));
                retMap.put("f5020060", FeatureBaseParse.getSTimesLevel(dmpFeature.getHistoryResoClick()));
                retMap.put("f5020070", FeatureBaseParse.getLTimesLevel(dmpFeature.getHistoryImeiBid()));
                retMap.put("f5020080", FeatureBaseParse.getMTimesLevel(dmpFeature.getHistoryImeiExp()));
                retMap.put("f5020090", FeatureBaseParse.getSTimesLevel(dmpFeature.getHistoryImeiClick()));
                retMap.put("f5020101", FeatureBaseParse.getCrossLevel(dmpFeature.getHistoryImeiBid(), dmpFeature.getHistoryImeiExp()));
                retMap.put("f5020102", FeatureBaseParse.getCrossLevel(dmpFeature.getHistoryImeiBid(), dmpFeature.getHistoryImeiClick()));
                retMap.put("f5020103", FeatureBaseParse.getCrossLevel(dmpFeature.getHistoryImeiExp(), dmpFeature.getHistoryImeiClick()));
                retMap.put("f5020104", FeatureBaseParse.getExpClickCrossValue(dmpFeature.getHistoryGroClick(), dmpFeature.getHistoryGroExp()));
                retMap.put("f5020105", FeatureBaseParse.getExpClickCrossValue(dmpFeature.getHistoryResoClick(), dmpFeature.getHistoryResoExp()));
                retMap.put("f5020106", FeatureBaseParse.getExpClickCrossValue(dmpFeature.getHistoryImeiClick(), dmpFeature.getHistoryImeiExp()));
                retMap.put("f5030101", FeatureBaseParse.getComCrossValue(cf.getGroupId(), dmpFeature.getHistoryImeiClick(), dmpFeature.getHistoryImeiExp()));
                retMap.put("f5030102", FeatureBaseParse.getComCrossValue(cf.getResourceId(), dmpFeature.getHistoryImeiClick(), dmpFeature.getHistoryImeiExp()));
                retMap.put("f5030103", FeatureBaseParse.getComCrossValue(cf.getIdeaId(), dmpFeature.getHistoryImeiClick(), dmpFeature.getHistoryImeiExp()));
                String userBasicTags = FeatureBaseParse.getDmpData(dmpFeature.getUserBasicTags(), cf.getUserTagsList());
                retMap.put("f7010010", userBasicTags);
                retMap.put("f7010011", FeatureBaseParse.getLengthLevel(userBasicTags, 50, 5));
                retMap.put("f7010013", dmpFeature.getTagCategory());
                String tagCategoryLevel = FeatureBaseParse.getCategoryLevel(dmpFeature.getTagCategory(), 10, 1);
                retMap.put("f7010014", tagCategoryLevel);
                String appList = FeatureBaseParse.getDmpData(dmpFeature.getAppList(), cf.getAppList());
                retMap.put("f7020010", appList);
                retMap.put("f7020011", FeatureBaseParse.getLengthLevel(appList, 5, 100, 5));
                retMap.put("f7020013", dmpFeature.getValidAppList());
                retMap.put("f7020014", dmpFeature.getTopAppList());
                retMap.put("f7020015", dmpFeature.getTopAppList2());
                retMap.put("f7020016", dmpFeature.getTopAppList3());
                retMap.put("f7020017", dmpFeature.getMidAppList());
                retMap.put("f7020018", dmpFeature.getInstallAppList());
                retMap.put("f7020019", dmpFeature.getUninstallAppList());
                retMap.put("f7020020", dmpFeature.getAppCategory());
                retMap.put("f7020021", dmpFeature.getTradeAppList());
                retMap.put("f7020022", dmpFeature.getAppVector());
                String appCategoryLevel = FeatureBaseParse.getCategoryLevel(dmpFeature.getAppCategory(), 10, 1);
                retMap.put("f7020023", appCategoryLevel);
                String sigList = FeatureBaseParse.getDmpData(dmpFeature.getSigList(), cf.getMessageNameList());
                retMap.put("f7030010", sigList);
                retMap.put("f7030011", FeatureBaseParse.getLengthLevel(sigList, 15, 1));
                retMap.put("f7030013", dmpFeature.getMsgCategory());
                retMap.put("f7030014", dmpFeature.getMsgKeyword());
                retMap.put("f7030016", dmpFeature.getMsgVector());
                Map recentVideoCatePrefMap = DataUtil.stringToMap((String)dmpFeature.getRecentVideoCatePref(), (Object)0);
                retMap.put("f7040010", FeatureParse.getUserCategoryActLevelByBucket(recentVideoCatePrefMap, FeatureParse.videoCateCodes, cntBucket));
                Map recentVideoChannelPrefMap = DataUtil.stringToMap((String)dmpFeature.getRecentVideoChannelPref(), (Object)0);
                retMap.put("f7040020", FeatureParse.getUserCategoryActLevelByBucket(recentVideoChannelPrefMap, videoChannelCodes, cntBucket));
                retMap.put("f7040030", dmpFeature.getLastVideoCategory());
                retMap.put("f7040040", dmpFeature.getLastVideoChannel());
                retMap.put("f7040050", FeatureParse.bucket(dmpFeature.getWeekActivityRequest(), cntBucket).toString());
                retMap.put("f7040060", FeatureParse.bucket(dmpFeature.getDayActivityRequest(), cntBucket).toString());
                retMap.put("f7040070", dmpFeature.getPeriodActivityRequest());
                retMap.put("f7040080", FeatureParse.bucket(dmpFeature.getWeekActivityJoin(), cntBucket).toString());
                retMap.put("f7040090", FeatureParse.bucket(dmpFeature.getDayActivityJoin(), cntBucket).toString());
                retMap.put("f7040100", dmpFeature.getPeriodActivityJoin());
                retMap.put("f7040110", dmpFeature.getPeriodLaunchTrade());
                retMap.put("f7040120", dmpFeature.getClickLaunchTrade() == null ? null : dmpFeature.getClickLaunchTrade().toString());
                retMap.put("f7040130", dmpFeature.getPeriodClickTrade());
                retMap.put("f7040140", dmpFeature.getEffectClickTrade() == null ? null : dmpFeature.getEffectClickTrade().toString());
                retMap.put("f7050010", cf.getExpDayMaterials());
                retMap.put("f7050020", cf.getClickDayMaterials());
                retMap.put("f7050030", cf.getExpWeekMaterials());
                retMap.put("f7050040", cf.getClickWeekMaterials());
                retMap.put("f7060010", cf.getResoExpDayMaterials());
                retMap.put("f7060020", cf.getResoClickDayMaterials());
            }
        }
        catch (Exception e) {
            logger.error("AdxFeatureParse.generateFeatureMapStatic error:" + e);
        }
        return retMap;
    }

    public static Map<String, String> generateFeatureMapDynamic(AdxFeatureDo cf, AdxFeatureDo staticCf) {
        HashMap<String, String> retMap = new HashMap<String, String>(F_MAX_SIZE);
        try {
            if (cf != null) {
                retMap.put("f3010010", DataUtil.Long2String((Long)cf.getIdeaId()));
                retMap.put("f3010020", cf.getButtonText());
                retMap.put("f3010030", DataUtil.Integer2String((Integer)cf.getIconH(), (String)"0"));
                retMap.put("f3010040", DataUtil.Integer2String((Integer)cf.getIconW()));
                retMap.put("f3010050", DataUtil.Integer2String((Integer)cf.getMjPicType()));
                retMap.put("f3010060", DataUtil.Integer2String((Integer)cf.getIdeaPicH1()));
                retMap.put("f3010070", DataUtil.Integer2String((Integer)cf.getIdeaPicW1()));
                retMap.put("f3010080", DataUtil.Integer2String((Integer)cf.getIdeaPicH2()));
                retMap.put("f3010090", DataUtil.Integer2String((Integer)cf.getIdeaPicW2()));
                retMap.put("f3010100", DataUtil.Integer2String((Integer)cf.getIdeaPicH3()));
                retMap.put("f3010110", DataUtil.Integer2String((Integer)cf.getIdeaPicW3()));
                retMap.put("f3010120", DataUtil.Integer2String((Integer)cf.getIdeaPicNum()));
                retMap.put("f3010130", DataUtil.Integer2String((Integer)cf.getStyleStandard()));
                retMap.put("f3010140", DataUtil.Integer2String((Integer)cf.getIdeaType()));
                Long ideaExpTimes = AdxFeatureParse.getIdeaExpTime(cf.getIdeaId(), staticCf.getExpTimeMap());
                retMap.put("f5010040", DataUtil.Long2String((Long)ideaExpTimes));
                retMap.put("f3030000", DataUtil.Integer2String((Integer)cf.getPictureType()));
                List<AdxIdeaMaterialDo> pictureList = cf.getPictureMaterialDo();
                String picMaterialId = FeatureBaseParse.getMaterialFeature(pictureList, "materialId");
                retMap.put("f3030010", picMaterialId);
                retMap.put("f3030020", FeatureBaseParse.getMaterialFeature(pictureList, "effectType"));
                retMap.put("f3030030", FeatureBaseParse.getMaterialFeature(pictureList, "figureType"));
                retMap.put("f3030040", FeatureBaseParse.getMaterialFeature(pictureList, "customType"));
                retMap.put("f3030050", FeatureBaseParse.getMaterialFeature(pictureList, "materialIndustryTag"));
                retMap.put("f3030060", FeatureBaseParse.getMaterialFeature(pictureList, "slotType"));
                retMap.put("f3030070", FeatureBaseParse.getMaterialFeature(pictureList, "materialStrategy"));
                retMap.put("f3030080", FeatureBaseParse.getMaterialFeature(pictureList, "prizeElement"));
                retMap.put("f3030090", FeatureBaseParse.getMaterialFeature(pictureList, "designColor"));
                retMap.put("f3030100", FeatureBaseParse.getMaterialFeature(pictureList, "designStyle"));
                retMap.put("f3030110", FeatureBaseParse.getMaterialFeature(pictureList, "dynamicEffect"));
                retMap.put("f3030120", FeatureBaseParse.getMaterialFeature(pictureList, "textElement"));
                retMap.put("f3030130", FeatureBaseParse.getMaterialFeature(pictureList, "activityTool"));
                retMap.put("f3030140", FeatureBaseParse.getMaterialFeature(pictureList, "season"));
                retMap.put("f3030150", FeatureBaseParse.getMaterialFeature(pictureList, "festival"));
                retMap.put("f3030160", FeatureBaseParse.getMaterialFeature(pictureList, "timing"));
                retMap.put("f3030170", FeatureBaseParse.getMaterialFeature(pictureList, "scene"));
                retMap.put("f3030180", FeatureBaseParse.getMaterialFeature(pictureList, "adxRatioType"));
                List<AdxIdeaMaterialDo> videoList = cf.getVideoMaterialDo();
                String videoMaterialId = FeatureBaseParse.getMaterialFeature(videoList, "materialId");
                retMap.put("f3030011", videoMaterialId);
                retMap.put("f3030021", FeatureBaseParse.getMaterialFeature(videoList, "effectType"));
                retMap.put("f3030031", FeatureBaseParse.getMaterialFeature(videoList, "figureType"));
                retMap.put("f3030041", FeatureBaseParse.getMaterialFeature(videoList, "customType"));
                retMap.put("f3030051", FeatureBaseParse.getMaterialFeature(videoList, "materialIndustryTag"));
                retMap.put("f3030061", FeatureBaseParse.getMaterialFeature(videoList, "slotType"));
                retMap.put("f3030071", FeatureBaseParse.getMaterialFeature(videoList, "materialStrategy"));
                retMap.put("f3030081", FeatureBaseParse.getMaterialFeature(videoList, "prizeElement"));
                retMap.put("f3030091", FeatureBaseParse.getMaterialFeature(videoList, "designColor"));
                retMap.put("f3030101", FeatureBaseParse.getMaterialFeature(videoList, "designStyle"));
                retMap.put("f3030111", FeatureBaseParse.getMaterialFeature(videoList, "dynamicEffect"));
                retMap.put("f3030121", FeatureBaseParse.getMaterialFeature(videoList, "textElement"));
                retMap.put("f3030131", FeatureBaseParse.getMaterialFeature(videoList, "activityTool"));
                retMap.put("f3030141", FeatureBaseParse.getMaterialFeature(videoList, "season"));
                retMap.put("f3030151", FeatureBaseParse.getMaterialFeature(videoList, "festival"));
                retMap.put("f3030161", FeatureBaseParse.getMaterialFeature(videoList, "timing"));
                retMap.put("f3030171", FeatureBaseParse.getMaterialFeature(videoList, "scene"));
                retMap.put("f3030181", FeatureBaseParse.getMaterialFeature(videoList, "adxRatioType"));
                retMap.put("f3040010", FeatureBaseParse.getMaterialFeature(pictureList, "maExpCntDay"));
                retMap.put("f3040011", FeatureBaseParse.getMaterialFeature(videoList, "maExpCntDay"));
                retMap.put("f3040012", FeatureBaseParse.getMaterialCntLevel(pictureList, "maExpCntDayLevel"));
                retMap.put("f3040013", FeatureBaseParse.getMaterialCntLevel(videoList, "maExpCntDayLevel"));
                retMap.put("f3040020", FeatureBaseParse.getMaterialFeature(pictureList, "maClickCntDay"));
                retMap.put("f3040021", FeatureBaseParse.getMaterialFeature(videoList, "maClickCntDay"));
                retMap.put("f3040022", FeatureBaseParse.getMaterialCntLevel(pictureList, "maClickCntDayLevel"));
                retMap.put("f3040023", FeatureBaseParse.getMaterialCntLevel(videoList, "maClickCntDayLevel"));
                retMap.put("f3040030", FeatureBaseParse.getMaterialFeature(pictureList, "maExpCnt3Day"));
                retMap.put("f3040031", FeatureBaseParse.getMaterialFeature(videoList, "maExpCnt3Day"));
                retMap.put("f3040032", FeatureBaseParse.getMaterialCntLevel(pictureList, "maExpCnt3DayLevel"));
                retMap.put("f3040033", FeatureBaseParse.getMaterialCntLevel(videoList, "maExpCnt3DayLevel"));
                retMap.put("f3040040", FeatureBaseParse.getMaterialFeature(pictureList, "maClickCnt3Day"));
                retMap.put("f3040041", FeatureBaseParse.getMaterialFeature(videoList, "maClickCnt3Day"));
                retMap.put("f3040042", FeatureBaseParse.getMaterialCntLevel(pictureList, "maClickCnt3DayLevel"));
                retMap.put("f3040043", FeatureBaseParse.getMaterialCntLevel(videoList, "maClickCnt3DayLevel"));
                retMap.put("f3050010", FeatureBaseParse.getMaterialFeature(pictureList, "maResoExpCntDay"));
                retMap.put("f3050011", FeatureBaseParse.getMaterialFeature(videoList, "maResoExpCntDay"));
                retMap.put("f3050012", FeatureBaseParse.getMaterialCntLevel(pictureList, "maResoExpCntDayLevel"));
                retMap.put("f3050013", FeatureBaseParse.getMaterialCntLevel(videoList, "maResoExpCntDayLevel"));
                retMap.put("f3050020", FeatureBaseParse.getMaterialFeature(pictureList, "maResoClickCntDay"));
                retMap.put("f3050021", FeatureBaseParse.getMaterialFeature(videoList, "maResoClickCntDay"));
                retMap.put("f3050022", FeatureBaseParse.getMaterialCntLevel(pictureList, "maResoClickCntDayLevel"));
                retMap.put("f3050023", FeatureBaseParse.getMaterialCntLevel(videoList, "maResoClickCntDayLevel"));
                retMap.put("f3050030", FeatureBaseParse.getMaterialFeature(pictureList, "maResoExpCnt3Day"));
                retMap.put("f3050031", FeatureBaseParse.getMaterialFeature(videoList, "maResoExpCnt3Day"));
                retMap.put("f3050032", FeatureBaseParse.getMaterialCntLevel(pictureList, "maResoExpCnt3Day"));
                retMap.put("f3050033", FeatureBaseParse.getMaterialCntLevel(videoList, "maResoExpCnt3Day"));
                retMap.put("f3050040", FeatureBaseParse.getMaterialFeature(pictureList, "maResoClickCnt3Day"));
                retMap.put("f3050041", FeatureBaseParse.getMaterialFeature(videoList, "maResoClickCnt3Day"));
                retMap.put("f3050042", FeatureBaseParse.getMaterialCntLevel(pictureList, "maResoClickCnt3Day"));
                retMap.put("f3050043", FeatureBaseParse.getMaterialCntLevel(videoList, "maResoClickCnt3Day"));
                String lastExpMaterialId = DataUtil.Long2String((Long)staticCf.getLastExpMaterialId());
                retMap.put("f7060030", lastExpMaterialId);
                String lastExpEqualStatus = AdxFeatureParse.getLastEqualStatus(picMaterialId, videoMaterialId, lastExpMaterialId);
                retMap.put("f7060031", lastExpEqualStatus);
                String lastClickMaterialId = DataUtil.Long2String((Long)staticCf.getLastClickMaterialId());
                retMap.put("f7060040", lastClickMaterialId);
                String lastClickEqualStatus = AdxFeatureParse.getLastEqualStatus(picMaterialId, videoMaterialId, lastClickMaterialId);
                retMap.put("f7060041", lastClickEqualStatus);
            }
        }
        catch (Exception e) {
            logger.error("AdxFeatureParse.generateFeatureMapDynamic error:", (Throwable)e);
        }
        return retMap;
    }

    public static Integer getTimeStampToHour(Long timeStamp) {
        LocalDateTime localDate;
        Date date;
        Integer ret = null;
        if (timeStamp != null && (date = new Date(timeStamp)) != null && (localDate = LocalDateUtil.dateToLocal((Date)date)) != null) {
            ret = LocalDateUtil.getHour((LocalDateTime)localDate);
        }
        return ret;
    }

    public static Integer getTimeStampToWeekDay(Long timeStamp) {
        LocalDateTime localDate;
        Date date;
        Integer ret = null;
        if (timeStamp != null && (date = new Date(timeStamp)) != null && (localDate = LocalDateUtil.dateToLocal((Date)date)) != null) {
            ret = LocalDateUtil.getDayOfWeek((LocalDateTime)localDate);
        }
        return ret;
    }

    public static Long getStringToTimeStamp() {
        Long ret = null;
        String currentTime = LocalDateUtil.getCurrentLocalDateTime((String)DateStyle.YYYY_MM_DD_HH_MM_SS.getValue());
        if (currentTime != null) {
            ret = LocalDateUtil.getTimeMillis((String)currentTime, (String)DateStyle.YYYY_MM_DD_HH_MM_SS.getValue());
        }
        return ret;
    }

    public static String getFloat2String(Float src) {
        String ret = null;
        if (src != null) {
            ret = Float.toString(src.floatValue());
        }
        return ret;
    }

    public static Long getObject2Long(Object src) {
        Long ret = null;
        if (AssertUtil.isNotEmpty((Object)src)) {
            ret = DataUtil.string2Long((String)String.valueOf(src));
        }
        return ret;
    }

    public static Long getIdeaExpTime(Long ideaId, Map<Long, Object> expTimeMap) {
        Long ret = null;
        if (AssertUtil.isAllNotEmpty((Object[])new Object[]{ideaId, expTimeMap})) {
            Long cnt = AdxFeatureParse.getObject2Long(expTimeMap.get(ideaId));
            ret = cnt == null || cnt < 1L ? Long.valueOf(0L) : (cnt <= 7L ? cnt : Long.valueOf(-1L));
        }
        return ret;
    }

    public static Long getRegionLevel(Long areaCode) {
        Long ret = null;
        if (AssertUtil.isNotEmpty((Object)areaCode)) {
            int area = DataUtil.toInt((Long)areaCode);
            if (areaCode >= 1000L && areaCode != 8100L && areaCode != 8200L) {
                area = DataUtil.toInt((Long)(areaCode / 100L));
            }
            if (Arrays.asList(HUABEI_REGION).contains(area)) {
                ret = 80L;
            } else if (Arrays.asList(DONGBEI_REGION).contains(area)) {
                ret = 81L;
            } else if (Arrays.asList(HUADONG_REGION).contains(area)) {
                ret = 82L;
            } else if (Arrays.asList(HUAZHONG_REGION).contains(area)) {
                ret = 83L;
            } else if (Arrays.asList(HUANAN_REGION).contains(area)) {
                ret = 84L;
            } else if (Arrays.asList(XINAN_REGION).contains(area)) {
                ret = 85L;
            } else if (Arrays.asList(XIBEI_REGION).contains(area)) {
                ret = 86L;
            } else if (Arrays.asList(HMT_REGION).contains(area)) {
                ret = 87L;
            }
        }
        return ret;
    }

    public static Long getTierCityLevel(Long areaCode) {
        Long ret = null;
        if (AssertUtil.isNotEmpty((Object)areaCode)) {
            int area = DataUtil.toInt((Long)areaCode);
            if (Arrays.asList(FIRST_TIER_CITY).contains(area)) {
                ret = 1L;
            } else if (Arrays.asList(SECOND_TIER_CITY).contains(area)) {
                ret = 2L;
            } else if (Arrays.asList(THIRD_TIER_CITY).contains(area)) {
                ret = 3L;
            }
        }
        return ret;
    }

    public static Long getImeiDayTimes(String imei, Long timesLimit, Map<String, Long> timesMap) {
        Long ret = 0L;
        if (AssertUtil.isAllNotEmpty((Object[])new Object[]{imei, timesMap})) {
            Long cnt = timesMap.get(imei);
            ret = cnt == null || cnt < 1L ? Long.valueOf(0L) : (cnt <= timesLimit ? cnt : Long.valueOf(99L));
        }
        return ret;
    }

    public static Long getResoDayTimes(Long resoId, String imei, Long timesLimit, Map<String, Long> timesMap) {
        Long ret = 0L;
        if (AssertUtil.isAllNotEmpty((Object[])new Object[]{imei, resoId, timesMap})) {
            String statKey = DataUtil.Long2String((Long)resoId) + "_" + imei;
            Long cnt = timesMap.get(statKey);
            ret = cnt == null || cnt < 1L ? Long.valueOf(0L) : (cnt <= timesLimit ? cnt : Long.valueOf(99L));
        }
        return ret;
    }

    public static String getLastEqualStatus(String currentId1, String currentId2, String lastId) {
        Integer ret = 0;
        String currentId = null;
        if (AssertUtil.isNotEmpty((String)currentId1) && AssertUtil.isEmpty((String)currentId2)) {
            currentId = currentId1;
        } else if (AssertUtil.isNotEmpty((String)currentId2) && AssertUtil.isEmpty((String)currentId1)) {
            currentId = currentId2;
        } else if (AssertUtil.isAllNotEmpty((Object[])new Object[]{currentId1, currentId2})) {
            currentId = currentId1 + "," + currentId2;
        }
        if (AssertUtil.isAllNotEmpty((Object[])new Object[]{currentId, lastId})) {
            ret = currentId.equals(lastId) ? 1 : 0;
        } else if (AssertUtil.isAllEmpty((Object[])new Object[]{currentId, lastId})) {
            ret = null;
        }
        return DataUtil.Integer2String((Integer)ret);
    }

    public static void main(String[] args) {
        Long currentGmtCreateTime1 = new Date().getTime();
        System.out.println("time:" + currentGmtCreateTime1);
        Integer hour = AdxFeatureParse.getTimeStampToHour(currentGmtCreateTime1);
        System.out.println("hour:" + DataUtil.Integer2String((Integer)hour));
        Integer weekDay = AdxFeatureParse.getTimeStampToWeekDay(currentGmtCreateTime1);
        System.out.println("weekday:" + DataUtil.Integer2String((Integer)weekDay));
        Long currentTime1 = AdxFeatureParse.getStringToTimeStamp();
        System.out.println("time1:" + currentTime1);
        System.out.println("ret1:" + AdxFeatureParse.getFloat2String(null));
        System.out.println("ret2:" + AdxFeatureParse.getObject2Long(null));
        System.out.println("getRegionLevel:" + AdxFeatureParse.getRegionLevel(4690L));
        System.out.println("getTierCityLevel:" + AdxFeatureParse.getTierCityLevel(null));
        HashMap<String, Long> timesMap1 = new HashMap<String, Long>();
        timesMap1.put("123_A", 10L);
        System.out.println("getImeiDayTimes:" + AdxFeatureParse.getImeiDayTimes("A", 7L, timesMap1));
        System.out.println("getResoDayTimes:" + AdxFeatureParse.getResoDayTimes(123L, "A", 50L, timesMap1));
        AdxFeatureDo adxFeatureDo1 = new AdxFeatureDo();
        adxFeatureDo1.setCurrentCreatTime(new Date().getTime());
        Map<Object, Object> staticMap1 = new HashMap();
        staticMap1 = AdxFeatureParse.generateFeatureMapStatic(adxFeatureDo1);
        System.out.println("staticMap1=" + JSON.toJSONString(staticMap1));
        System.out.println("getLength=" + FeatureBaseParse.getLengthLevel("1,2,3,4,5,6,7,8,9,10", 5, 10, 5));
        System.out.println("getCategoryLevel=" + FeatureBaseParse.getCategoryLevel("11,5,10,0,9", 10, 1));
        System.out.println("getExpClickCrossValue=" + FeatureBaseParse.getExpClickCrossValue(null, null));
        AdxIdeaMaterialDo ma1 = new AdxIdeaMaterialDo();
        ma1.setMaterialId(111L);
        AdxIdeaMaterialDo ma2 = new AdxIdeaMaterialDo();
        ma2.setMaterialId(112L);
        ArrayList<AdxIdeaMaterialDo> materialList = new ArrayList<AdxIdeaMaterialDo>();
        materialList.add(0, ma1);
        materialList.add(1, null);
        materialList.add(2, ma2);
        System.out.println("getMaterialFeature=" + FeatureBaseParse.getMaterialFeature(materialList, "materialId"));
    }
}

