package cn.com.duiba.nezha.alg.feature.vo;

import cn.com.duiba.nezha.alg.common.util.DataUtil;
import lombok.Data;

import java.util.Map;

@Data
public class CvrStatDo {
    /**
     * 计费点击PV（过去3天）
     */
    private Long click3Day;

    /**
     * 后端类型转化PV Map（过去3天）
     */
    private Map<String, Long> convertMap3Day;

    /**
     * 计费点击PV（昨天+当天）
     */
    private Long click1Day;

    /**
     * 后端类型转化PV Map（昨天+当天）
     */
    private Map<String, Long> convertMap1Day;

    private static Double calWilsonScore(Long baseCnt, Long targetCnt, double faithLevel) {
        if (baseCnt == null || targetCnt == null) return null;

        if (baseCnt <= 0 || targetCnt <= 0) return null;

        double ratio = targetCnt * 1.0 / baseCnt;
        double faithSquare = faithLevel * faithLevel;

        return (ratio + (faithSquare / (2 * baseCnt)) - faithLevel * Math.sqrt(4 * baseCnt * ratio * (1 - ratio) + faithSquare) / (2 * baseCnt)) / (1 + faithSquare / baseCnt);
    }


    public Double getCvr1DayBySubType(String subtype) {
        Long convertPv = convertMap1Day == null ? null : convertMap1Day.get(subtype);

        // 95% 置信区间下界
        return DataUtil.formatDouble(calWilsonScore(click1Day, convertPv, 2), 6);
    }

    public Double getCvr3DayBySubType(String subtype) {
        Long convertPv = convertMap3Day == null ? null : convertMap3Day.get(subtype);

        // 95% 置信区间下界
        return DataUtil.formatDouble(calWilsonScore(click3Day, convertPv, 2), 6);
    }

}
