/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.alg.feature.vo;

import cn.com.duiba.nezha.alg.common.util.DataUtil;
import java.util.Map;
import java.util.Random;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CvrStatDo {
    private Long click3Day;
    private Map<String, Long> convertMap3Day;
    private Long click1Day;
    private Map<String, Long> convertMap1Day;
    private static final Logger logger = LoggerFactory.getLogger(CvrStatDo.class);

    private static Double calWilsonScore(Long baseCnt, Long targetCnt, double faithLevel) {
        if (baseCnt == null || targetCnt == null) {
            return null;
        }
        if (baseCnt <= 0L || targetCnt <= 0L) {
            return null;
        }
        double ratio = (double)targetCnt.longValue() * 1.0 / (double)baseCnt.longValue();
        double faithSquare = faithLevel * faithLevel;
        return (ratio + faithSquare / (double)(2L * baseCnt) - faithLevel * Math.sqrt((double)(4L * baseCnt) * ratio * (1.0 - ratio) + faithSquare) / (double)(2L * baseCnt)) / (1.0 + faithSquare / (double)baseCnt.longValue());
    }

    public static void main(String[] args) {
        Double cvr = CvrStatDo.calWilsonScore(null, null, 2.0);
        System.out.println(DataUtil.formatDouble((Double)cvr, (int)6));
        System.out.println(cvr);
    }

    public Double getCvr1DayBySubType(String subtype) {
        Long convertPv = this.convertMap1Day == null ? null : this.convertMap1Day.get(subtype);
        Double cvr = CvrStatDo.calWilsonScore(this.click1Day, convertPv, 2.0);
        if (cvr != null && (Double.isInfinite(cvr) || Double.isNaN(cvr))) {
            Random random = new Random();
            if (random.nextDouble() < 1.0E-5) {
                logger.info("invalid cvr value. convert: " + convertPv + ", click: " + this.click1Day);
            }
            return null;
        }
        return DataUtil.formatDouble((Double)cvr, (int)6);
    }

    public Double getCvr3DayBySubType(String subtype) {
        Long convertPv = this.convertMap3Day == null ? null : this.convertMap3Day.get(subtype);
        Double cvr = CvrStatDo.calWilsonScore(this.click3Day, convertPv, 2.0);
        if (cvr != null && (Double.isInfinite(cvr) || Double.isNaN(cvr))) {
            Random random = new Random();
            if (random.nextDouble() < 1.0E-4) {
                logger.info("invalid cvr value. convert: " + convertPv + ", click: " + this.click3Day);
            }
            return null;
        }
        return DataUtil.formatDouble((Double)cvr, (int)6);
    }

    public Long getClick3Day() {
        return this.click3Day;
    }

    public Map<String, Long> getConvertMap3Day() {
        return this.convertMap3Day;
    }

    public Long getClick1Day() {
        return this.click1Day;
    }

    public Map<String, Long> getConvertMap1Day() {
        return this.convertMap1Day;
    }

    public void setClick3Day(Long click3Day) {
        this.click3Day = click3Day;
    }

    public void setConvertMap3Day(Map<String, Long> convertMap3Day) {
        this.convertMap3Day = convertMap3Day;
    }

    public void setClick1Day(Long click1Day) {
        this.click1Day = click1Day;
    }

    public void setConvertMap1Day(Map<String, Long> convertMap1Day) {
        this.convertMap1Day = convertMap1Day;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CvrStatDo)) {
            return false;
        }
        CvrStatDo other = (CvrStatDo)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$click3Day = this.getClick3Day();
        Long other$click3Day = other.getClick3Day();
        if (this$click3Day == null ? other$click3Day != null : !((Object)this$click3Day).equals(other$click3Day)) {
            return false;
        }
        Map<String, Long> this$convertMap3Day = this.getConvertMap3Day();
        Map<String, Long> other$convertMap3Day = other.getConvertMap3Day();
        if (this$convertMap3Day == null ? other$convertMap3Day != null : !((Object)this$convertMap3Day).equals(other$convertMap3Day)) {
            return false;
        }
        Long this$click1Day = this.getClick1Day();
        Long other$click1Day = other.getClick1Day();
        if (this$click1Day == null ? other$click1Day != null : !((Object)this$click1Day).equals(other$click1Day)) {
            return false;
        }
        Map<String, Long> this$convertMap1Day = this.getConvertMap1Day();
        Map<String, Long> other$convertMap1Day = other.getConvertMap1Day();
        return !(this$convertMap1Day == null ? other$convertMap1Day != null : !((Object)this$convertMap1Day).equals(other$convertMap1Day));
    }

    protected boolean canEqual(Object other) {
        return other instanceof CvrStatDo;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $click3Day = this.getClick3Day();
        result = result * 59 + ($click3Day == null ? 43 : ((Object)$click3Day).hashCode());
        Map<String, Long> $convertMap3Day = this.getConvertMap3Day();
        result = result * 59 + ($convertMap3Day == null ? 43 : ((Object)$convertMap3Day).hashCode());
        Long $click1Day = this.getClick1Day();
        result = result * 59 + ($click1Day == null ? 43 : ((Object)$click1Day).hashCode());
        Map<String, Long> $convertMap1Day = this.getConvertMap1Day();
        result = result * 59 + ($convertMap1Day == null ? 43 : ((Object)$convertMap1Day).hashCode());
        return result;
    }

    public String toString() {
        return "CvrStatDo(click3Day=" + this.getClick3Day() + ", convertMap3Day=" + this.getConvertMap3Day() + ", click1Day=" + this.getClick1Day() + ", convertMap1Day=" + this.getConvertMap1Day() + ")";
    }
}

