package cn.com.duiba.nezha.alg.feature.parse;

import cn.com.duiba.nezha.alg.common.enums.DateStyle;
import cn.com.duiba.nezha.alg.common.util.AssertUtil;
import cn.com.duiba.nezha.alg.common.util.DataUtil;
import cn.com.duiba.nezha.alg.common.util.LocalDateUtil;
import cn.com.duiba.nezha.alg.feature.vo.*;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import org.slf4j.LoggerFactory;

import java.util.*;

public class OriginalFeature {

    public static int F_MAX_SIZE = 64;
    private static final org.slf4j.Logger logger = LoggerFactory.getLogger(OriginalFeature.class);

    public static Map<String, String> generateFeatureMapStatic(FeatureDo cf) {
        Map<String, String> retMap = new HashMap<>(F_MAX_SIZE);
        try {
            if (cf != null) {


                cf.setCurrentGmtCreateTime(LocalDateUtil.getCurrentLocalDateTime(DateStyle.YYYY_MM_DD_HH_MM_SS.getValue()));

                // rank 转level
                retMap.put("f601001", DataUtil.Long2String(cf.getDayOrderRank()));
                retMap.put("f602001", DataUtil.Long2String(cf.getOrderRank()));
                retMap.put("f603001", DataUtil.Long2String(cf.getDayActivityOrderRank()));
                retMap.put("f604001", DataUtil.Long2String(cf.getActivityOrderRank()));

                // 计算时间差
                Long orderIntervalMinutes = LocalDateUtil.getIntervalMinutes(cf.getCurrentGmtCreateTime(), cf.getLastGmtCreateTime(), DateStyle.YYYY_MM_DD_HH_MM_SS, DateStyle.YYYY_MM_DD_HH_MM_SS);
//                retMap.put("f605001", DataUtil.Long2String(orderIntervalMinutes));

                // 计算活动时间差
                Long activityOrderMinutes = LocalDateUtil.getIntervalMinutes(cf.getCurrentGmtCreateTime(), cf.getActivityLastGmtCreateTime(), DateStyle.YYYY_MM_DD_HH_MM_SS, DateStyle.YYYY_MM_DD_HH_MM_SS);
//                retMap.put("f606001", DataUtil.Long2String(activityOrderMinutes));

                // 计算活动上次计费情况
//                retMap.put("f607001", DataUtil.Long2String(cf.getActivityLastChargeNums()));

                // 计算上次计费情况
//                retMap.put("f608001", DataUtil.Long2String(cf.getLastChargeNums()));

                // 发券次序，该用户当日发券次数
                retMap.put("f611001", DataUtil.Long2String(cf.getPutIndex()));

                // 是否老用户  注册距离最近登录时间大于1天  cvr
                Long dayIntervals = LocalDateUtil.getIntervalDays(cf.getUserLastlogbigintime(), cf.getUserRegtime());
                retMap.put("f403004", DataUtil.Long2String(dayIntervals));

                //20180306
//                retMap.put("f9916_a", cf.getUIIds());
//                retMap.put("f9916", cf.getUILaunchPV());
//                retMap.put("f9917", cf.getUIClickPv());
//                retMap.put("f9918", cf.getUIEffectPv());
//                retMap.put("f9919", cf.getUIScore());

                // 20180423，用户行为数据
                retMap.put("f601002", DataUtil.Long2String(cf.getDayOrderRank()));
                retMap.put("f602002", DataUtil.Long2String(cf.getOrderRank()));
                retMap.put("f603002", DataUtil.Long2String(cf.getDayActivityOrderRank()));
                retMap.put("f604002", DataUtil.Long2String(cf.getActivityOrderRank()));

                Long orderGmtIntervel = LocalDateUtil.getIntervalMinutes(cf.getCurrentGmtCreateTime(), cf.getLastGmtCreateTime(), DateStyle.YYYY_MM_DD_HH_MM_SS, DateStyle.YYYY_MM_DD_HH_MM_SS);
//                retMap.put("f605002", DataUtil.Long2String(orderGmtIntervel));

                // 计算活动时间差
                Long activityOrderGmtIntervel = LocalDateUtil.getIntervalMinutes(cf.getCurrentGmtCreateTime(), cf.getActivityLastGmtCreateTime(), DateStyle.YYYY_MM_DD_HH_MM_SS, DateStyle.YYYY_MM_DD_HH_MM_SS);
//                retMap.put("f606002", DataUtil.Long2String(activityOrderGmtIntervel));


                // 20180424  添加安装列表类别及数目特征
//                retMap.put("f9925", JSON.toJSONString(cf.getCategory1idCntList()));
//                retMap.put("f9926", JSON.toJSONString(cf.getCategory2idCntList()));

                // 20180423
                // f9916~f9918
                Map<String, Map<String, Long>> ubpMap = FeatureParse.getUserBehavioralPreference(
                        cf.getUIIds(), cf.getUILaunchPV(), cf.getUIClickPv(), cf.getUIEffectPv());

//                retMap.put("f809001_a", JSON.toJSONString(ubpMap));

//                System.out.println("ubpMap="+JSON.toJSONString(ubpMap));
                ///全局
//                retMap.put("f809001", getUserBehavioralPreference(0, "ctr", ubpMap, null));
//                retMap.put("f809002", getUserBehavioralPreference(0, "cvr", ubpMap, null));

                //行业
//                retMap.put("f808001", getUserBehavioralPreference(2, "ctr", ubpMap, null));
//                retMap.put("f808002", getUserBehavioralPreference(2, "cvr", ubpMap, null));

                //统计
//                retMap.put("f811001", getUserBehavioralPreference(3, "ctr", ubpMap, null));
//                retMap.put("f811002", getUserBehavioralPreference(3, "cvr", ubpMap, null));



                //20190507广告&媒体偏好画像特征
                //媒体行业在不同广告行业上的ctr,cvr(分桶)
                retMap.put("f550101", JSON.toJSONString(cf.getAppTagInNewTrade()));
                retMap.put("f550102", JSON.toJSONString(cf.getAppTagInNewTrade()));

                //媒体在不同广告行业上的ctr,cvr(分桶)
                retMap.put("f550301", JSON.toJSONString(cf.getAppInNewTrade()));
                retMap.put("f550302", JSON.toJSONString(cf.getAppInNewTrade()));


                //20200303dmp特征加工
                DmpFeature dmpFeature = Optional.ofNullable(cf.getDmpFeature()).orElse(new DmpFeature());

                retMap.put("f9940", dmpFeature.getAppCategory());
                retMap.put("f9942", dmpFeature.getAppVector());

                retMap.put("f9805", dmpFeature.getMsgVector());


                // 7.31
                // 8.26 缩减分桶数量 200 -> 20
                retMap.put("f9816", dmpFeature.getmsgListEmbed8());
                retMap.put("f9817", dmpFeature.getAppListEmbed32());

                UserActFeature userActFeature = Optional.ofNullable(cf.getUserActFeature()).orElse(new UserActFeature());

                // 生命周期
                retMap.put("f410001", DataUtil.Integer2String(userActFeature.getUserActiveDays()));

                // 活动访问
                retMap.put("f411001", DataUtil.Integer2String(userActFeature.getActivityRequest()));
                retMap.put("f411002", DataUtil.Integer2String(userActFeature.getWeekActivityRequest()));
                retMap.put("f411003", DataUtil.Integer2String(userActFeature.getDayActivityRequest()));
                retMap.put("f411004", DataUtil.Integer2String(userActFeature.getIntervalActivityRequest()));

                // 活动参与412005
                retMap.put("f412001", DataUtil.Integer2String(userActFeature.getActivityJoin()));
                retMap.put("f412002", DataUtil.Integer2String(userActFeature.getWeekActivityJoin()));
                retMap.put("f412003", DataUtil.Integer2String(userActFeature.getDayActivityJoin()));
                retMap.put("f412004", DataUtil.Integer2String(userActFeature.getIntervalActivityJoin()));
                retMap.put("f412006", DataUtil.Integer2String(userActFeature.getActivityPageStay()));

                // 发券
                retMap.put("f413001", userActFeature.getLaunchTrade());
                retMap.put("f413002", userActFeature.getWeekLaunchTrade());
                retMap.put("f413003", JSON.toJSONString(userActFeature.getDayLaunchTrade()));
                retMap.put("f413004", JSON.toJSONString(userActFeature.getIntervalLaunchTrade()));
                retMap.put("f413006", JSON.toJSONString(userActFeature.getAvgLaunchStay()));

                // 点击
                retMap.put("f414001", (userActFeature.getClickTrade()));
                retMap.put("f414002", userActFeature.getWeekClickTrade());
                retMap.put("f414003", JSON.toJSONString(userActFeature.getDayClickTrade()));
                retMap.put("f414004", DataUtil.Integer2String(userActFeature.getIntervalClickTrade()));

                // 转化
                retMap.put("f415001", userActFeature.getEffectTrade());
                retMap.put("f415002", userActFeature.getWeekEffectTrade());
                retMap.put("f415003", JSON.toJSONString(userActFeature.getDayEffectTrade()));
                retMap.put("f415004", DataUtil.Integer2String(userActFeature.getIntervalEffectTrade()));


                // 广告位维度流量特征
                SlotActFeature slotActFeature = Optional.ofNullable(cf.getSlotActFeature()).orElse(new SlotActFeature());
                // 发券
                retMap.put("f210001", slotActFeature.getLaunchCntRatioTrade());
                retMap.put("f210002", slotActFeature.getLaunchCntRatioAccount());
                retMap.put("f210003", slotActFeature.getWeekLaunchCntRatioTrade());
                retMap.put("f210004", slotActFeature.getWeekLaunchCntRatioAccount());

                JSONObject weekClickTradeCnt = DataUtil.stringToJson(slotActFeature.getWeekClickTradeCnt());
                JSONObject weekConversionTradeCnt = DataUtil.stringToJson(slotActFeature.getWeekConversionTradeCnt());
                retMap.put("f250301", JSON.toJSONString(getCategoryLevel(weekClickTradeCnt, weekConversionTradeCnt, FeatureParse.tradeCodes)));
                JSONObject weekClickAccountCnt = DataUtil.stringToJson(slotActFeature.getWeekClickAccountCnt());
                JSONObject weekConversionAccountCnt = DataUtil.stringToJson(slotActFeature.getWeekConversionAccountCnt());
                retMap.put("f250302", JSON.toJSONString(getCategoryLevel(weekClickAccountCnt, weekConversionAccountCnt, FeatureParse.accountCodes)));


                // 点击
                retMap.put("f211001", slotActFeature.getClickCntRatioTrade());
                retMap.put("f211002", slotActFeature.getClickCntRatioAccount());
                retMap.put("f211003", slotActFeature.getWeekClickCntRatioTrade());
                retMap.put("f211004", slotActFeature.getWeekClickCntRatioAccount());

                retMap.put("f212001", slotActFeature.getCtrTrade());
                retMap.put("f212002", slotActFeature.getCtrAccount());
                retMap.put("f212003", slotActFeature.getWeekCtrTrade());
                retMap.put("f212004", slotActFeature.getWeekCtrAccount());

                // 前端转化
                retMap.put("f213001", slotActFeature.getConvertCntRatioTrade());
                retMap.put("f213002", slotActFeature.getConvertCntRatioAccount());
                retMap.put("f213003", slotActFeature.getWeekConvertCntRatioTrade());
                retMap.put("f213004", slotActFeature.getWeekConvertCntRatioAccount());

                retMap.put("f214001", slotActFeature.getCvrTrade());
                retMap.put("f214002", slotActFeature.getCvrAccount());
                retMap.put("f214003", slotActFeature.getWeekCvrTrade());
                retMap.put("f214004", slotActFeature.getWeekCvrAccount());

                //美团imei维度竞价次序特征
                retMap.put("f680001", DataUtil.Long2String(cf.getRequestCnt()));
                retMap.put("f680002", DataUtil.Long2String(cf.getExposureCnt()));
                retMap.put("f680003", DataUtil.Long2String(cf.getClickCnt()));
            }

        } catch (Exception e) {

            logger.error("OriginalFeature.generateFeatureMapStatic error:" + e);
        }

        return retMap;
    }

    public static Map<String, String> generateFeatureMapDynamic(FeatureDo cf, FeatureDo staticCf) {
        Map<String, String> retMap = new HashMap<>(F_MAX_SIZE);
        try {
            if (cf != null) {

                // 落地页维度特征
                LoadingPageFeature loadingPageFeature = Optional.ofNullable(cf.getLoadingPageFeature()).orElse(new LoadingPageFeature());
                retMap.put("f670002", DataUtil.double2String(loadingPageFeature.getLoadingPageHistCvr()));
                retMap.put("f670003", loadingPageFeature.getLoadingPageTagsHistCvr());


                // 20171121
                retMap.put("f804001", DataUtil.double2String(cf.getAdvertCtr()));
                retMap.put("f804002", DataUtil.double2String(cf.getAdvertCvr()));

                retMap.put("f805001", DataUtil.double2String(cf.getAdvertAppCtr()));
                retMap.put("f805002", DataUtil.double2String(cf.getAdvertAppCvr()));

                retMap.put("f806001", DataUtil.double2String(cf.getAdvertSlotCtr()));
                retMap.put("f806002", DataUtil.double2String(cf.getAdvertSlotCvr()));

                retMap.put("f807001", DataUtil.double2String(cf.getAdvertActivityCtr()));
                retMap.put("f807002", DataUtil.double2String(cf.getAdvertActivityCvr()));

                // 20180507
                retMap.put("f804003", DataUtil.double2String(cf.getAdvertCtr()));
                retMap.put("f804004", DataUtil.double2String(cf.getAdvertCvr()));

                retMap.put("f805003", DataUtil.double2String(cf.getAdvertAppCtr()));
                retMap.put("f805004", DataUtil.double2String(cf.getAdvertAppCvr()));

                retMap.put("f806003", DataUtil.double2String(cf.getAdvertSlotCtr()));
                retMap.put("f806004", DataUtil.double2String(cf.getAdvertSlotCvr()));

                retMap.put("f807003", DataUtil.double2String(cf.getAdvertActivityCtr()));
                retMap.put("f807004", DataUtil.double2String(cf.getAdvertActivityCvr()));

                // 2021-04-02 后端类型 各维度统计cvr
                String convertSubType = cf.getBankEndType();

                CvrStatDo adCsd = Optional.ofNullable(cf.getAdCsd()).orElse(new CvrStatDo());
                retMap.put("f840101", DataUtil.double2String(adCsd.getCvr1DayBySubType(convertSubType)));

                CvrStatDo adAppCsd = Optional.ofNullable(cf.getAdAppCsd()).orElse(new CvrStatDo());
                retMap.put("f840102", DataUtil.double2String(adAppCsd.getCvr1DayBySubType(convertSubType)));

                CvrStatDo adSlotCsd = Optional.ofNullable(cf.getAdSlotCsd()).orElse(new CvrStatDo());
                retMap.put("f840103", DataUtil.double2String(adSlotCsd.getCvr1DayBySubType(convertSubType)));

                CvrStatDo adActivityCsd = Optional.ofNullable(cf.getAdActivityCsd()).orElse(new CvrStatDo());
                retMap.put("f840104", DataUtil.double2String(adActivityCsd.getCvr1DayBySubType(convertSubType)));

                CvrStatDo accCsd = Optional.ofNullable(cf.getAccCsd()).orElse(new CvrStatDo());
                retMap.put("f840105", DataUtil.double2String(accCsd.getCvr1DayBySubType(convertSubType)));

                CvrStatDo accAppCsd = Optional.ofNullable(cf.getAccAppCsd()).orElse(new CvrStatDo());
                retMap.put("f840106", DataUtil.double2String(accAppCsd.getCvr1DayBySubType(convertSubType)));

                CvrStatDo accSlotCsd = Optional.ofNullable(cf.getAccSlotCsd()).orElse(new CvrStatDo());
                retMap.put("f840107", DataUtil.double2String(accSlotCsd.getCvr1DayBySubType(convertSubType)));

                CvrStatDo accActivityCsd = Optional.ofNullable(cf.getAccActivityCsd()).orElse(new CvrStatDo());
                retMap.put("f840108", DataUtil.double2String(accActivityCsd.getCvr1DayBySubType(convertSubType)));

                CvrStatDo tradeCsd = Optional.ofNullable(cf.getTradeCsd()).orElse(new CvrStatDo());
                retMap.put("f840109", DataUtil.double2String(tradeCsd.getCvr1DayBySubType(convertSubType)));

                CvrStatDo tradeAppCsd = Optional.ofNullable(cf.getTradeAppCsd()).orElse(new CvrStatDo());
                retMap.put("f840110", DataUtil.double2String(tradeAppCsd.getCvr1DayBySubType(convertSubType)));

                CvrStatDo tradeSlotCsd = Optional.ofNullable(cf.getTradeSlotCsd()).orElse(new CvrStatDo());
                retMap.put("f840111", DataUtil.double2String(tradeSlotCsd.getCvr1DayBySubType(convertSubType)));

                CvrStatDo tradeActivityCsd = Optional.ofNullable(cf.getTradeActivityCsd()).orElse(new CvrStatDo());
                retMap.put("f840112", DataUtil.double2String(tradeActivityCsd.getCvr1DayBySubType(convertSubType)));

                CvrStatDo appCsd = Optional.ofNullable(staticCf.getAppCsd()).orElse(new CvrStatDo());
                retMap.put("f840113", DataUtil.double2String(appCsd.getCvr1DayBySubType(convertSubType)));
                CvrStatDo slotCsd = Optional.ofNullable(staticCf.getSlotCsd()).orElse(new CvrStatDo());
                retMap.put("f840114", DataUtil.double2String(slotCsd.getCvr1DayBySubType(convertSubType)));
                CvrStatDo activityCsd = Optional.ofNullable(staticCf.getActivityCsd()).orElse(new CvrStatDo());
                retMap.put("f840115", DataUtil.double2String(activityCsd.getCvr1DayBySubType(convertSubType)));


                retMap.put("f812001", DataUtil.double2String(cf.getAppTradeWeekCvr()));
                retMap.put("f812002", DataUtil.double2String(cf.getAppTradeDayCvr()));
                retMap.put("f812003", DataUtil.double2String(cf.getAppTagpidTradeWeekCvr()));
                retMap.put("f812004", DataUtil.double2String(cf.getAppTagpidTradeDayCvr()));
                retMap.put("f812005", DataUtil.double2String(cf.getAppTagidTradeWeekCvr()));
                retMap.put("f812006", DataUtil.double2String(cf.getAppTagidTradeDayCvr()));
                retMap.put("f812007", DataUtil.double2String(cf.getMaterialTradeWeekCvr()));
                retMap.put("f812008", DataUtil.double2String(cf.getMaterialTradeDayCvr()));
                retMap.put("f812009", DataUtil.double2String(cf.getAcctivityTradeWeekCvr()));
                retMap.put("f812010", DataUtil.double2String(cf.getAcctivityTradeDayCvr()));


                // 用户当日该资源第几个订单序列f770102
                Long dayResourceOrderRank = getResourceOrderRank(cf.getOperatingResource(), staticCf.getDayResourceOrderRank());
                retMap.put("f770102", DataUtil.Long2String(dayResourceOrderRank));

                // 计算用户该资源当前单与前一单时间差f770202
                Long resourceOrderGmtIntervelLevel =
                        getResourceOrderGmtIntervelLevel(cf.getOperatingResource(), staticCf.getCurrentGmtCreateTime(), staticCf.getResourceLastGmtCreateTime());
                retMap.put("f770202", DataUtil.Long2String(resourceOrderGmtIntervelLevel));

                // 当日用户该资源累计点击数 f770401
                Long dayResourceChargeCnt = getResourceChargeCnt(cf.getOperatingResource(), staticCf.getDayResourceChargeCnt());
                retMap.put("f770401", DataUtil.Long2String(dayResourceChargeCnt));

                // 当日用户该资源累计转化数 f770402
                Long dayResourceConvertCnt = getResourceConvertCnt(cf.getOperatingResource(), staticCf.getDayResourceConvertCnt());
                retMap.put("f770402", DataUtil.Long2String(dayResourceConvertCnt));


                // 20190507行业重复发券-用户行为衍生特征
                // 当前订单所属综合行业 f660001
                retMap.put("f660003", DataUtil.double2String(cf.getNewTradeHistCtr()));
                retMap.put("f660004", DataUtil.double2String(cf.getNewTradeHistCvr()));


                // 用户当日该综合行业下发券次序（分桶）f660102
                Long newTradeDayOrderRankLevel = getNewTradeOrderRank(cf.getOperatingNewTrade(), cf.getNewTradeDayOrderRank());
                retMap.put("f660102", DataUtil.Long2String(newTradeDayOrderRankLevel));

                // 计算用户当日该综合行业前后单时间差（分桶）f660302
                Long lastNewTradeGmtIntervelLevel = getLastNewTradeGmtIntervelLevel(cf.getOperatingNewTrade(), staticCf.getCurrentGmtCreateTime(), cf.getNewTradeLastGmtCreateTime());
                retMap.put("f660302", DataUtil.Long2String(lastNewTradeGmtIntervelLevel));


                //20190507广告&媒体偏好画像特征
                //广告行业在不同媒体行业上的ctr,cvr(分桶)
//                retMap.put("f550201_a", JSON.toJSONString(cf.getNewTradeInAppTag()));

                //广告在不同媒体行业上的ctr,cvr(分桶)
//                retMap.put("f550401_a", JSON.toJSONString(cf.getAdvertInAppTag()));


                // 商品画像特征解析
                ItemProfileFeature itemProfileFeature = Optional.ofNullable(cf.getItemProfileFeature()).orElse(new ItemProfileFeature());
                // 基本信息
                retMap.put("f141013", itemProfileFeature.getOriginalPrice() == null ? null : DataUtil.Long2String(itemProfileFeature.getOriginalPrice().longValue()));
                retMap.put("f141014", itemProfileFeature.getDealPrice() == null ? null : DataUtil.Long2String(itemProfileFeature.getDealPrice().longValue()));
                retMap.put("f141015", itemProfileFeature.getNumber());
                retMap.put("f141016", DataUtil.Integer2String(itemProfileFeature.getDeliveryDays()));
                retMap.put("f141018", DataUtil.Long2String(itemProfileFeature.getDaysOnSale()));

                // 标签信息
                retMap.put("f142003", itemProfileFeature.getMaterialPictureRGB());
                retMap.put("f142004", itemProfileFeature.getLayerPictureRGB());
                retMap.put("f142005", itemProfileFeature.getPictureRGB());

                // 热度信息
                retMap.put("f143001", DataUtil.Long2String(itemProfileFeature.getClickCnt()));
                retMap.put("f143002", DataUtil.Long2String(itemProfileFeature.getWeekClickCnt()));
                retMap.put("f143003", DataUtil.Long2String(itemProfileFeature.getDayClickCnt()));
                retMap.put("f143004", DataUtil.Long2String(itemProfileFeature.getEffectCnt()));
                retMap.put("f143005", DataUtil.Long2String(itemProfileFeature.getWeekEffectCnt()));
                retMap.put("f143006", DataUtil.Long2String(itemProfileFeature.getDayEffectCnt()));
                retMap.put("f143007", DataUtil.Long2String(itemProfileFeature.getIssueEffectCnt()));
                retMap.put("f143008", DataUtil.Long2String(itemProfileFeature.getWeekIssueEffectCnt()));
                retMap.put("f143009", DataUtil.Long2String(itemProfileFeature.getSignEffectCnt()));
                retMap.put("f143010", DataUtil.Long2String(itemProfileFeature.getWeekSignEffectCnt()));

                // 衍生信息
                retMap.put("f144001", DataUtil.double2String(itemProfileFeature.getCtr()));
                retMap.put("f144002", DataUtil.double2String(itemProfileFeature.getWeekCtr()));
                retMap.put("f144003", DataUtil.double2String(itemProfileFeature.getDayCtr()));
                retMap.put("f144004", DataUtil.double2String(itemProfileFeature.getCvr()));
                retMap.put("f144005", DataUtil.double2String(itemProfileFeature.getWeekCvr()));
                retMap.put("f144006", DataUtil.double2String(itemProfileFeature.getDayCvr()));
                retMap.put("f144007", DataUtil.double2String(itemProfileFeature.getIecvr()));
                retMap.put("f144008", DataUtil.double2String(itemProfileFeature.getWeekIecvr()));
                retMap.put("f144009", DataUtil.double2String(itemProfileFeature.getSecvr()));
                retMap.put("f144010", DataUtil.double2String(itemProfileFeature.getWeekSecvr()));
            }


        } catch (Exception e) {
            logger.error("OriginalFeature.generateFeatureMapDynamic error:", e);

        }
        return retMap;
    }


    // 用户分行业统计数据解析
    public static Map<Integer, Double> getCategoryLevel(JSONObject actMap1, JSONObject actMap2, Map<String, Integer> category) {

        if (AssertUtil.isAnyEmpty(actMap1, actMap2, category)) return null;

        HashMap<Integer, Double> resMap = new HashMap<>();


        try {
            for (String cateKey : actMap1.keySet()) {
                double cateValue1 = Long.parseLong(actMap1.getOrDefault(cateKey, 0).toString());
                if (cateValue1 == 0) {
                    continue;
                }
                double cateValue2 = Long.parseLong(actMap2.getOrDefault(cateKey, 0).toString());
                // 过滤不置信转化，个数小于5个
                if (category.containsKey(cateKey) && cateValue2 > 5.0) {
                    Integer i = category.get(cateKey);

                    resMap.put(i, cateValue2 / cateValue1);
                }
            }
        } catch (Exception e) {
            logger.warn("getCategoryLevel failed=" + actMap2);
            return null;
        }

        return resMap;
    }


    public static Long getResourceOrderRank(String operatingResource, Map<String, Long> dayResourceOrderRank) {
        Long ret = null;
        if (operatingResource == null || dayResourceOrderRank == null) {
            ret = null;
        } else {
            ret = dayResourceOrderRank.get(operatingResource + "-770101");
        }
        return ret;
    }

    public static Long getResourceOrderGmtIntervelLevel(String operatingResource, String currentGmtCreateTime, Map<String, String> resourceLastGmtCreateTime) {
        Long ret = null;
        if (operatingResource == null || currentGmtCreateTime == null || resourceLastGmtCreateTime == null) {
            ret = null;
        } else {
            String lastGmtCreateTime = resourceLastGmtCreateTime.get(operatingResource + "-770201");
            if (lastGmtCreateTime == null) {
                ret = null;
            } else {
//                Date date = DateUtil.StringToDate(currentGmtCreateTime, DateStyle.YYYY_MM_DD_HH_MM_SS);
//                if (date == null) {
//                    return null;
//                }
//                Long timeStamp = date.getTime();

                Long timeStamp = LocalDateUtil.getTimeMillis(currentGmtCreateTime, DateStyle.YYYY_MM_DD_HH_MM_SS.getValue());

                Long otherTimeStamp = Long.valueOf(lastGmtCreateTime);
                if (timeStamp == null || otherTimeStamp == null) {
                    return ret;
                }
                Long seconds = (long) (Math.abs((timeStamp - otherTimeStamp) / 1000));

                ret = seconds;
            }
        }
        return ret;
    }

    //当日用户该资源累计点击数 f770401
    public static Long getResourceChargeCnt(String operatingResource, Map<String, Long> dayResourceChargeCnt) {
        Long ret = null;
        if (operatingResource == null || dayResourceChargeCnt == null) {
            ret = null;
        } else {
            Long cnt = dayResourceChargeCnt.get(operatingResource + "-770401");
            ret = cnt;
        }
        return ret;
    }

    //当日用户该资源累计转化数 f770402
    public static Long getResourceConvertCnt(String operatingResource, Map<String, Long> dayResourceConvertCnt) {
        Long ret = null;
        if (operatingResource == null || dayResourceConvertCnt == null) {
            ret = null;
        } else {
            Long cnt = dayResourceConvertCnt.get(operatingResource + "-770402");
            ret = cnt;
        }
        return ret;
    }


    public static Long getNewTradeOrderRank(String operatingNewTrade, Map<String, Long> newTradeDayOrderRank) {
        Long ret = null;
        if (AssertUtil.isAllNotEmpty(operatingNewTrade, newTradeDayOrderRank)) {
            Long rank = newTradeDayOrderRank.get(operatingNewTrade + "-660101");
            ret = rank;
        }
        return ret;
    }

    //计算用户当日该综合行业前后单时间差（分桶）f660302
    public static Long getLastNewTradeGmtIntervelLevel(String operatingNewTrade, String currentGmtCreateTime, Map<String, String> newTradeLastGmtCreateTime) {
        Long ret = null;
        if (AssertUtil.isAllNotEmpty(operatingNewTrade, currentGmtCreateTime, newTradeLastGmtCreateTime)) {
            String lastGmtCreateTime = newTradeLastGmtCreateTime.get(operatingNewTrade + "-660301");
            if (lastGmtCreateTime == null) {
                ret = null;
            } else {
                Long timeStamp = LocalDateUtil.getTimeMillis(currentGmtCreateTime, DateStyle.YYYY_MM_DD_HH_MM_SS.getValue());
                Long otherTimeStamp = Long.valueOf(lastGmtCreateTime);

                if (AssertUtil.isAnyEmpty(timeStamp, otherTimeStamp)) {
                    return ret;
                }
                Long seconds = (long) (Math.abs((timeStamp - otherTimeStamp) / 1000));

                ret = seconds;
            }
        }
        return ret;
    }

    public static void main(String[] args) {
        HashMap<String, String> map = new HashMap<>();
        map.put("1", "1");
        map.put("2", "2");
        map.put("3", "3");

        System.out.println(map);

        String remove = map.remove("4");
        System.out.println(remove);

        System.out.println(map);
    }
}
