package cn.com.duiba.nezha.alg.feature.vo;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * Created by pc on 2019/2/21.
 */
@Data
public class AdxFeatureDo implements Serializable {
    private static final long serialVersionUID = 6695201251295150673L;

    //推广组
    private Long groupId; // 推广组ID f1010010
    private Integer adxType; // 平台类型 f1010020
    private String cat; // 推广组对应类别 f1010030
    private String tuiaCat; // 推啊平台的推广组对应类别(标准) f1010031
    private String sectionCat; // 推广组当前部分的类别 f1010040
    private String tuiaSectionCat; // 推啊平台的推广组当前部分的类别(标准) f1010041
    private String keywords; // 推广组关键词 f1010050


    //资源位
    private Long resourceId; // 资源位ID f2010010
    private Integer advertType; // 广告类型 f2010020
    private Integer posType; // 广告位类型 f2010030
    private Integer posStyle; // 广告位样式 f2010040
    private String specCode; // 广告类型编码 f2010050


    //创意特征
    private Long ideaId; // 创意ID f3010010
    private String buttonText; // 按钮文字 f3010020
    private Integer iconH; // 创意图标高 f3010030
    private Integer iconW; // 创意图标宽 f3010040
    private Integer mjPicType; // 规格类型 f3010050
    private Integer ideaPicH1; // 创意图片高1 f3010060
    private Integer ideaPicW1; // 创意图片宽1 f3010070
    private Integer ideaPicH2; // 创意图片高2 f3010080
    private Integer ideaPicW2; // 创意图片宽2 f3010090
    private Integer ideaPicH3; // 创意图片高3 f3010100
    private Integer ideaPicW3; // 创意图片宽3 f3010110
    private Integer ideaPicNum; // 创意图片个数 f3010120
    private Integer styleStandard; // 广告样式规格 f3010130
    private Integer ideaType; //互动创意类型(0-普通静态创意，1-动态创意) f3010140

    //创意素材标签特征
    private Long materialId; //素材ID
    private Integer pictureType; //素材图片类型（1=图片 3=视频）f3030000
    private List<AdxIdeaMaterialDo> pictureMaterialDo; //图片素材特征
    private List<AdxIdeaMaterialDo> videoMaterialDo; //视频素材特征

    //创意+分媒体行为特征
    private Long ideaAppExpCntDay; //创意+百度appId 当天曝光次数 f3060011
    private Long ideaAppClickCntDay; //创意+百度appId 当天点击次数 f3060012
    private Long ideaAppAdCostDay; //创意+百度appId 当天广告消耗	 f3060013


    //上下文
    private String ua; // ua f4010010
    private String ip; // ip f4010020
    private Long areaCode; // 地域 f4010030
    private Integer deviceType; // 设备类型 f4010040
    private Integer tuiaDeviceType; // 推啊平台的设备类型(标准) f4010041
    private String make; // 设备厂商 f4010050
    private String model; // 设备型号 f4010060
    private String os; // 操作系统 f4010070
    private String carrier; // 运营商 f4010080
    private Integer connectionType; // 联网方式 f4010090
    private Integer tuiaConnectionType; // 推啊平台的联网方式(标准) f4010091
    private Float lat; // 纬度 f4010100
    private Float lon; // 经度 f4010110
    private Long currentCreatTime; // 参与当前竞价请求的创建时间(时间戳) f4010120


    //用户行为
    private String gender; // 性别 f5010010
    private String interestKeyWords; // 用户兴趣 f5010020
    private String yob; // 出生年月 f5010030
    private Map<Long, Object> expTimeMap; // 该创意+设备号的当天累计曝光次数 f5010040
    private String imei; // 设备号 f5010050

    private Map<String, Long> imeiDayBidTimes; // 设备号 当天竞价次数  f5010060
    private Map<String, Long> imeiDayExpTimes; // 设备号 当天曝光次数  f5010070
    private Map<String, Long> resoDayBidTimes; // 资源位id+设备号 当天竞价次数  f5010080
    private Map<String, Long> resoDayExpTimes; // 资源位id+设备号 当天曝光次数  f5010090

    private String newSex; // (爱奇艺)性别标签 f5010100

    //上下文-新增
    private String appName; // 应用名称 f6010010
    private String appBundle; // 包名 f6010020
    private String appPageCat; // 应用当前页类型 f6010030
    private Integer appPaid; // 0-免费 1-付费 f6010040
    private String geoCountry; // 设备位置信息-国家 f6010050
    private String geoRegion; // 设备位置信息-地区 f6010060
    private String geoCity; //设备位置信息-城市 f6010070
    private Integer geoType; //设备位置信息-定位类型 f6010080
    private String tagId; // adx资源位，竞价广告位ID（adx方） f6010090
    private Integer tagIndex; // adx资源位，竞价广告位顺序索引（adx方） f6010100
    private String appIndustryId; //app所属行业id f6010110

    //资源位+分媒体行为特征
    private Long resoAppExpCntDay; //资源位+百度appId  近1h曝光次数 f6060011
    private Long resoAppClickCntDay; //资源位+百度appId  近1h点击次数 f6060012
    private Long resoAppAdCostDay; //资源位+百度appId  近1h广告消耗 f6060013


    // DMP数据引入
    private String userTagsList; //f7010010, 用户标签列表
    private String appList; //f7020010, app安装列表
    private String messageNameList; //f7030010, 短信签名列表
    //dmp特征加工
    private DmpFeature dmpFeature;

    //adx用户素材行为数据
    private String expDayMaterials; //用户当天曝光的素材序列（曝光降序）TOP30
    private String clickDayMaterials; //用户当天点击的素材序列（点击降序）TOP30
    private String expWeekMaterials; //用户近7天曝光的素材序列 (曝光降序) TOP30
    private String clickWeekMaterials; //用户近7天点击的素材序列（点击降序）TOP30
    private String resoExpDayMaterials; //用户+资源位，当天曝光的素材序列（曝光降序）TOP30
    private String resoClickDayMaterials; //用户+资源位，当天点击的素材序列（点击降序）TOP30
    private Long lastExpMaterialId; //用户+资源位，上次曝光的素材id
    private Long lastClickMaterialId; //用户+资源位，上次点击的素材id


    //adx特定数据特征
    private AiQiYiFeature aiQiYiFeature;//爱奇艺数据特征
    private MgTvFeature mgTvFeature;//芒果tv数据特征
    private BaiDuFeature baiDuFeature;//百度联盟数据特征

    //PD特征
    private Integer pmpType; //0-RTB 1-PD 2-PDB f3020000
    private Long dealId; // PD deal ID f3020010
    private Long price; // PD ldeal出价 f3020020

    //创意+活动特征
    private Long ideaActAccCntDay;   //创意 当天活动访问次数
    private Long ideaActJoinCntDay;   //创意 当天活动参与次数
    private Long ideaActAccCntWeek;   //创意 一周活动访问次数
    private Long ideaActJoinCntWeek;   //创意 一周活动参与次数

    private Long matActReqDay;   //素材 当天活动访问次数
    private Long matActJoinDay;   //素材 当天活动参与次数
    private Long matAdvertExpDay;   //素材 当天广告曝光次数
    private Long matAdvertClkDay;   //素材 当天广告点击次数

    private Long matActReq7d;   //素材 7天活动访问次数
    private Long matActJoin7d;   //素材 7天活动参与次数
    private Long matAdvertExp7d;   //素材 7天广告曝光次数
    private Long matAdvertClk7d;   //素材 7天广告点击次数

    private Long matActReq28d;   //素材 28天活动访问次数
    private Long matActJoin28d;   //素材 28天活动参与次数
    private Long matAdvertExp28d;   //素材 28天广告曝光次数
    private Long matAdvertClk28d;   //素材 28天广告点击次数

    private Long matResoActReqDay;   //素材+资源位 当天活动访问次数
    private Long matResoActJoinDay;   //素材+资源位 当天活动参与次数
    private Long matResoAdvertExpDay;   //素材+资源位 当天广告曝光次数
    private Long matResoAdvertClkDay;   //素材+资源位 当天广告点击次数

    private Long matResoActReq7d;   //素材+资源位 7天活动访问次数
    private Long matResoActJoin7d;   //素材+资源位 7天活动参与次数
    private Long matResoAdvertExp7d;   //素材+资源位 7天广告曝光次数
    private Long matResoAdvertClk7d;   //素材+资源位 7天广告点击次数

    private Long matResoActReq28d;   //素材+资源位 28天活动访问次数
    private Long matResoActJoin28d;   //素材+资源位 28天活动参与次数
    private Long matResoAdvertExp28d;   //素材+资源位 28天广告曝光次数
    private Long matResoAdvertClk28d;   //素材+资源位 28天广告点击次数

    private Map<Long, Long> matAdvertTradeExp7d; //素材 7天内不同广告行业券曝光次数
    private Map<Long, Long> matAdvertTradeClk7d; //素材 7天内不同广告行业券点击次数
    private Map<Long, Long> matAdvertTradeExp28d; //素材 28天内不同广告行业券曝光次数
    private Map<Long, Long> matAdvertTradeClk28d; //素材 28天内不同广告行业券点击次数

    private Map<Long, Long> matResoAdvertTradeExp7d; //素材+资源位 7天内不同广告行业券曝光次数
    private Map<Long, Long> matResoAdvertTradeClk7d; //素材+资源位 7天内不同广告行业券点击次数
    private Map<Long, Long> matResoAdvertTradeExp28d; //素材+资源位 28天内不同广告行业券曝光次数
    private Map<Long, Long> matResoAdvertTradeClk28d; //素材+资源位 28天内不同广告行业券点击次数

    //活动+创意行为数据
    private Map<Long, Long> actIdeaActAccCntDay;    //活动+创意 当天活动访问数据
    private Map<Long, Long> actIdeaActJoinCntDay;    //活动+创意 当天活动参与数据
    private Map<Long, Long> actIdeaActAccCntWeek;    //活动+创意 一周活动访问数据
    private Map<Long, Long> actIdeaActJoinCntWeek;    //活动+创意 一周活动参与数据


    public Long getGroupId() {
        return groupId;
    }

    public void setGroupId(Long groupId) {
        this.groupId = groupId;
    }

    public Integer getAdxType() {
        return adxType;
    }

    public void setAdxType(Integer adxType) {
        this.adxType = adxType;
    }

    public String getCat() {
        return cat;
    }

    public void setCat(String cat) {
        this.cat = cat;
    }

    public String getTuiaCat() {
        return tuiaCat;
    }

    public void setTuiaCat(String tuiaCat) {
        this.tuiaCat = tuiaCat;
    }

    public String getSectionCat() {
        return sectionCat;
    }

    public void setSectionCat(String sectionCat) {
        this.sectionCat = sectionCat;
    }

    public String getTuiaSectionCat() {
        return tuiaSectionCat;
    }

    public void setTuiaSectionCat(String tuiaSectionCat) {
        this.tuiaSectionCat = tuiaSectionCat;
    }

    public String getKeywords() {
        return keywords;
    }

    public void setKeywords(String keywords) {
        this.keywords = keywords;
    }

    public Long getResourceId() {
        return resourceId;
    }

    public void setResourceId(Long resourceId) {
        this.resourceId = resourceId;
    }

    public Integer getAdvertType() {
        return advertType;
    }

    public void setAdvertType(Integer advertType) {
        this.advertType = advertType;
    }

    public Integer getPosType() {
        return posType;
    }

    public void setPosType(Integer posType) {
        this.posType = posType;
    }

    public Integer getPosStyle() {
        return posStyle;
    }

    public void setPosStyle(Integer posStyle) {
        this.posStyle = posStyle;
    }

    public String getSpecCode() {
        return specCode;
    }

    public void setSpecCode(String specCode) {
        this.specCode = specCode;
    }

    public Long getIdeaId() {
        return ideaId;
    }

    public void setIdeaId(Long ideaId) {
        this.ideaId = ideaId;
    }

    public String getButtonText() {
        return buttonText;
    }

    public void setButtonText(String buttonText) {
        this.buttonText = buttonText;
    }

    public Integer getIconH() {
        return iconH;
    }

    public void setIconH(Integer iconH) {
        this.iconH = iconH;
    }

    public Integer getIconW() {
        return iconW;
    }

    public void setIconW(Integer iconW) {
        this.iconW = iconW;
    }

    public Integer getMjPicType() {
        return mjPicType;
    }

    public void setMjPicType(Integer mjPicType) {
        this.mjPicType = mjPicType;
    }

    public Integer getIdeaPicH1() {
        return ideaPicH1;
    }

    public void setIdeaPicH1(Integer ideaPicH1) {
        this.ideaPicH1 = ideaPicH1;
    }

    public Integer getIdeaPicW1() {
        return ideaPicW1;
    }

    public void setIdeaPicW1(Integer ideaPicW1) {
        this.ideaPicW1 = ideaPicW1;
    }

    public Integer getIdeaPicH2() {
        return ideaPicH2;
    }

    public void setIdeaPicH2(Integer ideaPicH2) {
        this.ideaPicH2 = ideaPicH2;
    }

    public Integer getIdeaPicW2() {
        return ideaPicW2;
    }

    public void setIdeaPicW2(Integer ideaPicW2) {
        this.ideaPicW2 = ideaPicW2;
    }

    public Integer getIdeaPicH3() {
        return ideaPicH3;
    }

    public void setIdeaPicH3(Integer ideaPicH3) {
        this.ideaPicH3 = ideaPicH3;
    }

    public Integer getIdeaPicW3() {
        return ideaPicW3;
    }

    public void setIdeaPicW3(Integer ideaPicW3) {
        this.ideaPicW3 = ideaPicW3;
    }

    public Integer getIdeaPicNum() {
        return ideaPicNum;
    }

    public void setIdeaPicNum(Integer ideaPicNum) {
        this.ideaPicNum = ideaPicNum;
    }

    public Integer getStyleStandard() {
        return styleStandard;
    }

    public void setStyleStandard(Integer styleStandard) {
        this.styleStandard = styleStandard;
    }

    public List<AdxIdeaMaterialDo> getPictureMaterialDo() { return pictureMaterialDo; }

    public void setPictureMaterialDo(List<AdxIdeaMaterialDo> pictureMaterialDo) { this.pictureMaterialDo = pictureMaterialDo; }

    public List<AdxIdeaMaterialDo> getVideoMaterialDo() { return videoMaterialDo; }

    public void setVideoMaterialDo(List<AdxIdeaMaterialDo> videoMaterialDo) { this.videoMaterialDo = videoMaterialDo; }

    public String getUa() {
        return ua;
    }

    public void setUa(String ua) {
        this.ua = ua;
    }

    public String getIp() {
        return ip;
    }

    public void setIp(String ip) {
        this.ip = ip;
    }

    public Long getAreaCode() {
        return areaCode;
    }

    public void setAreaCode(Long areaCode) {
        this.areaCode = areaCode;
    }

    public Integer getDeviceType() {
        return deviceType;
    }

    public void setDeviceType(Integer deviceType) {
        this.deviceType = deviceType;
    }

    public Integer getTuiaDeviceType() {
        return tuiaDeviceType;
    }

    public void setTuiaDeviceType(Integer tuiaDeviceType) {
        this.tuiaDeviceType = tuiaDeviceType;
    }

    public String getMake() {
        return make;
    }

    public void setMake(String make) {
        this.make = make;
    }

    public String getModel() {
        return model;
    }

    public void setModel(String model) {
        this.model = model;
    }

    public String getOs() {
        return os;
    }

    public void setOs(String os) {
        this.os = os;
    }

    public String getCarrier() {
        return carrier;
    }

    public void setCarrier(String carrier) {
        this.carrier = carrier;
    }

    public Integer getConnectionType() {
        return connectionType;
    }

    public void setConnectionType(Integer connectionType) {
        this.connectionType = connectionType;
    }

    public Integer getTuiaConnectionType() {
        return tuiaConnectionType;
    }

    public void setTuiaConnectionType(Integer tuiaConnectionType) {
        this.tuiaConnectionType = tuiaConnectionType;
    }

    public Float getLat() {
        return lat;
    }

    public void setLat(Float lat) {
        this.lat = lat;
    }

    public Float getLon() {
        return lon;
    }

    public void setLon(Float lon) {
        this.lon = lon;
    }

    public Long getCurrentCreatTime() {
        return currentCreatTime;
    }

    public void setCurrentCreatTime(Long currentCreatTime) {
        this.currentCreatTime = currentCreatTime;
    }

    public String getGender() {
        return gender;
    }

    public void setGender(String gender) {
        this.gender = gender;
    }

    public String getInterestKeyWords() {
        return interestKeyWords;
    }

    public void setInterestKeyWords(String interestKeyWords) {
        this.interestKeyWords = interestKeyWords;
    }

    public String getYob() {
        return yob;
    }

    public void setYob(String yob) {
        this.yob = yob;
    }

    public Map<Long, Object> getExpTimeMap() {
        return expTimeMap;
    }

    public void setExpTimeMap(Map<Long, Object> expTimeMap) {
        this.expTimeMap = expTimeMap;
    }

    public String getImei() {
        return imei;
    }

    public void setImei(String imei) {
        this.imei = imei;
    }

    public Map<String, Long> getImeiDayBidTimes() {
        return imeiDayBidTimes;
    }

    public void setImeiDayBidTimes(Map<String, Long> imeiDayBidTimes) {
        this.imeiDayBidTimes = imeiDayBidTimes;
    }

    public Map<String, Long> getImeiDayExpTimes() {
        return imeiDayExpTimes;
    }

    public void setImeiDayExpTimes(Map<String, Long> imeiDayExpTimes) {
        this.imeiDayExpTimes = imeiDayExpTimes;
    }

    public Map<String, Long> getResoDayBidTimes() {
        return resoDayBidTimes;
    }

    public void setResoDayBidTimes(Map<String, Long> resoDayBidTimes) {
        this.resoDayBidTimes = resoDayBidTimes;
    }

    public Map<String, Long> getResoDayExpTimes() {
        return resoDayExpTimes;
    }

    public void setResoDayExpTimes(Map<String, Long> resoDayExpTimes) {
        this.resoDayExpTimes = resoDayExpTimes;
    }

    public String getAppName() {
        return appName;
    }

    public void setAppName(String appName) {
        this.appName = appName;
    }

    public String getAppBundle() {
        return appBundle;
    }

    public void setAppBundle(String appBundle) {
        this.appBundle = appBundle;
    }

    public String getAppPageCat() {
        return appPageCat;
    }

    public void setAppPageCat(String appPageCat) {
        this.appPageCat = appPageCat;
    }

    public Integer getAppPaid() {
        return appPaid;
    }

    public void setAppPaid(Integer appPaid) {
        this.appPaid = appPaid;
    }

    public String getGeoCountry() {
        return geoCountry;
    }

    public void setGeoCountry(String geoCountry) {
        this.geoCountry = geoCountry;
    }

    public String getGeoRegion() {
        return geoRegion;
    }

    public void setGeoRegion(String geoRegion) {
        this.geoRegion = geoRegion;
    }

    public String getGeoCity() {
        return geoCity;
    }

    public void setGeoCity(String geoCity) {
        this.geoCity = geoCity;
    }

    public Integer getGeoType() {
        return geoType;
    }

    public void setGeoType(Integer geoType) {
        this.geoType = geoType;
    }

    public String getTagId() {
        return tagId;
    }

    public void setTagId(String tagId) {
        this.tagId = tagId;
    }

    public Integer getTagIndex() {
        return tagIndex;
    }

    public void setTagIndex(Integer tagIndex) {
        this.tagIndex = tagIndex;
    }

    public String getAppIndustryId() { return appIndustryId; }

    public void setAppIndustryId(String appIndustryId) { this.appIndustryId = appIndustryId; }

    public String getUserTagsList() { return userTagsList; }

    public void setUserTagsList(String userTagsList) { this.userTagsList = userTagsList; }

    public String getAppList() { return appList; }

    public void setAppList(String appList) { this.appList = appList; }

    public String getMessageNameList() { return messageNameList; }

    public void setMessageNameList(String messageNameList) { this.messageNameList = messageNameList; }

    public DmpFeature getDmpFeature() { return dmpFeature; }

    public void setDmpFeature(DmpFeature dmpFeature) { this.dmpFeature = dmpFeature; }

    public AiQiYiFeature getAiQiYiFeature() { return aiQiYiFeature; }

    public void setAiQiYiFeature(AiQiYiFeature aiQiYiFeature) { this.aiQiYiFeature = aiQiYiFeature; }

    public MgTvFeature getMgTvFeature() { return mgTvFeature; }

    public void setMgTvFeature(MgTvFeature mgTvFeature) { this.mgTvFeature = mgTvFeature; }

    public BaiDuFeature getBaiDuFeature() { return baiDuFeature; }

    public void setBaiDuFeature(BaiDuFeature baiDuFeature) { this.baiDuFeature = baiDuFeature; }

    public Integer getPmpType() { return pmpType; }

    public void setPmpType(Integer pmpType) { this.pmpType = pmpType; }

    public Long getDealId() { return dealId; }

    public void setDealId(Long dealId) { this.dealId = dealId; }

    public Long getPrice() { return price; }

    public void setPrice(Long price) { this.price = price; }

}
