package cn.com.duiba.nezha.alg.feature.vo;

import lombok.Data;

import java.util.List;

@Data
public class RtaFeatureDo {
    private static final long serialVersionUID = 6695201251295150673L;

    // 实时用户属性特征，上次入口曝光的
    private String slotId; // 上次曝光的广告位id
    private String extIdeaId; // 上次曝光的外部创意id
    private String extAdPlace; // 上次曝光的外部广告投放场景
    private String extAdvertGroupId; // 上次曝光的外部广告组id
    private String extAdvertId; // 上次曝光的外部广告计划id
    private String extUnionAppId; // 上次曝光的外部媒体id
    private String extAccountId; // 上次曝光的媒体开户账号id
    private String extUnionSlotId; // 上次曝光的外部广告位id
    private String extPlatform; // 上次曝光的外部平台id

    private String slotIdOffline; // 上次曝光的广告位id 离线
    private String extIdeaIdOffline; // 上次曝光的外部创意id 离线
    private String extAdPlaceOffline; // 上次曝光的外部广告投放场景 离线
    private String extAdvertGroupIdOffline; // 上次曝光的外部广告组id 离线
    private String extAdvertIdOffline; // 上次曝光的外部广告计划id 离线
    private String extUnionAppIdOffline; // 上次曝光的外部媒体id 离线
    private String extAccountIdOffline; // 上次曝光的媒体开户账号id 离线
    private String extUnionSlotIdOffline; // 上次曝光的外部广告位id 离线
    private String extPlatformOffline; // 上次曝光的外部平台id 离线

    // DMP特征
    private String gender; // 性别
    private String age; // 年龄
    private String marital; // 婚育情况
    private String isp; // 运营商（联通/移动/电信等）

    // 实时用户统计特征
    private String cityIdPv180d; // 最近180天访问城市个数
    private String lastestCityId; // 实时城市
    private String lastestCityLevel; // 实时城市等级
    private String stayCityId; // 常驻地(城市)
    private String stayCityLevel; // 常驻城市等级
    private String stayWorkRegionId; // 常驻工作地(区)
    private String stayLiveRegionId; // 常驻居住地(区)
    private String homeCityId; // 户籍地(城市)
    private String homeCityLevel; // 户籍城市等级

    private Long userCvtPv1d;   // 用户历史1天目标转化次数
    private Long userConsume1d; // 用户历史1天消耗
    private Long userCvtPv7d;   // 用户历史7天目标转化次数
    private Long userConsume7d; // 用户历史7天消耗
    private Long userCvtPv14d;  // 用户历史14天目标转化次数
    private Long userConsume14d;// 用户历史14天消耗

    // 实时用户统计特征
    private Long userExpPv; // 用户当天入口曝光次数
    private Long userActReqPv; // 用户当天活动访问次数
    private Long userAdvLaunchPv; // 用户当天发券次数
    private Long userAdvClkPv; // 用户当天券计费点击次数

    // 用户历史统计特征
    private Long userReqPv1d; // 用户历史1天请求次数
    private Long userExpPv1d; // 用户历史1天入口曝光次数
    private Long userActReqPv1d; // 用户历史1天活动访问次数
    private Long userAdvLaunchPv1d; // 用户历史1天发券次数
    private Long userAdvClkPv1d; // 用户历史1天券计费点击次数

    private Long userReqPv7d; // 用户历史7天请求次数
    private Long userExpPv7d; // 用户历史7天入口曝光次数
    private Long userActReqPv7d; // 用户历史7天活动访问次数
    private Long userAdvLaunchPv7d; // 用户历史7天发券次数
    private Long userAdvClkPv7d; // 用户历史7天券计费点击次数

    private Long userReqPv14d; // 用户历史14天请求次数
    private Long userExpPv14d; // 用户历史14天入口曝光次数
    private Long userActReqPv14d; // 用户历史14天活动访问次数
    private Long userAdvLaunchPv14d; // 用户历史14天发券次数
    private Long userAdvClkPv14d; // 用户历史14天券计费点击次数

    // 用户历史序列特征(截断到20个）
    private List<String> user_exp_list;              // 用户历史创意id曝光列表
    private List<String> user_clk_list;              // 用户历史创意id点击列表
    private List<String> user_act_req_list;          // 用户历史活动id访问列表
    private List<String> user_act_join_list;         // 用户历史活动id参与列表
    private List<String> user_adv_launch_list;       // 用户历史券id曝光列表
    private List<String> user_adv_clk_list;          // 用户历史券id计费点击列表
    private List<String> user_adv_launch_trade_list; // 用户历史券行业id曝光列表
    private List<String> user_adv_clk_trade_list;    // 用户历史券行业id计费点击列表
}
