/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.alg.feature.coder;

import cn.com.duiba.nezha.alg.feature.coder.FeatureCoderBase;
import cn.com.duiba.nezha.alg.feature.type.FeatureBaseType;
import cn.com.duiba.nezha.alg.feature.vo.CodeResult;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class FeatureCoder
extends FeatureCoderBase {
    private static int F_MAX_SIZE = 64;
    public static Map<String, List<FeatureBaseType>> cache = new HashMap<String, List<FeatureBaseType>>();

    public static CodeResult code(List<FeatureBaseType> list, Map<String, String> featureMap) throws Exception {
        CodeResult codeResult = new CodeResult();
        ArrayList<Integer> indices = new ArrayList<Integer>(F_MAX_SIZE);
        ArrayList<Double> values = new ArrayList<Double>(F_MAX_SIZE);
        ArrayList<String> fields = new ArrayList<String>(F_MAX_SIZE);
        ArrayList<Long> pLenList = new ArrayList<Long>(F_MAX_SIZE);
        ArrayList<Set<Long>> ret = new ArrayList<Set<Long>>(F_MAX_SIZE);
        for (FeatureBaseType featureBaseType : list) {
            String value = featureMap.getOrDefault(featureBaseType.getName(), null);
            Set<Long> retSub = featureBaseType.code(value, pLenList, indices, values);
            ret.add(retSub);
            for (int i = 0; i < retSub.size(); ++i) {
                fields.add(featureBaseType.getName());
            }
        }
        codeResult.setFeature(FeatureCoderBase.toFeature(indices, values, pLenList, fields));
        codeResult.setFeatureSet(ret);
        return codeResult;
    }

    public static CodeResult codeOfEachField(List<FeatureBaseType> list, Map<String, String> featureMap) throws Exception {
        CodeResult codeResult = new CodeResult();
        ArrayList<Integer> indices = new ArrayList<Integer>(F_MAX_SIZE);
        ArrayList<Double> values = new ArrayList<Double>(F_MAX_SIZE);
        ArrayList<String> fields = new ArrayList<String>(F_MAX_SIZE);
        ArrayList<Set<Long>> ret = new ArrayList<Set<Long>>(F_MAX_SIZE);
        HashMap<String, Map<Long, Double>> fieldFeatureMap = new HashMap<String, Map<Long, Double>>();
        for (FeatureBaseType featureBaseType : list) {
            String value = featureMap.getOrDefault(featureBaseType.getName(), null);
            Set<Long> retSub = featureBaseType.code(value);
            ret.add(retSub);
            ArrayList<Long> retSubList = new ArrayList<Long>(retSub);
            HashMap<Long, Double> subFiledFeatureMap = new HashMap<Long, Double>();
            for (int i = 0; i < retSub.size(); ++i) {
                indices.add(((Long)retSubList.get(i)).intValue());
                values.add(1.0 / (double)retSub.size());
                fields.add(featureBaseType.getName());
                subFiledFeatureMap.put((long)((Long)retSubList.get(i)).intValue() + 0L, 1.0 / (double)retSub.size());
            }
            fieldFeatureMap.put(featureBaseType.getName(), subFiledFeatureMap);
        }
        codeResult.setFeature(FeatureCoderBase.toFeature(indices, values, fields, 10000000));
        codeResult.setFeatureSet(ret);
        codeResult.setFieldFeatureMap(fieldFeatureMap);
        return codeResult;
    }

    public static void main(String[] args) {
        HashMap<String, String> featureMap = new HashMap<String, String>();
        featureMap.put("f101001", "3");
        featureMap.put("f102001", "d3,3");
        featureMap.put("f305001", "8");
        featureMap.put("f501001", "UNKONWN");
    }
}

