package cn.com.duiba.nezha.alg.feature.vo;

import com.alibaba.fastjson.JSON;

import java.util.List;

public class Feature {
    public int size;

    public int endIndex;

    public List<Integer> indices;

    public List<Double> valueList;

    public double[] values;

//    public String[] fields;

    public List<String> fields;

    public Feature(int size, List<Integer> indices, double[] values, List<String> fields) throws Exception {

//        System.out.println("size=" + size + "indices=" + JSON.toJSONString(indices) + "value=" + JSON.toJSONString(values));
        if (size <= 0) {
            throw new Exception("size<=0,input invalid");
        }
        if (indices == null || values == null || fields == null) {
            throw new Exception("indices or values  or fields is null,input invalid");
        }

        if (indices.size() != values.length) {
            throw new Exception("indices.length != values.length,input invalid");
        }
        if (indices.size() != fields.size()) {
            throw new Exception("indices.length != values.length,input invalid");
        }


        if (indices.size() > 0 && size < indices.get(indices.size() - 1)) {
            throw new Exception("indices beyond the boundary,input invalid");
        }

        this.size = size;
        this.indices = indices;
        this.values = values;
        this.fields = fields;

    }

    public Feature(int size, List<Integer> indices, List<Double> valueList, List<String> fields) throws Exception {

//        System.out.println("size="+size+"indices="+ JSON.toJSONString(indices)+"value="+ JSON.toJSONString(values));
        if (size <= 0) {
            throw new Exception("size<=0,input invalid");
        }
        if (indices == null || values == null || fields == null) {
            throw new Exception("indices or values  or fields is null,input invalid");
        }

        if (indices.size() != valueList.size()) {
            throw new Exception("indices.length != values.length,input invalid");
        }
        if (indices.size() != fields.size()) {
            throw new Exception("indices.length != values.length,input invalid");
        }


        if (indices.size() > 0 && size < indices.get(indices.size() - 1)) {
            throw new Exception("indices beyond the boundary,input invalid");
        }

        this.size = size;
        this.indices = indices;
        this.valueList = valueList;
        this.fields = fields;

    }


    public Feature toFeature() throws Exception {

        double[] values2 = new double[indices.size()];

        for (int i = 0; i < indices.size(); i++) {
//            indices2[i] = indices.get(i);
            values2[i] = valueList.get(i);
        }

        return new Feature(size, indices, values2, fields);

    }


}
