/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.alg.feature.vo.v2023;

import cn.com.duiba.bigdata.dmp.service.api.remoteservice.dto.DmpFeatureDto;
import cn.com.duiba.nezha.alg.feature.parse.BaseParse;
import cn.com.duiba.nezha.alg.feature.parse.v2.DeviceFeatureParseV2;
import cn.com.duiba.nezha.alg.feature.util.DataConverter;
import cn.com.duiba.nezha.alg.feature.vo.UserActFeature;
import cn.com.duiba.nezha.alg.feature.vo.v2023.AdContextFeatureDoV3;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

public class AdFeatureDoV3
implements Serializable {
    private static final long serialVersionUID = 6695201251295150673L;
    private String advertId;
    private String packageId;
    private String accountId;
    private String OperatingResource;
    private String adNewTrade;
    private Long landpageId;
    private Long frontpageId;
    private Long paypageId;
    private Long formpageId;
    private Long modelId;
    private String materialId;
    private String materialTags;
    private String times;
    private String targetConvertType;
    private String deepTargetConvertType;

    public Map<String, String> parse(AdContextFeatureDoV3 data3) {
        HashMap<String, String> retMap = new HashMap<String, String>(32);
        AdFeatureDoV3.putMap(retMap, "ft200101", this.advertId);
        AdFeatureDoV3.putMap(retMap, "ft200101", this.advertId);
        AdFeatureDoV3.putMap(retMap, "ft200102", this.accountId);
        AdFeatureDoV3.putMap(retMap, "ft200103", this.OperatingResource);
        AdFeatureDoV3.putMap(retMap, "ft200104", this.adNewTrade);
        AdFeatureDoV3.putMap(retMap, "ft200106", this.materialId);
        AdFeatureDoV3.putMap(retMap, "ft200107", this.materialTags);
        AdFeatureDoV3.putMap(retMap, "ft200109", this.times);
        AdFeatureDoV3.putMap(retMap, "ft200301", this.landpageId);
        AdFeatureDoV3.putMap(retMap, "ft200302", this.frontpageId);
        AdFeatureDoV3.putMap(retMap, "ft200303", this.paypageId);
        AdFeatureDoV3.putMap(retMap, "ft200304", this.formpageId);
        AdFeatureDoV3.putMap(retMap, "ft200305", this.modelId);
        retMap.put("ft200201", this.targetConvertType);
        retMap.put("ft200202", this.deepTargetConvertType);
        retMap.put("ft500101", this.advertId + "_" + this.targetConvertType);
        retMap.put("ft500201", this.advertId + "_" + this.deepTargetConvertType);
        retMap.put("ft500103", this.adNewTrade + "_" + this.targetConvertType);
        retMap.put("ft500203", this.adNewTrade + "_" + this.deepTargetConvertType);
        UserActFeature userActFeature = Optional.ofNullable(data3.getUserActFeature()).orElse(new UserActFeature());
        String lastActivity = userActFeature.getLastActivity();
        String lastLaunchTrade = userActFeature.getLastLaunchTrade();
        String lastResource = userActFeature.getLastResource();
        String lastAccount = userActFeature.getLastLaunchAccount();
        String lastAdvert = userActFeature.getLastLaunchPlan();
        String lastActivityLaunchOrder = userActFeature.getLastActivityLaunchOrder();
        String lastActivityClickOrder = userActFeature.getLastActivityClickOrder();
        retMap.put("ft110901", lastActivity);
        retMap.put("ft110902", lastLaunchTrade);
        retMap.put("ft110903", lastResource);
        retMap.put("ft110904", lastAccount);
        retMap.put("ft110905", lastAdvert);
        retMap.put("ft110906", userActFeature.getClickLaunchTrade() == null ? null : userActFeature.getClickLaunchTrade().toString());
        retMap.put("ft110907", userActFeature.getEffectClickTrade() == null ? null : userActFeature.getEffectClickTrade().toString());
        retMap.put("ft110908", DataConverter.getMatchStatus(lastLaunchTrade, this.adNewTrade));
        retMap.put("ft110909", DataConverter.getMatchStatus(lastAdvert, this.advertId));
        retMap.put("ft110910", DataConverter.getMatchStatus(lastActivity, data3.getActivityId().toString()));
        String curOrderTime = data3.getCurrentGmtCreateTime();
        String lastLaunchTime = userActFeature.getLastLaunchTime();
        String lastActivityTime = userActFeature.getLastActivityLaunchTime();
        retMap.put("ft110911", DataConverter.bucket((Number)DataConverter.getTimeInterval(lastLaunchTime, curOrderTime, "m"), (Number[])BaseParse.orderGmtIntervelBucket));
        retMap.put("ft110912", DataConverter.bucketRight((Number)DataConverter.getTimeInterval(lastActivityTime, curOrderTime, "m"), (Number[])BaseParse.orderActGmtIntervelBucket));
        retMap.put("ft110913", DataConverter.bucketRight((Number)DataConverter.getTimeInterval(lastLaunchTime, curOrderTime, "m"), (Number[])BaseParse.orderActGmtIntervelBucket));
        retMap.put("ft110914", DataConverter.getMatchStatus2(lastActivityLaunchOrder, lastActivityClickOrder));
        return retMap;
    }

    public Map<String, String> parseDmpCross(DmpFeatureDto data) {
        HashMap<String, String> retMap = new HashMap<String, String>(32);
        if (data == null || this.adNewTrade == null) {
            return retMap;
        }
        Map<String, String> appPackageDtoMap = DeviceFeatureParseV2.parseAppPackageDto(data.getAppPackageDto(), this.adNewTrade);
        retMap.putAll(appPackageDtoMap);
        Map<String, String> slotDtoMap = DeviceFeatureParseV2.parseTBDmpSlotDiDto(data.getSlotDto(), this.advertId, this.adNewTrade);
        retMap.putAll(slotDtoMap);
        return retMap;
    }

    public static <T> void putMap(Map<String, String> map, String key, T value) {
        if (value != null) {
            map.put(key, value.toString());
        }
    }
}

