package cn.com.duiba.nezha.alg.feature.util;

import java.util.*;

public class RegionConf {
    /**
     * 省份映射表：
     * 220000	吉林	东北
     * 210000	辽宁	东北
     * 230000	黑龙江 东北
     * 310000	上海	华东
     * 340000	安徽	华东
     * 370000	山东	华东
     * 320000	江苏	华东
     * 360000	江西	华东
     * 330000	浙江	华东
     * 350000	福建	华东
     * 410000	河南	华中
     * 420000	湖北	华中
     * 430000	湖南	华中
     * 150000	内蒙古 华北
     * 110000	北京	华北
     * 120000	天津	华北
     * 140000	山西	华北
     * 130000	河北	华北
     * 440000	广东	华南
     * 450000	广西	华南
     * 460000	海南	华南
     * 710000	台湾	港澳台
     * 820000	澳门	港澳台
     * 810000	香港	港澳台
     * 640000	宁夏	西北
     * 650000	新疆	西北
     * 620000	甘肃	西北
     * 610000	陕西	西北
     * 630000	青海	西北
     * 530000	云南	西南
     * 510000	四川	西南
     * 540000	西藏	西南
     * 520000	贵州	西南
     * 500000	重庆	西南
     */

    private static Map<String, String> provinceMap = new HashMap<>();
    public static final Set<String> HUABEI_REGION = new HashSet<>(Arrays.asList("11", "12", "13", "14", "15"));
    public static final Set<String> DONGBEI_REGION = new HashSet<>(Arrays.asList("21", "22", "23"));
    public static final Set<String> HUADONG_REGION = new HashSet<>(Arrays.asList("31", "32", "33", "34", "35", "36", "37"));
    public static final Set<String> HUAZHONG_REGION = new HashSet<>(Arrays.asList("41", "42", "43"));
    public static final Set<String> HUANAN_REGION = new HashSet<>(Arrays.asList("44", "45", "46"));
    public static final Set<String> XINAN_REGION = new HashSet<>(Arrays.asList("50", "51", "52", "53", "54"));
    public static final Set<String> XIBEI_REGION = new HashSet<>(Arrays.asList("61", "62", "63", "64", "65"));
    public static final Set<String> HMT_REGION = new HashSet<>(Arrays.asList("71", "81", "82"));

    public static final Set<String> HMT_TIER_CITY = new HashSet<>(Arrays.asList("71", "81", "82"));
    public static final Set<String> FIRST_TIER_CITY = new HashSet<>(Arrays.asList("11", "12", "31", "50", "2101", "3201", "3202", "3205", "3301", "3302", "3702", "4101", "4201", "4301", "4401", "4403", "4419", "5101", "6101"));
    public static final Set<String> SECOND_TIER_CITY = new HashSet<>(Arrays.asList("1301", "1306", "1401", "2102", "2201", "2301", "3203", "3204", "3206", "3303", "3304", "3306", "3307", "3310", "3401", "3501", "3502", "3505", "3601", "3701", "3706", "3707", "4406", "4413", "4420", "4501", "5201", "5301", "6201", "6501"));
    public static final Set<String> THIRD_TIER_CITY = new HashSet<>(Arrays.asList("1309", "1303", "1502", "2202", "3207", "3209", "3305", "3412", "3509", "3611", "3708", "3703", "4114", "4110", "4210", "4307", "4306", "4407", "4408", "4601", "5107", "6104", "1304", "1302", "1501", "2306", "3212", "3210", "3403", "3407", "3503", "3607", "3609", "3713", "4103", "4107", "4108", "4206", "4304", "4302", "4452", "4412", "4503", "4602", "5203", "6301", "1310", "1305", "2103", "3208", "3213", "3211", "3411", "3402", "3506", "3604", "3717", "3710", "4113", "4115", "4211", "4205", "4303", "4451", "4405", "4404", "4502", "5106", "5303", "6401"));


    /**
     * 获取省份 截取cityid的前两位
     *
     * @param cityId
     * @return
     */
    public static String getProvince(String cityId) {
        if (cityId == null || cityId.trim().equals("")) {
            return null;
        }
        return cityId.substring(0, Math.min(cityId.length(), 2));
    }

    /**
     * 获取省份 截取cityid的前两位
     *
     * @param cityId
     * @return
     */
    public static String getProvince(Long cityId) {
        if (cityId == null) {
            return null;
        } else {
            return getProvince(Long.toString(cityId));
        }
    }

    /**
     * 获取华东华北等
     *
     * @param provinceId
     * @return
     */
    public static String getRegion(String provinceId) {
        if (provinceId == null || provinceId.trim().equals("")) {
            return null;
        }
        if (HUABEI_REGION.contains(provinceId)) {
            return "1";
        } else if (DONGBEI_REGION.contains(provinceId)) {
            return "2";
        } else if (HUADONG_REGION.contains(provinceId)) {
            return "3";
        } else if (HUAZHONG_REGION.contains(provinceId)) {
            return "4";
        } else if (HUANAN_REGION.contains(provinceId)) {
            return "5";
        } else if (XINAN_REGION.contains(provinceId)) {
            return "6";
        } else if (XIBEI_REGION.contains(provinceId)) {
            return "7";
        } else if (HMT_REGION.contains(provinceId)) {
            return "8";
        } else {
            return "-1";
        }
    }


    /**
     * 获取一线二线等
     *
     * @param cityId
     * @return
     */
    public static String getCityTier(String cityId) {
        if (cityId == null || cityId.trim().equals("")) {
            return null;
        }
        if (HMT_TIER_CITY.contains(cityId.substring(0, Math.min(cityId.length(), 2)))) {
            return "9";
        } else if (FIRST_TIER_CITY.contains(cityId)) {
            return "1";
        } else if (SECOND_TIER_CITY.contains(cityId)) {
            return "2";
        } else if (THIRD_TIER_CITY.contains(cityId)) {
            return "3";
        } else {
            return "4";
        }
    }

    /**
     * 获取一线二线等
     *
     * @param cityId
     * @return
     */
    public static String getCityTier(Long cityId) {
        if (cityId == null) {
            return null;
        }
        return getCityTier(cityId.toString());
    }
}
