package cn.com.duiba.nezha.alg.feature.vo;

import lombok.Data;

import java.util.Map;

/**
 * @Description 广告位自身特征类
 * @Author lan
 * @Date 2020-07-22 9:29 上午
 */
@Data
public class SlotFeature {
    //	108001 slot_id 广告位ID
    private Long slotId;
    //	109001 广告位类型
    private Long slotType;

    // 二期特征
    // 素材标签曝光、点击
    Map<String,ComponentInfo> slotToMatTagMap;

    // 皮肤id曝光、点击
    Map<String,ComponentInfo> slotToActSkinMap;

    // 活动奖品标签曝光、点击
    Map<String,ComponentInfo> slotToRewardTagMap;


    // 用户-广告位-素材标签 曝光、点击
    Map<String,ComponentInfo> userToSlotMatTagMap;


    // 用户-广告位-皮肤id 曝光、点击
    Map<String,ComponentInfo> userToSlotActSkinMap;


    // 用户-广告位-活动奖品标签 曝光、点击
    Map<String,ComponentInfo> userToSlotRewardTagMap;

    // 一周内不同行业上转化率
    private String weekCvrTrade;

    // 一周内二类电商不同品类转化率
    private String weekCvrCate;

    // 广告二级类目id
    private String advertSecondTag;

}
