package cn.com.duiba.nezha.alg.feature.vo;

import lombok.Data;

import java.util.Map;

@Data
public class UserFeature {
    // 基本属性
    private String sex; // f451001 性别
    private String age; // f451002  年龄
    private String marry;  // f451003  婚恋
    private String consumeLevel;   // f451004  消费水平
    private String permanentProvince; // f451005  常住地（省份）
    private String permanentCity; // f451006  常住地（城市）
    // 有效app安装列表
    private String appList;
    // 短信签名列表
    private String sigList;  //f9801, 短信签名列表

    //用户当天曝光的素材序列，逗号分隔
    private String expDayMaterials;
    //用户当天点击的素材序列，逗号分隔
    private String clickDayMaterials;
    //用户过去7天曝光的素材序列，逗号分隔
    private String expWeekMaterials;
    // 用户过去7天点击的素材序列，逗号分隔
    private String clickWeekMaterials;

    // 用户行为
    // 活动访问
    private Integer activityRequest;   //f411001 历史活动访问次数
    private Integer weekActivityRequest;   //f411002  一周内活动访问次数
    private Integer intervalActivityRequest;   //f411004	 历史距离上一次活动访问时间间隔（天）
    private String periodActivityRequest;   //f411005 历史活动访问频繁时段（凌晨、早上、上午、中午、下午、晚上、深夜）

    // 活动参与
    private Integer activityJoin;  //f412001 历史活动参与次数
    private Integer weekActivityJoin;  //f412002 一周内活动参与次数
    private Integer intervalActivityJoin;  //f412004 历史距离上一次活动参与时间间隔（天）
    private String periodActivityJoin;  //f412005 历史活动参与频繁时段（凌晨、早上、上午、中午、下午、晚上、深夜）

    // 券点击
    private String clickTrade;  //f414001 历史不同行业上券点击数量
    private String weekClickTrade;  //f414002 一周内不同行业上券点击数量
    private Integer intervalClickTrade;    //f414004 历史距离上一次券点击时间间隔（天）
    private String periodClickTrade;    //f414005 历史券点击频繁时段（凌晨、早上、上午、中午、下午、晚上、深夜）
    private String lastClickTrade;  //f414007 上一次券点击行业

    // 转化
    private String effectTrade; //f415001 历史不同行业上转化数量
    private String weekEffectTrade; //f415002 一周内不同行业上转化数量
    private Integer intervalEffectTrade;   //f415004 历史距离上一次转化时间间隔（天）
    private String periodEffectTrade;   //f415005 历史转化频繁时段（凌晨、早上、上午、中午、下午、晚上、深夜）
    private String lastEffectTrade; //f415007 上一次转化行业

    // 二期特征加入

    // 用户活跃度
    private Integer expDayCnt;  // 用户当天曝光素材的次数
    private Integer clickDayCnt; // 用户当天点击素材的的次数
    private Integer expWeekCnt;  // 用户7天曝光素材的次数
    private Integer clickWeekCnt; // 用户7天点击素材的的次数
    private Integer expHisCnt;  // 用户历史曝光素材的次数
    private Integer clickHisCnt; // 用户历史点击素材的的次数

    // 用户-素材标签 曝光、点击
    Map<String,ComponentInfo> userToMatTagMap;

    // 用户-活动皮肤 曝光、点击
    Map<String,ComponentInfo> userToActSkinMap;

    // 用户-活动奖品标签 曝光、点击
    Map<String,ComponentInfo> userToRewardTagMap;

    // f461001  app类目偏好（applist类目数量分布）
    private String appCatePref;

    // f461003  文本类目偏好（签名类目数量分布）
    private String textCatePref;

    //f9701, 人工打标的用户基础标签
    private String userBasicTags;

    //F9803 每个类目下的短信签名数
    private String msgCategory;

    //每个类目下的app数 存储格式json
    private String appCategory;

    //top app安装列表1000
    private String topAppList3;

    // 用户当日第几个订单序列
    private Long dayOrderRank;

    // 用户全局第几个订单序列
    private Long orderRank;

    // 用户全局前后单时间差
//    private String currentGmtCreateTime;
//    private String lastGmtCreateTime;

    // 用户全局前一单计费情况
    private Long lastChargeNums;

    //f413007 上一次发券行业
    private String lastLaunchTrade;

    //f413008 上一次发券是否点击
    private Integer clickLaunchTrade;

    //f414008 上一次券点击是否转化
    private Integer effectClickTrade;

    //f434001 历史累计核单失败次数
    private Integer vouchFailed;

    //f434004 历史拒付费次数
    private Integer reject;

    private String uIIds;
    private String uILaunchPV;
    private String uIClickPv;
    private String uIEffectPv;

    // 用户最近点击的广告id，逗号分隔, 和待打分的广告id交叉作为新特征f830001
    private String clickAdIds;
    // 用户最近点击的广告二级行业id，逗号分隔, 和待打分的广告所属广告二级行业id交叉作为新特征f830004
    private String clickTrIds;
    // 831001	用户广告转化序列
    private String convertAdverts;
    // 831004	用户行业转化序列
    private String convertTrades;
    // 832001	用户广告后端转化序列
    private String bConvertAdverts;
    // 832004	用户行业后端转化序列
    private String bConvertTrades;

}
