package cn.com.duiba.nezha.alg.feature.vo.v2.sub;

import cn.com.duiba.nezha.alg.common.util.AssertUtil;
import cn.com.duiba.nezha.alg.common.util.DataUtil;
import cn.com.duiba.nezha.alg.feature.util.DataConverter;
import lombok.Data;
import org.slf4j.LoggerFactory;

import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

@Data
public class UserBehaviorSubFeature implements Serializable {
    private static final org.slf4j.Logger logger = LoggerFactory.getLogger(UserBehaviorSubFeature.class);
    private static final long serialVersionUID = -2203632123858487448L;

    public static Double[] userCtrBucket = {0.05, 0.1, 0.15, 0.2, 0.3, 0.4, 0.5, 0.6, 0.7, 0.8, 0.9, 1.0};

    public static Double[] userCvrBucket = {0.01, 0.05, 0.1, 0.15, 0.2, 0.3, 0.4, 0.5, 0.6, 0.7, 0.8, 0.9, 1.0};


    // 用户属性 新老用户
   // private Integer userActiveDays;  // f410001 用户生命周期（天）  by 数据



    /**
     * 用户实时行为特征
     * 来自 RTA用户画像解析
     */

    private Long userExpPv; // 用户当天入口曝光次数
    private Long userActReqPv; // 用户当天活动访问次数
    private Long userAdvLaunchPv; // 用户当天发券次数
    private Long userAdvClkPv; // 用户当天券计费点击次数
    private Long userCvtPv;   // 用户当天目标转化次数

    //todo 新增，用户当日序列特征(截断到20个，按行为时间排序，正序）
    private List<Long> userActReqList;          // 用户当日活动id访问列表
    private List<String> userAdvLaunchTradeList; // 用户当日券行业id曝光列表
    private List<String> userAdvClkTradeList;    // 用户当日券行业id计费点击列表

    /**
     * 用户历史行为特征
     * 来自 RTA用户画像解析
     */

    // 用户历史统计特征
    private Long userReqPv1d; // 用户历史1天请求次数
    private Long userExpPv1d; // 用户历史1天入口曝光次数
    private Long userActReqPv1d; // 用户历史1天活动访问次数
    private Long userAdvLaunchPv1d; // 用户历史1天发券次数
    private Long userAdvClkPv1d; // 用户历史1天券计费点击次数
    private Long userCvtPv1d;   // 用户历史1天目标转化次数

    private Long userReqPv14d; // 用户历史14天请求次数
    private Long userExpPv14d; // 用户历史14天入口曝光次数
    private Long userActReqPv14d; // 用户历史14天活动访问次数
    private Long userAdvLaunchPv14d; // 用户历史14天发券次数
    private Long userAdvClkPv14d; // 用户历史14天券计费点击次数
    private Long userCvtPv14d;  // 用户历史14天目标转化次数

    private Long userReqPv180d; // 用户历史半年天请求次数
    private Long userExpPv180d; // 用户历史半年入口曝光次数
    private Long userActReqPv180d; // 用户历史半年活动访问次数
    private Long userAdvLaunchPv180d; // 用户历史半年发券次数
    private Long userAdvClkPv180d; // 用户历史半年券计费点击次数
    private Long userCvtPv180d;  // 用户历史半年目标转化次数


    // 用户历史序列特征(截断到20个，按行为时间排序，正序）
    //todo 字段名字修改成驼峰写法，需要注意
    private List<Long> userActReqList14d;          // 用户历史，活动id访问列表
    private List<String> userAdvLaunchTradeList14d; // 用户历史，券行业id曝光列表
    private List<String> userAdvClkTradeList14d;    // 用户历史，券行业id计费点击列表




//
//
//    /**
//     * 历史，转化广告主
//     */
//    private Set<Integer> historyEffectAccount;  //用户历史30天，广告广告主  表单转化
//
//    /**
//     * 历史，目标转化广告主
//     */
//    private Set<Integer> historyTargetEffectAccount;  //用户历史30天，广告广告主  目标转化
//
//
//    /**
//     * 行业 发券
//     */
//    //private Map<String, Integer> launchTrade; //f413001 历史不同行业上发券数量
//    private Map<String, Integer> historyLaunchTrade;// 用户历史30天，广告行业 发券次数
//    private Map<String, Integer> weekLaunchTrade; //用户历史7天，不同行业发券数量
//    private Map<String, Integer> dayLaunchTrade;  //当日，不同行业发券数量
//
//    /**
//     * 行业 点击
//     */
//    private Map<String, Integer> historyClickTrade; // 用户历史30天，广告行业 点击次数
//    private Map<String, Integer> weekClickTrade;  //用户历史7天，不同行业上券点击数量
//    private Map<String, Integer> dayClickTrade;   //当日，不同行业上券点击数量
//
//    /**
//     * 行业 表单转化
//     */
//    private Map<String, Integer> historyEffectTrade;// 用户历史30天，广告行业   表单转化次数
//    private Map<String, Integer> weekEffectTrade; //用户历史7天，不同行业上  表单转化数量
//    private Map<String, Integer> dayEffectTrade;  //当日，不同行业上    表单转化数量
//
//    /**
//     * 行业 目标转化
//     */
//    private Map<String, Integer> historyTargetEffectTrade;// 用户历史30天，广告行业   目标转化
//    private Map<String, Integer> weekTargetEffectTrade; //用户历史7天，不同行业上 目标转化
//    private Map<String, Integer> dayTargetEffectTrade;  //当日，不同行业上   目标转化
//

}
