package cn.com.duiba.nezha.alg.model;


import cn.com.duiba.nezha.alg.model.tf.TFServingClient;

import java.util.List;
import java.util.Map;

/**
 * Created by pc on 2017/7/11.
 */
public interface IModel {




    List<Float> getParam(Map<String, String> featureMap) throws Exception;


    /**
     * 本地模型，单个样本预估方法
     *
     * @param featureMap
     * @return
     * @throws Exception
     */
    Double predict(Map<String, String> featureMap) throws Exception;

    /**
     * 本地模型，批量预估方法
     *
     * @param featureMap
     * @return
     * @throws Exception
     */
    <T> Map<T, Double> predicts(Map<T, Map<String, String>> featureMap) throws Exception;

    /**
     * 本地模型+ 远程TFServing模型，批量预估方法
     *
     * @param featureMap
     * @param tfServingClient
     * @return
     * @throws Exception
     */
    <T> Map<T, Double> predictWithTF(Map<T, Map<String, String>> featureMap, TFServingClient tfServingClient) throws Exception;


}
