/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.alg.model;

import cn.com.duiba.nezha.alg.common.util.AssertUtil;
import cn.com.duiba.nezha.alg.feature.coder.FeatureCoder;
import cn.com.duiba.nezha.alg.feature.type.FeatureBaseType;
import cn.com.duiba.nezha.alg.feature.vo.CodeResult;
import cn.com.duiba.nezha.alg.model.IModel;
import cn.com.duiba.nezha.alg.model.tf.TFServingClient;
import cn.com.duiba.nezha.alg.model.util.CollectionUtil;
import cn.com.duiba.nezha.alg.model.vo.ParamsDo;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CODER
implements Serializable,
IModel {
    private static final long serialVersionUID = -316102112618444130L;
    private static final Logger logger = LoggerFactory.getLogger(CODER.class);
    private String modelId;
    private String updateTime;
    private ParamsDo paramsDo;
    private Map<String, Map<Long, Long>> coderMap;
    private int FBT_MAX_SIZE = 64;
    private int PB_MAX_SIZE = 128;
    private List<FeatureBaseType> featureBaseType = new ArrayList<FeatureBaseType>(this.FBT_MAX_SIZE);

    public void setFeatureBaseType(List<FeatureBaseType> featureBaseType) {
        this.featureBaseType = featureBaseType;
    }

    public List<FeatureBaseType> getFeatureBaseType() {
        return this.featureBaseType;
    }

    public void setModelId(String modelId) {
        this.modelId = modelId;
    }

    public String getModelId() {
        return this.modelId;
    }

    public void setUpdateTime(String updateTime) {
        this.updateTime = updateTime;
    }

    public String getUpdateTime() {
        return this.updateTime;
    }

    public void setParamsDo(ParamsDo paramsDo) {
        this.paramsDo = paramsDo;
    }

    public ParamsDo getParamsDo() {
        return this.paramsDo;
    }

    public Map<String, Map<Long, Long>> getCoderMap() {
        return this.coderMap;
    }

    public void setCoderMap(Map<String, Map<Long, Long>> coderMap) {
        this.coderMap = coderMap;
    }

    @Override
    public Double predict(Map<String, String> featureMap) throws Exception {
        Double ret = null;
        return ret;
    }

    public String getCode(Map<String, String> featureMap) throws Exception {
        String ret = null;
        CodeResult codeResult = FeatureCoder.codeOfEachField(this.getFeatureBaseType(), featureMap);
        Map fieldFeatureMap = codeResult.getFieldFeatureMap();
        ArrayList<String> fieldStringList = new ArrayList<String>();
        for (FeatureBaseType featureBaseType : this.featureBaseType) {
            String field = featureBaseType.getName();
            Map sparceCode = (Map)fieldFeatureMap.get(field);
            Map<Long, Long> denseCodeMap = this.coderMap.get(field);
            ArrayList<Long> fCode = new ArrayList<Long>();
            ArrayList sparceCodeKeyList = new ArrayList(sparceCode.keySet());
            Long filedDefaultValue = denseCodeMap.getOrDefault(0L, 0L);
            for (int i = 0; i < sparceCodeKeyList.size(); ++i) {
                Long codeDense = denseCodeMap.getOrDefault(sparceCodeKeyList.get(i), filedDefaultValue);
                fCode.add(codeDense);
            }
            String fCodeString = CollectionUtil.toString(fCode, ",");
            String fieldString = field + ":" + fCodeString;
            fieldStringList.add(fieldString);
        }
        ret = CollectionUtil.toString(fieldStringList, ";");
        return ret;
    }

    @Override
    public List<Float> getParam(Map<String, String> featureMap) throws Exception {
        List<Float> ret = null;
        return ret;
    }

    @Override
    public <T> Map<T, Double> predicts(Map<T, Map<String, String>> featureMap) throws Exception {
        HashMap<T, Double> ret = new HashMap<T, Double>(this.PB_MAX_SIZE);
        if (AssertUtil.isNotEmpty(featureMap)) {
            for (Map.Entry<T, Map<String, String>> entry : featureMap.entrySet()) {
                ret.put(entry.getKey(), this.predict(entry.getValue()));
            }
        }
        return ret;
    }

    public <T> Map<T, List<Float>> getParams(Map<T, Map<String, String>> featureMap) throws Exception {
        HashMap ret = new HashMap(this.PB_MAX_SIZE);
        return ret;
    }

    public <T> Map<T, String> getCodes(Map<T, Map<String, String>> featureMap) throws Exception {
        HashMap<T, String> ret = new HashMap<T, String>(this.PB_MAX_SIZE);
        if (AssertUtil.isNotEmpty(featureMap)) {
            for (Map.Entry<T, Map<String, String>> entry : featureMap.entrySet()) {
                ret.put(entry.getKey(), this.getCode(entry.getValue()));
            }
        }
        return ret;
    }

    @Override
    public <T> Map<T, Double> predictWithTF(Map<T, Map<String, String>> featureMap, TFServingClient tfServingClient) throws Exception {
        Map<T, Double> ret = null;
        if (tfServingClient == null || featureMap != null && featureMap.size() > 70) {
            ret = this.predicts(featureMap);
        } else {
            try {
                ret = tfServingClient.predictString(this.getCodes(featureMap));
                if (tfServingClient.modelName.contains("ctr") && ret != null) {
                    for (Map.Entry<T, Double> entry : ret.entrySet()) {
                        if (entry.getValue() != 0.0) continue;
                        String logInfo = tfServingClient.modelName + " warn preCtr=0";
                        logger.warn(logInfo);
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                String logInfo = tfServingClient.modelName + " predictWithTF warn ";
                logger.warn(logInfo + e);
                ret = null;
            }
        }
        return ret;
    }
}

