/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.alg.model;

import cn.com.duiba.nezha.alg.common.util.AssertUtil;
import cn.com.duiba.nezha.alg.model.IModel;
import cn.com.duiba.nezha.alg.model.enums.MutModelType;
import cn.com.duiba.nezha.alg.model.enums.PredictResultType;
import cn.com.duiba.nezha.alg.model.tf.TFServingClient;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ESMM
implements Serializable {
    private static final long serialVersionUID = -316102112618444131L;
    private static final Logger logger = LoggerFactory.getLogger(ESMM.class);
    private int PB_MAX_SIZE = 128;
    private IModel ctrModel;
    private IModel cvrModel;
    private IModel ctrFusingModel;
    private IModel cvrFusingModel;
    private IModel bCvrModel;
    private TFServingClient ctrTFServingClient;
    private TFServingClient cvrTFServingClient;
    private MutModelType mutModelType;

    public IModel getCtrModel() {
        return this.ctrModel;
    }

    public void setCtrModel(IModel ctrModel) {
        this.ctrModel = ctrModel;
    }

    public IModel getCvrModel() {
        return this.cvrModel;
    }

    public void setCvrModel(IModel cvrModel) {
        this.cvrModel = cvrModel;
    }

    public IModel getBCvrModel() {
        return this.bCvrModel;
    }

    public void setBCvrModel(IModel bCvrModel) {
        this.bCvrModel = bCvrModel;
    }

    public TFServingClient getCtrTFServingClient() {
        return this.ctrTFServingClient;
    }

    public void setCtrTFServingClient(TFServingClient ctrTFServingClient) {
        this.ctrTFServingClient = ctrTFServingClient;
    }

    public TFServingClient getCvrTFServingClient() {
        return this.cvrTFServingClient;
    }

    public void setCvrTFServingClient(TFServingClient cvrTFServingClient) {
        this.cvrTFServingClient = cvrTFServingClient;
    }

    public MutModelType getMutModelType() {
        return this.mutModelType;
    }

    public void setMutModelType(MutModelType mutModelType) {
        this.mutModelType = mutModelType;
    }

    public IModel getCtrFusingModel() {
        return this.ctrFusingModel;
    }

    public void setCtrFusingModel(IModel ctrFusingModel) {
        this.ctrFusingModel = ctrFusingModel;
    }

    public IModel getCvrFusingModel() {
        return this.cvrFusingModel;
    }

    public void setCvrFusingModel(IModel cvrFusingModel) {
        this.cvrFusingModel = cvrFusingModel;
    }

    public ESMM(IModel ctrModel, IModel cvrModel, IModel ctrFusingModel, IModel cvrFusingModel, IModel bCvrModel, TFServingClient ctrTFServingClient, TFServingClient cvrTFServingClient, MutModelType mutModelType) {
        this.ctrModel = ctrModel;
        this.cvrModel = cvrModel;
        this.ctrFusingModel = ctrFusingModel;
        this.cvrFusingModel = cvrFusingModel;
        this.bCvrModel = bCvrModel;
        this.ctrTFServingClient = ctrTFServingClient;
        this.cvrTFServingClient = cvrTFServingClient;
        this.mutModelType = mutModelType;
    }

    public ESMM(IModel ctrModel, IModel cvrModel, IModel bCvrModel, TFServingClient ctrTFServingClient, TFServingClient cvrTFServingClient, MutModelType mutModelType) {
        this.ctrModel = ctrModel;
        this.cvrModel = cvrModel;
        this.bCvrModel = bCvrModel;
        this.ctrTFServingClient = ctrTFServingClient;
        this.cvrTFServingClient = cvrTFServingClient;
        this.mutModelType = mutModelType;
    }

    public <T> Map<PredictResultType, Map<T, Double>> predictCTRsAndCVRsWithTF(Map<T, Map<String, String>> featureMap) throws Exception {
        Map<PredictResultType, Map<T, Double>> ret = null;
        ret = MutModelType.CTR == this.mutModelType ? this.predictCTRs(featureMap) : this.predictCTRsAndCVRsWithTFDEEP(featureMap);
        return ret;
    }

    public <T> Map<PredictResultType, Map<T, Double>> predictCTRs(Map<T, Map<String, String>> featureMap) throws Exception {
        HashMap<PredictResultType, Map<T, Double>> ret = new HashMap<PredictResultType, Map<T, Double>>(this.PB_MAX_SIZE);
        Map<T, Double> ctrMap = this.ctrModel.predictWithTF(featureMap, this.ctrTFServingClient);
        if (AssertUtil.isAllNotEmpty((Object[])new Object[]{ctrMap})) {
            ret.put(PredictResultType.CTR, ctrMap);
        } else {
            ret = null;
        }
        return ret;
    }

    public <T> Map<PredictResultType, Map<T, Double>> predictCVRs(Map<T, Map<String, String>> featureMap) throws Exception {
        HashMap<PredictResultType, Map<T, Double>> ret = new HashMap<PredictResultType, Map<T, Double>>(this.PB_MAX_SIZE);
        Map<T, Double> ctrMap = this.cvrModel.predictWithTF(featureMap, this.cvrTFServingClient);
        if (AssertUtil.isAllNotEmpty((Object[])new Object[]{ctrMap})) {
            ret.put(PredictResultType.CVR, ctrMap);
        } else {
            ret = null;
        }
        return ret;
    }

    public <T> Map<PredictResultType, Map<T, Double>> predictCTRsAndCVRsWithTFDEEP(Map<T, Map<String, String>> featureMap) throws Exception {
        Map<PredictResultType, Map<T, Double>> ret = null;
        ret = MutModelType.DEEP_ESMM == this.mutModelType ? this.ctrTFServingClient.predictMut(this.getParams(featureMap)) : this.predictCTRsAndCVRs(featureMap);
        if (ret == null) {
            ret = this.predictFusingCTRsAndCVRs(featureMap);
            if (ret != null) {
                for (Map.Entry<PredictResultType, Map<T, Double>> entry : ret.entrySet()) {
                    PredictResultType key = entry.getKey();
                    if (key != PredictResultType.CTR) continue;
                    for (Map.Entry<T, Double> subEntry : entry.getValue().entrySet()) {
                        Double predictCtr = subEntry.getValue();
                        if (predictCtr != 0.0) continue;
                        String logInfo = this.ctrTFServingClient.modelName + " predictFusing warn preCtr=0";
                        logger.warn(logInfo);
                    }
                }
            } else {
                String logInfo = this.ctrTFServingClient.modelName + " predictFusing res=null";
                logger.warn(logInfo);
            }
        }
        return ret;
    }

    public <T> Map<T, Double> predictBCVRs(Map<T, Map<String, String>> featureMap) throws Exception {
        return this.bCvrModel.predicts(featureMap);
    }

    private <T> Map<PredictResultType, Map<T, Double>> predictCTRsAndCVRs(Map<T, Map<String, String>> featureMap) throws Exception {
        HashMap<PredictResultType, Map<T, Double>> ret = new HashMap<PredictResultType, Map<T, Double>>(this.PB_MAX_SIZE);
        Map<T, Double> ctrMap = this.ctrModel.predictWithTF(featureMap, this.ctrTFServingClient);
        Map<T, Double> cvrMap = this.cvrModel.predictWithTF(featureMap, this.cvrTFServingClient);
        if (AssertUtil.isAllNotEmpty((Object[])new Object[]{ctrMap, cvrMap})) {
            ret.put(PredictResultType.CTR, ctrMap);
            ret.put(PredictResultType.CVR, cvrMap);
        } else {
            ret = null;
        }
        return ret;
    }

    private <T> Map<PredictResultType, Map<T, Double>> predictFusingCTRsAndCVRs(Map<T, Map<String, String>> featureMap) throws Exception {
        HashMap<PredictResultType, Map<T, Double>> ret = new HashMap<PredictResultType, Map<T, Double>>(this.PB_MAX_SIZE);
        ret.put(PredictResultType.CTR, this.ctrFusingModel.predictWithTF(featureMap, null));
        ret.put(PredictResultType.CVR, this.cvrFusingModel.predictWithTF(featureMap, null));
        return ret;
    }

    private <T> Map<T, List<Float>> getParams(Map<T, Map<String, String>> featureMap) throws Exception {
        HashMap<T, List<Float>> ret = new HashMap<T, List<Float>>(this.PB_MAX_SIZE);
        if (AssertUtil.isNotEmpty(featureMap)) {
            for (Map.Entry<T, Map<String, String>> entry : featureMap.entrySet()) {
                List<Float> ctrP = this.ctrModel.getParam(entry.getValue());
                List<Float> cvrP = this.cvrModel.getParam(entry.getValue());
                ret.put(entry.getKey(), this.paramsSplicing(ctrP, cvrP));
            }
        }
        return ret;
    }

    private List<Float> paramsSplicing(List<Float> ctrP, List<Float> cvrP) {
        ctrP.addAll(cvrP);
        return ctrP;
    }
}

