/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.alg.model;

import cn.com.duiba.nezha.alg.common.util.AssertUtil;
import cn.com.duiba.nezha.alg.common.util.DataUtil;
import cn.com.duiba.nezha.alg.common.util.MathUtil;
import cn.com.duiba.nezha.alg.feature.coder.FeatureCoder;
import cn.com.duiba.nezha.alg.feature.coder.FeatureNewCoder;
import cn.com.duiba.nezha.alg.feature.type.FeatureBaseType;
import cn.com.duiba.nezha.alg.feature.vo.CodeResult;
import cn.com.duiba.nezha.alg.feature.vo.Feature;
import cn.com.duiba.nezha.alg.feature.vo.FeatureMapDo;
import cn.com.duiba.nezha.alg.model.IModel;
import cn.com.duiba.nezha.alg.model.tf.LocalTFModel;
import cn.com.duiba.nezha.alg.model.tf.TFServingClient;
import cn.com.duiba.nezha.alg.model.vo.ParamsDo;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class FFM2
implements Serializable,
IModel {
    private static final long serialVersionUID = -316102112618444130L;
    private String modelId;
    private String updateTime;
    private ParamsDo paramsDoffm;
    private int FBT_MAX_SIZE = 64;
    private int PB_MAX_SIZE = 128;
    private List<FeatureBaseType> featureBaseType = new ArrayList<FeatureBaseType>();

    public void setFeatureBaseType(List<FeatureBaseType> featureBaseType) {
        this.featureBaseType = featureBaseType;
    }

    public List<FeatureBaseType> getFeatureBaseType() {
        return this.featureBaseType;
    }

    public void setModelId(String modelId) {
        this.modelId = modelId;
    }

    public String getModelId() {
        return this.modelId;
    }

    public void setUpdateTime(String updateTime) {
        this.updateTime = updateTime;
    }

    public String getUpdateTime() {
        return this.updateTime;
    }

    public void setParamsDoffm(ParamsDo paramsDoffm) {
        this.paramsDoffm = paramsDoffm;
    }

    public ParamsDo getParamsDoffm() {
        return this.paramsDoffm;
    }

    @Override
    public Double predict(Map<String, String> featureMap) throws Exception {
        Double ret = null;
        CodeResult codeResult = FeatureCoder.code(this.getFeatureBaseType(), featureMap);
        if (codeResult != null) {
            ret = this.predict(codeResult.getFeature());
        }
        return ret;
    }

    public Double predict(FeatureMapDo featureMap) throws Exception {
        Double ret = null;
        CodeResult codeResult = FeatureCoder.code(this.getFeatureBaseType(), (FeatureMapDo)featureMap);
        if (codeResult != null) {
            ret = this.predict(codeResult.getFeature());
        }
        return ret;
    }

    public Double predict(CodeResult codeResult) throws Exception {
        Double ret = null;
        if (codeResult != null) {
            ret = this.predict(codeResult.getFeature());
        }
        return ret;
    }

    public Double predict2(Map<String, String> featureMap) throws Exception {
        Double ret = null;
        CodeResult codeResult = FeatureCoder.code(this.getFeatureBaseType(), featureMap);
        if (codeResult != null) {
            ret = this.predict2(codeResult.getFeature());
        }
        return ret;
    }

    public double[] getParam2(Map<String, String> featureMap) throws Exception {
        double[] ret = null;
        CodeResult codeResult = FeatureCoder.code(this.getFeatureBaseType(), featureMap);
        if (codeResult != null) {
            ret = this.getModelParams(codeResult.getFeatureSet());
        }
        return ret;
    }

    public double[] getParam2(FeatureMapDo featureMap) throws Exception {
        double[] ret = null;
        CodeResult codeResult = FeatureCoder.code(this.getFeatureBaseType(), (FeatureMapDo)featureMap);
        if (codeResult != null) {
            ret = this.getModelParams(codeResult.getFeatureSet());
        }
        return ret;
    }

    public double[] getParam2(CodeResult codeResult) throws Exception {
        double[] ret = null;
        if (codeResult != null) {
            ret = this.getModelParams(codeResult.getFeatureSet());
        }
        return ret;
    }

    @Override
    public List<Float> getParam(Map<String, String> featureMap) throws Exception {
        ArrayList<Float> ret = null;
        double[] value = this.getParam2(featureMap);
        if (value != null) {
            ret = new ArrayList<Float>();
            for (int i = 0; i < value.length; ++i) {
                ret.add(Float.valueOf((float)value[i]));
            }
        }
        return ret;
    }

    @Override
    public List<Float> getParam(FeatureMapDo featureMap) throws Exception {
        ArrayList<Float> ret = null;
        double[] value = this.getParam2(featureMap);
        if (value != null) {
            ret = new ArrayList<Float>();
            for (int i = 0; i < value.length; ++i) {
                ret.add(Float.valueOf((float)value[i]));
            }
        }
        return ret;
    }

    public List<Float> getParam(CodeResult codeResult) throws Exception {
        ArrayList<Float> ret = null;
        double[] value = this.getParam2(codeResult);
        if (value != null) {
            ret = new ArrayList<Float>();
            for (int i = 0; i < value.length; ++i) {
                ret.add(Float.valueOf((float)value[i]));
            }
        }
        return ret;
    }

    @Override
    public <T> Map<T, Double> predicts(Map<T, Map<String, String>> featureMap) throws Exception {
        HashMap<T, Double> ret = new HashMap<T, Double>();
        if (AssertUtil.isNotEmpty(featureMap)) {
            for (Map.Entry<T, Map<String, String>> entry : featureMap.entrySet()) {
                ret.put(entry.getKey(), this.predict(entry.getValue()));
            }
        }
        return ret;
    }

    @Override
    public <T> Map<T, Double> predictsNew(Map<T, FeatureMapDo> featureMap) throws Exception {
        HashMap<T, Double> ret = new HashMap<T, Double>();
        if (AssertUtil.isNotEmpty(featureMap)) {
            Map codeResultMap = FeatureNewCoder.code(this.getFeatureBaseType(), featureMap);
            for (Map.Entry<T, FeatureMapDo> entry : featureMap.entrySet()) {
                CodeResult cr = (CodeResult)codeResultMap.get(entry.getKey());
                ret.put(entry.getKey(), this.predict(cr));
            }
        }
        return ret;
    }

    public <T> Map<T, Double> predicts2(Map<T, Map<String, String>> featureMap) throws Exception {
        HashMap<T, Double> ret = new HashMap<T, Double>();
        if (AssertUtil.isNotEmpty(featureMap)) {
            for (Map.Entry<T, Map<String, String>> entry : featureMap.entrySet()) {
                ret.put(entry.getKey(), this.predict2(entry.getValue()));
            }
        }
        return ret;
    }

    public <T> Map<T, List<Float>> getParams(Map<T, Map<String, String>> featureMap) throws Exception {
        HashMap<T, List<Float>> ret = new HashMap<T, List<Float>>(this.PB_MAX_SIZE);
        if (AssertUtil.isNotEmpty(featureMap)) {
            for (Map.Entry<T, Map<String, String>> entry : featureMap.entrySet()) {
                ret.put(entry.getKey(), this.getParam(entry.getValue()));
            }
        }
        return ret;
    }

    public <T> Map<T, List<Float>> getParamsNew(Map<T, FeatureMapDo> featureMap) throws Exception {
        HashMap<T, List<Float>> ret = new HashMap<T, List<Float>>(this.PB_MAX_SIZE);
        if (AssertUtil.isNotEmpty(featureMap)) {
            Map codeResultMap = FeatureNewCoder.code(this.getFeatureBaseType(), featureMap);
            for (Map.Entry<T, FeatureMapDo> entry : featureMap.entrySet()) {
                CodeResult cr = (CodeResult)codeResultMap.get(entry.getKey());
                ret.put(entry.getKey(), this.getParam(cr));
            }
        }
        return ret;
    }

    @Override
    public <T> Map<T, Double> predictWithTF(Map<T, Map<String, String>> featureMap, TFServingClient tfServingClient) throws Exception {
        Map<T, Double> ret = null;
        ret = tfServingClient == null ? this.predicts(featureMap) : tfServingClient.predict(this.getParams(featureMap));
        return ret;
    }

    @Override
    public <T> Map<T, Double> predictWithTFNew(Map<T, FeatureMapDo> featureMap, TFServingClient tfServingClient) throws Exception {
        Map<T, Double> ret = null;
        ret = tfServingClient == null ? this.predictsNew(featureMap) : tfServingClient.predict(this.getParamsNew(featureMap));
        return ret;
    }

    @Override
    public <T> Map<T, Double> predictWithLocalTF(Map<T, Map<String, String>> featureMap, LocalTFModel localTFModel) throws Exception {
        Map<T, Double> ret = null;
        return ret;
    }

    @Override
    public <T> Map<T, Double> predictWithLocalTFNew(Map<T, FeatureMapDo> featureMap, LocalTFModel localTFModel) throws Exception {
        Map<T, Double> ret = null;
        return ret;
    }

    public Double predict(Feature feature) throws Exception {
        try {
            double ret = 0.0;
            double retw0 = 0.0;
            double retw = 0.0;
            double retv = 0.0;
            long factorNum = this.paramsDoffm.getFactorNum().intValue();
            if (feature != null) {
                int i;
                HashMap tmpMap = new HashMap(1);
                List indices = feature.indices;
                double[] x = feature.values;
                List fields = feature.fields;
                retw0 += this.paramsDoffm.getWeight0().doubleValue();
                for (i = 0; i < feature.indices.size(); ++i) {
                    Integer fId = (Integer)feature.indices.get(i);
                    Double value = feature.values[i];
                    retw += this.paramsDoffm.getWeight().getOrDefault(fId, 0.0) * value;
                }
                for (i = 0; i < feature.indices.size(); ++i) {
                    Long vi = 0L + (long)((Integer)indices.get(i)).intValue();
                    Double xi = x[i];
                    String fieldI = (String)fields.get(i);
                    Map mapI = this.paramsDoffm.getVectorV3().getOrDefault(fieldI, tmpMap);
                    for (int j = i + 1; j < feature.indices.size(); ++j) {
                        Long vj = 0L + (long)((Integer)indices.get(j)).intValue();
                        Double xj = x[j];
                        String fieldJ = (String)fields.get(j);
                        Map mapJ = this.paramsDoffm.getVectorV3().getOrDefault(fieldJ, tmpMap);
                        Double tmpVecDotSum = 0.0;
                        int k = 0;
                        while ((long)k < factorNum) {
                            Map factorVMapI = mapJ.getOrDefault(0L + (long)k, tmpMap);
                            Map factorVMapJ = mapI.getOrDefault(0L + (long)k, tmpMap);
                            Double vifjK = (Double)factorVMapI.get(vi);
                            Double vjfiK = (Double)factorVMapJ.get(vj);
                            if (vifjK != null && vjfiK != null) {
                                tmpVecDotSum = tmpVecDotSum + vifjK * vjfiK;
                            }
                            ++k;
                        }
                        retv += tmpVecDotSum * xi * xj;
                    }
                }
                ret = retw0 + retw + retv;
            }
            double pValue = MathUtil.sigmoid((double)ret);
            double pCValue = this.correctValue(pValue, this.paramsDoffm.getCorrect());
            return DataUtil.formatdouble((double)pCValue, (int)5);
        }
        catch (Exception e) {
            System.out.println("FFM.predict error");
            throw e;
        }
    }

    public Double predict2(Feature feature) throws Exception {
        try {
            double ret = 0.0;
            double retw0 = 0.0;
            double retw = 0.0;
            double retv = 0.0;
            long factorNum = this.paramsDoffm.getFactorNum().intValue();
            if (feature != null) {
                int i;
                HashMap tmpMap = new HashMap();
                List indices = feature.indices;
                double[] x = feature.values;
                List fields = feature.fields;
                retw0 += this.paramsDoffm.getWeight0().doubleValue();
                for (i = 0; i < feature.indices.size(); ++i) {
                    Integer fId = (Integer)feature.indices.get(i);
                    double value = feature.values[i];
                    retw += this.paramsDoffm.getWeight().getOrDefault(fId, 0.0) * value;
                }
                for (i = 0; i < feature.indices.size(); ++i) {
                    Integer vi = (Integer)indices.get(i);
                    double xi = x[i];
                    String fieldI = (String)fields.get(i);
                    Map<String, Map<Integer, Map<Integer, Double>>> vectorV3 = this.paramsDoffm.getVectorV3();
                    Map mapI = vectorV3.getOrDefault(fieldI, tmpMap);
                    for (int j = i + 1; j < feature.indices.size(); ++j) {
                        Integer vj = (Integer)indices.get(j);
                        double xj = x[j];
                        String fieldJ = (String)fields.get(j);
                        Map mapJ = vectorV3.getOrDefault(fieldJ, tmpMap);
                        double tmpVecDotSum = 0.0;
                        for (long k = 0L; k < factorNum; ++k) {
                            Map factorVMapI = mapJ.getOrDefault(k, tmpMap);
                            Map factorVMapJ = mapI.getOrDefault(k, tmpMap);
                            Double vifjK = (Double)factorVMapI.get(vi);
                            Double vjfiK = (Double)factorVMapJ.get(vj);
                            if (vifjK == null || vjfiK == null) continue;
                            tmpVecDotSum += vifjK * vjfiK;
                        }
                        retv += tmpVecDotSum * xi * xj;
                    }
                }
                ret = retw0 + retw + retv;
            }
            double pValue = MathUtil.sigmoid((double)ret);
            double pCValue = this.correctValue(pValue, this.paramsDoffm.getCorrect());
            return DataUtil.formatdouble((double)pCValue, (int)5);
        }
        catch (Exception e) {
            System.out.println("FFM.predict error");
            throw e;
        }
    }

    public double correctValue(double pre_, Double correct) {
        double ret = pre_;
        if (correct != null) {
            ret = correct / (1.0 / pre_ - 1.0 + correct);
        }
        return ret;
    }

    public double[] getModelParams(List<Set<Integer>> codeSetList) throws Exception {
        try {
            boolean status = true;
            double[] ret = null;
            return ret;
        }
        catch (Exception e) {
            System.out.println("FFM.predict error");
            throw new Exception(e);
        }
    }

    public static void main(String[] args) {
        int factorNum = 3;
        int fSize = 10;
        for (int j = 0; j < factorNum; ++j) {
            for (int i = 0; i < fSize; ++i) {
                System.out.println(i * factorNum + j);
            }
        }
    }
}

