/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.alg.model;

import cn.com.duiba.nezha.alg.common.util.AssertUtil;
import cn.com.duiba.nezha.alg.model.IModel;
import cn.com.duiba.nezha.alg.model.tf.TFServingClient;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ESMM
implements Serializable {
    private static final long serialVersionUID = -316102112618444131L;
    private IModel ctrModel;
    private IModel cvrModel;

    public <T> Map<T, Double> predictCTRs(Map<T, Map<String, String>> featureMap) throws Exception {
        return this.ctrModel.predicts(featureMap);
    }

    public <T> Map<T, Double> predictCVRs(Map<T, Map<String, String>> featureMap) throws Exception {
        return this.cvrModel.predicts(featureMap);
    }

    public <T> Map<String, Map<T, Double>> predictCTRAndCVRs(Map<T, Map<String, String>> featureMap) throws Exception {
        HashMap<String, Map<T, Double>> ret = new HashMap<String, Map<T, Double>>();
        ret.put(TFServingClient.CTR_ID, this.ctrModel.predicts(featureMap));
        ret.put(TFServingClient.CVR_ID, this.cvrModel.predicts(featureMap));
        return ret;
    }

    public <T> Map<T, Double> predicCTRWithTF(Map<T, Map<String, String>> featureMap, TFServingClient tfServingClient) throws Exception {
        return this.ctrModel.predictWithTF(featureMap, tfServingClient);
    }

    public <T> Map<T, Double> predicCVRWithTF(Map<T, Map<String, String>> featureMap, TFServingClient tfServingClient) throws Exception {
        return this.cvrModel.predictWithTF(featureMap, tfServingClient);
    }

    public <T> Map<String, Map<T, Double>> predicCTRAndCVRWithTF(Map<T, Map<String, String>> featureMap, TFServingClient tfServingClient) throws Exception {
        return tfServingClient.predictMut(this.getParams(featureMap));
    }

    public <T> Map<T, List<Float>> getParams(Map<T, Map<String, String>> featureMap) throws Exception {
        HashMap<T, List<Float>> ret = new HashMap<T, List<Float>>();
        if (AssertUtil.isNotEmpty(featureMap)) {
            for (Map.Entry<T, Map<String, String>> entry : featureMap.entrySet()) {
                List<Float> ctrP = this.ctrModel.getParam(entry.getValue());
                List<Float> cvrP = this.cvrModel.getParam(entry.getValue());
                ret.put(entry.getKey(), this.paramsSplicing(ctrP, cvrP));
            }
        }
        return ret;
    }

    public List<Float> paramsSplicing(List<Float> ctrP, List<Float> cvrP) {
        ctrP.addAll(cvrP);
        return ctrP;
    }
}

