/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.alg.model.tf;

import cn.com.duiba.nezha.alg.model.tf.TFServingClientUtil;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;

public class TFServingClient {
    public String host;
    public String modelName;
    public int port;
    public GenericObjectPoolConfig poolConfig;
    public static String DF_OUTPUT = "prob";
    public static String ESMM_CTR_OUTPUT = "prob";
    public static String ESMM_CVR_OUTPUT = "prob";
    public static String CTR_ID = "CTR";
    public static String CVR_ID = "CVR";

    public GenericObjectPoolConfig getPoolConfig() {
        return this.poolConfig;
    }

    public void setPoolConfig(GenericObjectPoolConfig poolConfig) {
        this.poolConfig = poolConfig;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public void setModelName(String modelName) {
        this.modelName = modelName;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public String getHost() {
        return this.host;
    }

    public String getModelName() {
        return this.modelName;
    }

    public int getPort() {
        return this.port;
    }

    public TFServingClient(String host, int port, String modelName, GenericObjectPoolConfig poolConfig) {
        this.host = host;
        this.modelName = modelName;
        this.port = port;
        this.poolConfig = poolConfig != null ? poolConfig : this.getDefPoolConfig();
    }

    public GenericObjectPoolConfig getDefPoolConfig() {
        GenericObjectPoolConfig poolConfig = new GenericObjectPoolConfig();
        poolConfig.setMaxTotal(50);
        poolConfig.setMinIdle(0);
        poolConfig.setMaxIdle(20);
        poolConfig.setMaxWaitMillis(1000L);
        poolConfig.setLifo(true);
        poolConfig.setMinEvictableIdleTimeMillis(1800000L);
        poolConfig.setBlockWhenExhausted(true);
        return poolConfig;
    }

    public <T> Map<T, Double> predict(Map<T, List<Float>> dataMap) throws Exception {
        Map<String, Map<T, Double>> ret = TFServingClientUtil.predict(dataMap, this.host, this.port, this.modelName, this.poolConfig, Arrays.asList(DF_OUTPUT));
        return ret.get(DF_OUTPUT);
    }

    public <T> Map<String, Map<T, Double>> predictMut(Map<T, List<Float>> dataMap) throws Exception {
        HashMap<String, Map<T, Double>> ret = new HashMap<String, Map<T, Double>>();
        Map<String, Map<T, Double>> tmp = TFServingClientUtil.predict(dataMap, this.host, this.port, this.modelName, this.poolConfig, Arrays.asList(ESMM_CTR_OUTPUT, ESMM_CVR_OUTPUT));
        ret.put(CTR_ID, tmp.get(ESMM_CTR_OUTPUT));
        ret.put(CVR_ID, tmp.get(ESMM_CVR_OUTPUT));
        return ret;
    }
}

