/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.alg.model.grpc;

import cn.com.duiba.nezha.alg.model.grpc.GrpcClientSingle;
import cn.com.duiba.nezha.alg.model.grpc.GrpcFactory;
import org.apache.commons.pool2.PooledObjectFactory;
import org.apache.commons.pool2.impl.GenericObjectPool;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GrpcPool {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    private String host;
    private int port;
    private GenericObjectPool<GrpcClientSingle> objectPool;

    public GrpcPool(String host, int port, GenericObjectPoolConfig poolConfig) {
        this.host = host;
        this.port = port;
        this.objectPool = new GenericObjectPool((PooledObjectFactory)new GrpcFactory(host, port), poolConfig);
    }

    public void returnObject(GrpcClientSingle grpcClientSingle) {
        this.objectPool.returnObject((Object)grpcClientSingle);
    }

    public GrpcClientSingle borrowObject() throws Exception {
        try {
            GrpcClientSingle clientSingle = (GrpcClientSingle)this.objectPool.borrowObject();
            return clientSingle;
        }
        catch (Exception e) {
            this.logger.warn("", (Throwable)e);
            return this.createClient();
        }
    }

    private GrpcClientSingle createClient() {
        return new GrpcClientSingle(this.host, this.port);
    }
}

