package cn.com.duiba.nezha.alg.model;

import cn.com.duiba.nezha.alg.common.util.AssertUtil;
import cn.com.duiba.nezha.alg.feature.coder.FeatureCoder3;
import cn.com.duiba.nezha.alg.feature.type.FeatureBaseType;
import cn.com.duiba.nezha.alg.feature.vo.FeatureCode;
import cn.com.duiba.nezha.alg.feature.vo.FeatureMapDo;
import cn.com.duiba.nezha.alg.model.tf.LocalTFModel;
import cn.com.duiba.nezha.alg.model.tf.TFServingClient;
import cn.com.duiba.nezha.alg.model.util.CollectionUtil;
import cn.com.duiba.nezha.alg.model.vo.ParamsDo;
import org.slf4j.LoggerFactory;

import java.io.Serializable;
import java.util.*;

public class DenseCoder implements Serializable, IModel {
    private static final org.slf4j.Logger logger = LoggerFactory.getLogger(DenseCoder.class);

    /**
     * 模型ID
     */
    private String modelId;

    /**
     * 更新时间
     */
    private String updateTime;

    /**
     * 模型参数
     */
    private ParamsDo paramsDo;


    private Map<String, Map<Integer, Integer>> coderMap;

    private Map<String, Map<String, FeatureCode>> tmpCoderCache = new HashMap<>();
    private Map<String, Map<String, String>> tmpCoderStrCache = new HashMap<>();

    private int FBT_MAX_SIZE = 64;

    private int PB_MAX_SIZE = 128;

    /**
     * 特征
     */
    private List<FeatureBaseType> featureBaseType = new ArrayList<FeatureBaseType>(FBT_MAX_SIZE);
    ;



    public void setFeatureBaseType(List<FeatureBaseType> featureBaseType) {
        this.featureBaseType = featureBaseType;
    }

    public List<FeatureBaseType> getFeatureBaseType() {
        return this.featureBaseType;
    }


    public void setModelId(String modelId) {
        this.modelId = modelId;
    }

    public String getModelId() {
        return this.modelId;
    }


    public void setUpdateTime(String updateTime) {
        this.updateTime = updateTime;
    }

    public String getUpdateTime() {
        return this.updateTime;
    }


    public void setParamsDo(ParamsDo paramsDo) {
        this.paramsDo = paramsDo;
    }

    public ParamsDo getParamsDo() {
        return this.paramsDo;
    }

    public Map<String, Map<Integer, Integer>> getCoderMap() {
        return coderMap;
    }

    public void setCoderMap(Map<String, Map<Integer, Integer>> coderMap) {
        this.coderMap = coderMap;
    }

    /**
     * @param featureMap
     * @return
     * @throws Exception
     */
    public Double predict(Map<String, String> featureMap) throws Exception {
        Double ret = null;

        return ret;
    }

    /**
     * @param featureMap
     * @return
     * @throws Exception
     */
    public Double predict(FeatureMapDo featureMap) throws Exception {
        Double ret = null;

        return ret;
    }
//

    /**
     * 单个请求
     *
     * @param codeMap
     * @return
     * @throws Exception
     */
    public String getCode(Map<String, String> codeMap) throws Exception {

        Map<String, FeatureCode> retMap = FeatureCoder3.codeOfEachFieldWithSeq(getFeatureBaseType(), codeMap, null, tmpCoderCache);
        return getDenseCode(retMap);
    }


    /**
     * @param codeMap
     * @return f1001:
     * @throws Exception
     */
    public String getDenseCode(Map<String, FeatureCode> codeMap) throws Exception {
        String ret = null;

        try {

            List<String> fieldStringList = new ArrayList<>();

            for (FeatureBaseType featureBaseType : featureBaseType) {

                String fieldName = featureBaseType.getName();

                int fieldType = featureBaseType.getCodeType();

                FeatureCode featureCode = codeMap.get(fieldName);

                String featureValue = featureCode.featureStr;

                String fCodeString = null;

                if (tmpCoderStrCache.get(fieldName) == null) {
                    tmpCoderStrCache.put(fieldName, new HashMap<>());
                }

                if (tmpCoderStrCache.get(fieldName).get(featureValue) == null) {

                    String tmpfCodeString = getDenseCoderStr(featureCode, fieldName, fieldType);
                    tmpCoderStrCache.get(fieldName).put(featureValue, tmpfCodeString);
                }

                fCodeString = tmpCoderStrCache.get(fieldName).get(featureValue);

                // 输出：域拼接
                String fieldString = fieldName + ":" + fCodeString;

                fieldStringList.add(fieldString);


            }

            // 输出：样本拼接
            ret = CollectionUtil.toString(fieldStringList, ";");

        } catch (Exception e) {
            logger.warn("getCode is invalid ", e);
        }


        return ret;
    }

    /**
     * @return
     */

    /**
     * 数值特征：0.5,0.3,0.8
     * ID特征：1,8,9
     *
     * @param featureCode
     * @param fieldName
     * @param fieldType
     * @return
     * @throws Exception
     */
    public String getDenseCoderStr(FeatureCode featureCode, String fieldName, int fieldType) throws Exception {
        String fCodeString = null;

        if (fieldType != 41) {
            List<Integer> fCodeId = new ArrayList<>();
            // ID特征
            for (int i = 0; i < featureCode.indices.length; i++) {

                Integer codeDense = coderMap.get(fieldName).getOrDefault(featureCode.indices[i], 0);
                fCodeId.add(codeDense);

            }

            // 输出：特征拼接
            fCodeString = CollectionUtil.toString(fCodeId, ",");

        } else {
            // 数值特征
            // 输出：特征拼接
            fCodeString = CollectionUtil.toString(featureCode.values, ",");
        }

        return fCodeString;
    }


    /**
     * 废弃
     */
    public List<Float> getParam(Map<String, String> featureMap) throws Exception {
        List<Float> ret = null;

        return ret;

    }

    /**
     * 废弃
     */
    public List<Float> getParam(FeatureMapDo featureMap) throws Exception {
        List<Float> ret = null;

        return ret;

    }

    /**
     * 废弃
     */
    public <T> Map<T, Double> predicts(Map<T, Map<String, String>> featureMap) throws Exception {
        Map<T, Double> ret = new HashMap<>(PB_MAX_SIZE);

        return ret;
    }

    /**
     * 废弃
     */
    public <T> Map<T, Double> predictsNew(Map<T, FeatureMapDo> featureMap) throws Exception {
        Map<T, Double> ret = new HashMap<>(PB_MAX_SIZE);

        return ret;
    }


    /**
     * @param featureMap
     * @return
     * @throws Exception
     */


    /**
     * 获取稠密编码
     *
     * @param featureCodeMap
     * @param <T>
     * @return
     * @throws Exception
     */
    public <T> Map<T, String> getDenseCodes(Map<T, Map<String, FeatureCode>> featureCodeMap) throws Exception {
        Map<T, String> ret = new HashMap<>(PB_MAX_SIZE);


        if (AssertUtil.isNotEmpty(featureCodeMap)) {

            for (Map.Entry<T, Map<String, FeatureCode>> entry : featureCodeMap.entrySet()) {
                ret.put(entry.getKey(), getDenseCode(entry.getValue()));
            }
        }
        if (AssertUtil.isEmpty(ret)) {
            logger.warn("getCodes is invalid, featureMap is null or {}");
        }
        return ret;

    }

    /**
     * @param featureMap
     * @param tfServingClient
     * @param <T>
     * @return
     * @throws Exception
     */
    public <T> Map<T, Double> predictWithTF(Map<T, Map<String, String>> featureMap, TFServingClient tfServingClient) throws Exception {
        Map<T, Double> ret = null;

        return ret;
    }

    /**
     * 废弃
     */
    public <T> Map<T, Double> predictWithTFNew(Map<T, FeatureMapDo> featureMap, TFServingClient tfServingClient) throws Exception {
        Map<T, Double> ret = null;

        return ret;
    }


    /**
     * 废弃
     */
    public <T> Map<T, Double> predictWithLocalTF(Map<T, Map<String, String>> featureMap, LocalTFModel localTFModel) throws Exception {
        Map<T, Double> ret = null;

        return ret;
    }

    /**
     * @param featureMap
     * @param localTFModel
     * @param <T>
     * @return
     * @throws Exception
     */

    /**
     * @param featureMap   预估样本集合
     * @param localTFModel 本地深度模型
     * @param <T>
     * @return
     * @throws Exception
     */
    public <T> Map<T, Double> predictWithLocalTFNew(Map<T, FeatureMapDo> featureMap, LocalTFModel localTFModel) throws Exception {
        Map<T, Double> ret = null;

        try {
            if (AssertUtil.isNotEmpty(featureMap)) {


                if (localTFModel == null) {
                    logger.info("predictWithLocalTF,local model is null");
                }

                /**
                 * 获取特征编码
                 */
                Map<T, Map<String, FeatureCode>> featureCodeMap = FeatureCoder3.codeOfEachFieldWithSeq(getFeatureBaseType(), featureMap, tmpCoderCache);

                /**
                 * 获取稠密编码
                 */
                Map<T, String> denseCoderMap = getDenseCodes(featureCodeMap);

                if (AssertUtil.isEmpty(denseCoderMap)) {
                    logger.info("predictWithLocalTF,feature is null");
                }
                ret = localTFModel.predictStr(denseCoderMap);

            }
        } catch (Exception e) {

            String logInfo = "predictWithTF warn ";
            logger.info(logInfo, e);
            ret = predictsNew(featureMap);
        } finally {
//            DBTimeProfile.release();
        }

        return ret;
    }


    public <T> Map<T, Double> predictWithLocalTFNewTest2(Map<T, FeatureMapDo> featureMap, LocalTFModel localTFModel) throws Exception {
        Map<T, Double> ret = null;

        try {
            if (AssertUtil.isNotEmpty(featureMap)) {


                if (localTFModel == null) {
                    logger.info("predictWithLocalTF,local model is null");
                }

                /**
                 * 获取特征编码
                 */
                Map<T, Map<String, FeatureCode>> featureCodeMap = FeatureCoder3.codeOfEachFieldWithSeq(getFeatureBaseType(), featureMap, tmpCoderCache);

                /**
                 * 获取稠密编码
                 */
                Map<T, String> denseCoderMap = getDenseCodes(featureCodeMap);

                if (AssertUtil.isEmpty(denseCoderMap)) {
                    logger.info("predictWithLocalTF,feature is null");
                }
                ret = localTFModel.predictStr(denseCoderMap);

            }
        } catch (Exception e) {

            String logInfo = "predictWithTF warn ";
            logger.info(logInfo, e);
            ret = predictsNew(featureMap);
        } finally {
//            DBTimeProfile.release();
        }

        return ret;
    }


    public static void main(String[] args) {

        DenseCoder coder = new DenseCoder();

        Map<String, Map<Integer, Integer>> map = new HashMap<>();

        Map<Integer, Integer> map1 = new HashMap<>();
        map1.put(0, 999);
        map1.put(101, 1001);
        map1.put(102, 1002);
        map1.put(103, 1003);
        map1.put(104, 1004);
        map1.put(105, 1005);

        map.put("f1001", map1);
        Map<Integer, Integer> map2 = new HashMap<>();
        map2.put(0, 999);
        map2.put(1, 2000);
        map2.put(2, 2002);
        map2.put(3, 2003);
        map2.put(4, 2004);
        map.put("f1002", map2);


        FeatureBaseType featureBaseType1 = new FeatureBaseType();
        featureBaseType1.setCodeType(11);
        featureBaseType1.setName("f1001");
        featureBaseType1.setDenseLen(10000);
        featureBaseType1.setSubLen(1000000);
        featureBaseType1.setHashNums(1);
        featureBaseType1.setSeq(",");

        FeatureBaseType featureBaseType2 = new FeatureBaseType();
        featureBaseType2.setCodeType(41);
        featureBaseType2.setName("f1002");
        featureBaseType2.setDenseLen(10000);
        featureBaseType2.setSubLen(4);
        featureBaseType2.setHashNums(1);
        featureBaseType2.setSeq(",");


        List<FeatureBaseType> list = Arrays.asList(featureBaseType1);

        coder.setCoderMap(map);
        coder.setFeatureBaseType(list);

        Map<String, String> featureMap = new HashMap<>();
        featureMap.put("f1001", "100,104");
        featureMap.put("f1002", "0.9,1.0,1.1,1.34");


        Map<String, FeatureMapDo> featureMapDoMap = new HashMap<>();
        FeatureMapDo featureMapDo = new FeatureMapDo();
        featureMapDo.setStaticFeatureMap(featureMap);
        featureMapDoMap.put("s1", featureMapDo);

        try {
//            coder.getCodesNew(featureMapDoMap);
//            System.out.println(JSON.toJSONString(coder.getDenseCodes(featureMapDoMap)));
//            featureMap.put("f1001", "100,104,105");
//            System.out.println(JSON.toJSONString(coder.getDenseCodes(featureMapDoMap)));
//            coder.getCode2(featureMap);

        } catch (Exception e) {

            System.out.println(e);
        }

    }

}
