package cn.com.duiba.nezha.alg.model.grpc;

import cn.com.duiba.nezha.alg.model.grpc.GrpcClientSingle;
import org.apache.commons.pool2.BasePooledObjectFactory;
import org.apache.commons.pool2.PooledObject;
import org.apache.commons.pool2.impl.DefaultPooledObject;

public class GrpcFactory extends BasePooledObjectFactory<GrpcClientSingle> {

    private String host;

    private int port;


    public int getPort() {
        return port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public String getHost() {
        return host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public GrpcFactory(String host, int port) {
        this.host = host;
        this.port = port;
    }

    @Override
    public GrpcClientSingle create() throws Exception {
        return new GrpcClientSingle(this.host, this.port);
    }

    @Override
    public PooledObject<GrpcClientSingle> wrap(GrpcClientSingle helloWorldClientSingle) {
        return new DefaultPooledObject<>(helloWorldClientSingle);
    }

    @Override
    public void destroyObject(PooledObject<GrpcClientSingle> p) throws Exception {
        p.getObject().shutdown();
        super.destroyObject(p);
    }


}
