package cn.com.duiba.nezha.alg.model;

import cn.com.duiba.nezha.alg.common.util.AssertUtil;
import cn.com.duiba.nezha.alg.feature.type.FeatureBaseType;
import cn.com.duiba.nezha.alg.feature.vo.FeatureMapDo;
import cn.com.duiba.nezha.alg.model.tf.LocalTFModel;
import cn.com.duiba.nezha.alg.model.tf.TFServingClient;
import cn.com.duiba.nezha.alg.model.util.CollectionUtil;
import cn.com.duiba.nezha.alg.model.vo.ParamsDo;
import org.slf4j.LoggerFactory;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DNN implements Serializable, IModel {

    private static final org.slf4j.Logger logger = LoggerFactory.getLogger(DNN.class);

    /**
     * 模型ID
     */
    private String modelId;

    /**
     * 更新时间
     */
    private String updateTime;

    /**
     * 模型参数
     */
    private ParamsDo paramsDo;


    private Map<String, Map<Integer, Integer>> coderMap;

    private int FBT_MAX_SIZE = 64;

    private int PB_MAX_SIZE = 128;

    /**
     * 特征
     */
    private List<FeatureBaseType> featureBaseType = new ArrayList<FeatureBaseType>(FBT_MAX_SIZE);
    ;

    public void setFeatureBaseType(List<FeatureBaseType> featureBaseType) {
        this.featureBaseType = featureBaseType;
    }

    public List<FeatureBaseType> getFeatureBaseType() {
        return this.featureBaseType;
    }


    public void setModelId(String modelId) {
        this.modelId = modelId;
    }

    public String getModelId() {
        return this.modelId;
    }


    public void setUpdateTime(String updateTime) {
        this.updateTime = updateTime;
    }

    public String getUpdateTime() {
        return this.updateTime;
    }


    public void setParamsDo(ParamsDo paramsDo) {
        this.paramsDo = paramsDo;
    }

    public ParamsDo getParamsDo() {
        return this.paramsDo;
    }

    public Map<String, Map<Integer, Integer>> getCoderMap() {
        return coderMap;
    }

    public void setCoderMap(Map<String, Map<Integer, Integer>> coderMap) {
        this.coderMap = coderMap;
    }

    /**
     * @param featureMap
     * @return
     * @throws Exception
     */
    public Double predict(Map<String, String> featureMap) throws Exception {
        Double ret = null;

        return ret;
    }

    /**
     * @param featureMap
     * @return
     * @throws Exception
     */
    public Double predict(FeatureMapDo featureMap) throws Exception {
        Double ret = null;

        return ret;
    }

    /**
     * @param featureMap
     * @return
     * @throws Exception
     */
    public String getCode(Map<String, String> featureMap) throws Exception {
        String ret = null;


        try {

            List<String> fieldStringList = new ArrayList<>();
            for (FeatureBaseType featureBaseType : featureBaseType) {

                String field = featureBaseType.getName();

                String fieldValue = featureMap.get(field);
                fieldStringList.add(fieldValue);

            }

            // 输出：样本拼接
            ret = CollectionUtil.toString(fieldStringList, "|");

        } catch (Exception e) {
            logger.warn("getCode is invalid ", e);
        }


        return ret;
    }

    /**
     * @param featureMapDo
     * @return
     * @throws Exception
     */
    public String getCode(FeatureMapDo featureMapDo) throws Exception {
        String ret = null;


        try {
            if (featureMapDo == null) {
                return ret;
            }
            List<String> fieldStringList = new ArrayList<>();
            for (FeatureBaseType featureBaseType : featureBaseType) {

                String fieldName = featureBaseType.getName();
                String fieldValue = featureMapDo.getDynamicFeatureMap().get(fieldName) == null ? featureMapDo.getStaticFeatureMap().get(fieldName) : featureMapDo.getDynamicFeatureMap().get(fieldName);

                fieldStringList.add(fieldValue);

            }

            // 输出：样本拼接
            ret = CollectionUtil.toString(fieldStringList, "|");

        } catch (Exception e) {
            logger.warn("getCode is invalid ", e);
        }


        return ret;
    }


    /**
     * @param featureMap
     * @return
     * @throws Exception
     */
    public List<Float> getParam(Map<String, String> featureMap) throws Exception {
        List<Float> ret = null;

        return ret;

    }

    /**
     * @param featureMap
     * @return
     * @throws Exception
     */
    public List<Float> getParam(FeatureMapDo featureMap) throws Exception {
        List<Float> ret = null;

        return ret;

    }

    public <T> Map<T, Double> predicts(Map<T, Map<String, String>> featureMap) throws Exception {
        Map<T, Double> ret = new HashMap<>(PB_MAX_SIZE);
        if (AssertUtil.isNotEmpty(featureMap)) {
            for (Map.Entry<T, Map<String, String>> entry : featureMap.entrySet()) {
                ret.put(entry.getKey(), predict(entry.getValue()));
            }
        }

        return ret;
    }

    public <T> Map<T, Double> predictsNew(Map<T, FeatureMapDo> featureMap) throws Exception {
        Map<T, Double> ret = new HashMap<>(PB_MAX_SIZE);
        if (AssertUtil.isNotEmpty(featureMap)) {
            for (Map.Entry<T, FeatureMapDo> entry : featureMap.entrySet()) {
                ret.put(entry.getKey(), predict(entry.getValue()));
            }
        }

        return ret;
    }


    /**
     * @param featureMap
     * @return
     * @throws Exception
     */
    public <T> Map<T, List<Float>> getParams(Map<T, Map<String, String>> featureMap) throws Exception {
        Map<T, List<Float>> ret = new HashMap<>(PB_MAX_SIZE);

        return ret;

    }


    /**
     * @param featureMap
     * @return
     * @throws Exception
     */
    public <T> Map<T, String> getCodes(Map<T, Map<String, String>> featureMap) throws Exception {
        Map<T, String> ret = new HashMap<>(PB_MAX_SIZE);


        if (AssertUtil.isNotEmpty(featureMap)) {
            for (Map.Entry<T, Map<String, String>> entry : featureMap.entrySet()) {
                ret.put(entry.getKey(), getCode(entry.getValue()));
            }
        }
        if (AssertUtil.isEmpty(ret)) {
            logger.warn("getCodes is invalid, featureMap is null or {}");
        }

        return ret;

    }


    /**
     * @param featureMap
     * @return
     * @throws Exception
     */
    public <T> Map<T, String> getCodesNew(Map<T, FeatureMapDo> featureMap) throws Exception {
        Map<T, String> ret = new HashMap<>(PB_MAX_SIZE);


        if (AssertUtil.isNotEmpty(featureMap)) {

            for (Map.Entry<T, FeatureMapDo> entry : featureMap.entrySet()) {
                ret.put(entry.getKey(), getCode(entry.getValue()));
            }
        }
        if (AssertUtil.isEmpty(ret)) {
            logger.warn("getCodes is invalid, featureMap is null or {}");
        }

        return ret;

    }


    /**
     * @param featureMap
     * @param tfServingClient
     * @param <T>
     * @return
     * @throws Exception
     */
    public <T> Map<T, Double> predictWithTF(Map<T, Map<String, String>> featureMap, TFServingClient tfServingClient) throws Exception {
        Map<T, Double> ret = null;
        if (tfServingClient == null || (featureMap != null)) {

            ret = null;
        } else {

            try {

                ret = tfServingClient.predictString(getCodes(featureMap));

            } catch (Exception e) {
                e.printStackTrace();
                String logInfo = tfServingClient.modelName + " predictWithTF warn ";
                logger.warn(logInfo + e);
                ret = null;
            }


        }


        return ret;
    }

    /**
     * @param featureMap
     * @param tfServingClient
     * @param <T>
     * @return
     * @throws Exception
     */
    public <T> Map<T, Double> predictWithTFNew(Map<T, FeatureMapDo> featureMap, TFServingClient tfServingClient) throws Exception {
        Map<T, Double> ret = null;
        if (tfServingClient == null || (featureMap != null)) {

            ret = null;
        } else {

            try {


                ret = tfServingClient.predictString(getCodesNew(featureMap));
//                System.out.println("dd="+JSON.toJSONString(ret));
            } catch (Exception e) {
                e.printStackTrace();
                String logInfo = tfServingClient.modelName + " predictWithTF warn ";
                logger.warn(logInfo + e);
                ret = null;
            }


        }


        return ret;
    }


    /**
     * @param featureMap
     * @param localTFModel
     * @param <T>
     * @return
     * @throws Exception
     */
    public <T> Map<T, Double> predictWithLocalTF(Map<T, Map<String, String>> featureMap, LocalTFModel localTFModel) throws Exception {
        Map<T, Double> ret = null;

        try {

            if (AssertUtil.isNotEmpty(featureMap)) {

                if (localTFModel == null) {
                    logger.info("predictWithLocalTF,local model is null");
                }
                Map<T, String> fMap = getCodes(featureMap);

//                System.out.println("o p="+ JSON.toJSONString(fMap));
                if (AssertUtil.isEmpty(fMap)) {
                    logger.info("predictWithLocalTF,feature is null");
                }
                ret = localTFModel.predictStr(fMap);

            }
        } catch (Exception e) {

            String logInfo = "predictWithTF warn ";
            logger.info(logInfo, e);
            ret = predicts(featureMap);
        } finally {
//            DBTimeProfile.release();
        }

        return ret;
    }

    /**
     * @param featureMap
     * @param localTFModel
     * @param <T>
     * @return
     * @throws Exception
     */
    public <T> Map<T, Double> predictWithLocalTFNew(Map<T, FeatureMapDo> featureMap, LocalTFModel localTFModel) throws Exception {
        Map<T, Double> ret = null;

        try {
//            DBTimeProfile.enter("CODER.predictWithLocalTF");
            if (AssertUtil.isNotEmpty(featureMap)) {

                if (localTFModel == null) {
                    logger.info("predictWithLocalTF,local model is null");
                }
                Map<T, String> fMap = getCodesNew(featureMap);
//                System.out.println("n f="+JSON.toJSONString(fMap));
                if (AssertUtil.isEmpty(fMap)) {
                    logger.info("predictWithLocalTF,feature is null");
                }
                ret = localTFModel.predictStr(fMap);

//                System.out.println(JSON.toJSONString(ret));
            }
        } catch (Exception e) {

            String logInfo = "predictWithTF warn ";
            logger.info(logInfo, e);
            ret = predictsNew(featureMap);
        } finally {
//            DBTimeProfile.release();
        }

        return ret;
    }

}
