package cn.com.duiba.nezha.alg.model;


import cn.com.duiba.nezha.alg.feature.vo.FeatureMapDo;
import cn.com.duiba.nezha.alg.model.enums.PredictResultType;
import cn.com.duiba.nezha.alg.model.tf.LocalTFModel;
import cn.com.duiba.nezha.alg.model.tf.TFServingClient;

import java.util.List;
import java.util.Map;

/**
 * Created by pc on 2017/7/11.
 */
public interface IModel {

    String getModelId();

    List<Float> getParam(Map<String, String> featureMap) throws Exception;

    List<Float> getParam(FeatureMapDo featureMapDo) throws Exception;


    /**
     * 本地模型，单个样本预估方法
     *
     * @param featureMap
     * @return
     * @throws Exception
     */
    Double predict(Map<String, String> featureMap) throws Exception;

    /**
     * 本地模型，批量预估方法
     *
     * @param featureMap
     * @return
     * @throws Exception
     */
    <T> Map<T, Double> predicts(Map<T, Map<String, String>> featureMap) throws Exception;

    /**
     * 本地模型+ 远程TFServing模型，批量预估方法
     *
     * @param featureMap
     * @param tfServingClient
     * @return
     * @throws Exception
     */
    <T> Map<T, Double> predictWithTF(Map<T, Map<String, String>> featureMap, TFServingClient tfServingClient) throws Exception;

    /**
     * 本地模型+ 远程TFServing模型，批量预估方法
     *
     * @param featureMap
     * @param localTFModel
     * @return
     * @throws Exception
     */
    <T> Map<T, Double> predictWithLocalTF(Map<T, Map<String, String>> featureMap, LocalTFModel localTFModel) throws Exception;

    /**
     * 本地模型+ 远程TFServing模型，批量预估方法
     *
     * @param featureMap
     * @param tfServingClient
     * @return
     * @throws Exception
     */
    <T> Map<T, Double> predictWithTFNew(Map<T, FeatureMapDo> featureMap, TFServingClient tfServingClient) throws Exception;

    /**
     * 本地模型+ 远程TFServing模型，批量预估方法
     *
     * @param featureMap
     * @param localTFModel
     * @return
     * @throws Exception
     */
    <T> Map<T, Double> predictWithLocalTFNew(Map<T, FeatureMapDo> featureMap, LocalTFModel localTFModel) throws Exception;

    <T> Map<T, Double> predictsNew(Map<T, FeatureMapDo> featureMap) throws Exception;
}