/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.alg.model;

import cn.com.duiba.nezha.alg.common.util.AssertUtil;
import cn.com.duiba.nezha.alg.feature.vo.FeatureMapDo;
import cn.com.duiba.nezha.alg.model.IModel;
import cn.com.duiba.nezha.alg.model.enums.PredictResultType;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DCVR
implements Serializable {
    private static final Logger logger = LoggerFactory.getLogger(DCVR.class);
    private int PB_MAX_SIZE = 128;
    private IModel dCvrModel;

    public IModel getDCvrModel() {
        return this.dCvrModel;
    }

    public void setDCvrModel(IModel bCvrModel) {
        this.dCvrModel = this.dCvrModel;
    }

    public DCVR(IModel dcvrModel) {
        this.dCvrModel = dcvrModel;
    }

    public <T> Map<PredictResultType, Map<T, Double>> predictDCvr(Map<T, FeatureMapDo> featureMap) throws Exception {
        HashMap<PredictResultType, Map<T, Double>> ret = new HashMap<PredictResultType, Map<T, Double>>(this.PB_MAX_SIZE);
        Map<T, Double> dcvrMap = this.dCvrModel.predictsNew(featureMap);
        if (AssertUtil.isAllNotEmpty((Object[])new Object[]{dcvrMap})) {
            ret.put(PredictResultType.DCVR, dcvrMap);
        } else {
            ret = null;
        }
        return ret;
    }
}

