/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.alg.model;

import cn.com.duiba.nezha.alg.common.util.AssertUtil;
import cn.com.duiba.nezha.alg.feature.vo.FeatureMapDo;
import cn.com.duiba.nezha.alg.model.ESMM;
import cn.com.duiba.nezha.alg.model.IModel;
import cn.com.duiba.nezha.alg.model.enums.MutModelType;
import cn.com.duiba.nezha.alg.model.enums.PredictResultType;
import cn.com.duiba.nezha.alg.model.tf.LocalTFModel;
import cn.com.duiba.nezha.alg.model.tf.TFServingClient;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MOE
implements Serializable {
    private static final long serialVersionUID = -316102112618444131L;
    private static final Logger logger = LoggerFactory.getLogger(ESMM.class);
    private int PB_MAX_SIZE = 128;
    private IModel ctrModel;
    private IModel cvrModel;
    private IModel ctrFusingModel;
    private IModel cvrFusingModel;
    private LocalTFModel ctrLocalTFModel;
    private Map<String, LocalTFModel> cvrLocalTFModels;
    private TFServingClient ctrTFServingClient;
    private Map<String, TFServingClient> cvrTFServingClients;
    private MutModelType mutModelType;

    public MOE(IModel ctrModel, IModel cvrModel, IModel ctrFusingModel, IModel cvrFusingModel, LocalTFModel ctrLocalTFModel, Map<String, LocalTFModel> cvrLocalTFModels, TFServingClient ctrTFServingClient, Map<String, TFServingClient> cvrTFServingClients, MutModelType mutModelType) {
        this.ctrModel = ctrModel;
        this.cvrModel = cvrModel;
        this.ctrFusingModel = ctrFusingModel;
        this.cvrFusingModel = cvrFusingModel;
        this.ctrLocalTFModel = ctrLocalTFModel;
        this.cvrLocalTFModels = cvrLocalTFModels;
        this.ctrTFServingClient = ctrTFServingClient;
        this.cvrTFServingClients = cvrTFServingClients;
        this.mutModelType = mutModelType;
    }

    public MOE(IModel ctrModel, IModel cvrModel, TFServingClient ctrTFServingClient, Map<String, TFServingClient> cvrTFServingClients, MutModelType mutModelType) {
        this.ctrModel = ctrModel;
        this.cvrModel = cvrModel;
        this.ctrTFServingClient = ctrTFServingClient;
        this.cvrTFServingClients = cvrTFServingClients;
        this.mutModelType = mutModelType;
    }

    public <T> Map<PredictResultType, Map<T, Double>> predictCTRsAndCVRsWithTF(Map<T, Map<String, String>> featureMap) throws Exception {
        Map<PredictResultType, Map<T, Double>> ret = MutModelType.CTR == this.mutModelType ? this.predictCTRs(featureMap) : this.predictCTRsAndCVRsWithTFDEEP(featureMap);
        return ret;
    }

    public <T> Map<PredictResultType, Map<T, Double>> predictCTRsAndCVRsWithTFNew(Map<T, FeatureMapDo> featureMap) throws Exception {
        Map<PredictResultType, Map<T, Double>> ret = MutModelType.CTR == this.mutModelType ? this.predictCTRsNew(featureMap) : this.predictCTRsAndCVRsWithTFDEEPNew(featureMap);
        return ret;
    }

    public <T> Map<PredictResultType, Map<T, Double>> predictCTRsNew(Map<T, FeatureMapDo> featureMap) throws Exception {
        HashMap<PredictResultType, Map<T, Double>> ret = new HashMap<PredictResultType, Map<T, Double>>(this.PB_MAX_SIZE);
        Map<T, Double> ctrMap = this.ctrModel.predictWithTFNew(featureMap, this.ctrTFServingClient);
        if (AssertUtil.isAllNotEmpty((Object[])new Object[]{ctrMap})) {
            ret.put(PredictResultType.CTR, ctrMap);
        } else {
            ret = null;
        }
        return ret;
    }

    public <T> Map<PredictResultType, Map<T, Double>> predictCTRs(Map<T, Map<String, String>> featureMap) throws Exception {
        HashMap<PredictResultType, Map<T, Double>> ret = new HashMap<PredictResultType, Map<T, Double>>(this.PB_MAX_SIZE);
        Map<T, Double> ctrMap = this.ctrModel.predictWithTF(featureMap, this.ctrTFServingClient);
        if (AssertUtil.isAllNotEmpty((Object[])new Object[]{ctrMap})) {
            ret.put(PredictResultType.CTR, ctrMap);
        } else {
            ret = null;
        }
        return ret;
    }

    public <T> Map<PredictResultType, Map<T, Double>> predictCTRsAndCVRsWithTFDEEP(Map<T, Map<String, String>> featureMap) throws Exception {
        Map<PredictResultType, Map<T, Double>> ret = MutModelType.DEEP_ESMM == this.mutModelType ? this.ctrTFServingClient.predictMut(this.getParams(featureMap)) : this.predictCTRsAndCVRs(featureMap);
        if (ret == null) {
            ret = this.predictFusingCTRsAndCVRs(featureMap);
            for (Map.Entry<PredictResultType, Map<T, Double>> entry : ret.entrySet()) {
                PredictResultType key = entry.getKey();
                if (key != PredictResultType.CTR) continue;
                for (Map.Entry<T, Double> subEntry : entry.getValue().entrySet()) {
                    Double predictCtr = subEntry.getValue();
                    if (predictCtr != 0.0) continue;
                    String logInfo = this.ctrTFServingClient.modelName + " predictFusing warn preCtr=0";
                    logger.warn(logInfo);
                }
            }
        }
        return ret;
    }

    public <T> Map<PredictResultType, Map<T, Double>> predictCTRsAndCVRsWithTFDEEPNew(Map<T, FeatureMapDo> featureMap) throws Exception {
        Map<PredictResultType, Map<T, Double>> ret = MutModelType.DEEP_ESMM == this.mutModelType ? this.ctrTFServingClient.predictMut(this.getParamsNew(featureMap)) : (MutModelType.DEEP_E2E_LOCAL == this.mutModelType ? this.predictCTRsAndCVRsLocalTFNew(featureMap) : this.predictCTRsAndCVRsNew(featureMap));
        if (ret == null) {
            ret = this.predictFusingCTRsAndCVRsNew(featureMap);
            for (Map.Entry<PredictResultType, Map<T, Double>> entry : ret.entrySet()) {
                PredictResultType key = entry.getKey();
                if (key != PredictResultType.CTR) continue;
                for (Map.Entry<T, Double> subEntry : entry.getValue().entrySet()) {
                    Double predictCtr = subEntry.getValue();
                    if (predictCtr != 0.0) continue;
                    String logInfo = this.ctrTFServingClient.modelName + " predictFusing warn preCtr=0";
                    logger.warn(logInfo);
                }
            }
        }
        return ret;
    }

    private <T> Map<PredictResultType, Map<T, Double>> predictCTRsAndCVRs(Map<T, Map<String, String>> featureMap) throws Exception {
        HashMap<PredictResultType, Map<T, Double>> ret = new HashMap<PredictResultType, Map<T, Double>>(this.PB_MAX_SIZE);
        Map<T, Double> ctrMap = this.ctrModel.predictWithTF(featureMap, this.ctrTFServingClient);
        if (AssertUtil.isNotEmpty(ctrMap)) {
            HashMap cvrMap = new HashMap();
            for (Map.Entry<String, TFServingClient> cvrTFServingClient : this.cvrTFServingClients.entrySet()) {
                Map<Object, Double> subCvrMap;
                HashMap<T, Map<String, String>> subFeatures = new HashMap<T, Map<String, String>>();
                if (cvrTFServingClient.getKey().equals("2") || cvrTFServingClient.getKey().equals("3")) {
                    for (Map.Entry<T, Map<String, String>> instance : featureMap.entrySet()) {
                        if (!instance.getValue().get("f115001").equals(cvrTFServingClient.getKey())) continue;
                        subFeatures.put(instance.getKey(), instance.getValue());
                    }
                } else {
                    for (Map.Entry<T, Map<String, String>> instance : featureMap.entrySet()) {
                        if (instance.getValue().getOrDefault("f115001", "0").equals("2") || instance.getValue().getOrDefault("f115001", "0").equals("3")) continue;
                        subFeatures.put(instance.getKey(), instance.getValue());
                    }
                }
                if ((subCvrMap = this.cvrModel.predictWithTF(subFeatures, cvrTFServingClient.getValue())) == null) continue;
                subCvrMap.forEach((key, value) -> cvrMap.merge(key, value, (v1, v2) -> v1));
            }
            if (AssertUtil.isNotEmpty(cvrMap)) {
                ret.put(PredictResultType.CTR, ctrMap);
                ret.put(PredictResultType.CVR, cvrMap);
            }
        } else {
            ret = null;
        }
        return ret;
    }

    private <T> Map<PredictResultType, Map<T, Double>> predictCTRsAndCVRsNew(Map<T, FeatureMapDo> featureMap) throws Exception {
        HashMap<PredictResultType, Map<T, Double>> ret = new HashMap<PredictResultType, Map<T, Double>>(this.PB_MAX_SIZE);
        Map<T, Double> ctrMap = this.ctrModel.predictWithTFNew(featureMap, this.ctrTFServingClient);
        if (AssertUtil.isNotEmpty(ctrMap)) {
            HashMap cvrMap = new HashMap();
            for (Map.Entry<String, TFServingClient> cvrTFServingClient : this.cvrTFServingClients.entrySet()) {
                Map<Object, Double> subCvrMap;
                HashMap<T, FeatureMapDo> subFeatures = new HashMap<T, FeatureMapDo>();
                if (cvrTFServingClient.getKey().equals("2") || cvrTFServingClient.getKey().equals("3")) {
                    for (Map.Entry<T, FeatureMapDo> instance : featureMap.entrySet()) {
                        if (AssertUtil.isEmpty((Object)instance.getValue()) || AssertUtil.isEmpty((Map)instance.getValue().getDynamicFeatureMap()) || !instance.getValue().getDynamicFeatureMap().getOrDefault("f115001", "0").equals(cvrTFServingClient.getKey())) continue;
                        subFeatures.put(instance.getKey(), instance.getValue());
                    }
                } else {
                    for (Map.Entry<T, FeatureMapDo> instance : featureMap.entrySet()) {
                        if (AssertUtil.isEmpty((Object)instance.getValue()) || AssertUtil.isEmpty((Map)instance.getValue().getDynamicFeatureMap()) || instance.getValue().getDynamicFeatureMap().getOrDefault("f115001", "0").equals("2") || instance.getValue().getDynamicFeatureMap().getOrDefault("f115001", "0").equals("3")) continue;
                        subFeatures.put(instance.getKey(), instance.getValue());
                    }
                }
                if ((subCvrMap = this.cvrModel.predictWithTFNew(subFeatures, cvrTFServingClient.getValue())) == null) continue;
                subCvrMap.forEach((key, value) -> cvrMap.merge(key, value, (v1, v2) -> v1));
            }
            if (AssertUtil.isNotEmpty(cvrMap)) {
                ret.put(PredictResultType.CTR, ctrMap);
                ret.put(PredictResultType.CVR, cvrMap);
            }
        } else {
            ret = null;
        }
        return ret;
    }

    private <T> Map<PredictResultType, Map<T, Double>> predictCTRsAndCVRsLocalTFNew(Map<T, FeatureMapDo> featureMap) throws Exception {
        HashMap<PredictResultType, Map<T, Double>> ret = new HashMap<PredictResultType, Map<T, Double>>(this.PB_MAX_SIZE);
        Map<T, Double> ctrMap = this.ctrModel.predictWithLocalTFNew(featureMap, this.ctrLocalTFModel);
        if (AssertUtil.isNotEmpty(ctrMap)) {
            HashMap cvrMap = new HashMap();
            for (Map.Entry<String, LocalTFModel> cvrLocalTFModel : this.cvrLocalTFModels.entrySet()) {
                Map<Object, Double> subCvrMap;
                HashMap<T, FeatureMapDo> subFeatures = new HashMap<T, FeatureMapDo>();
                if (cvrLocalTFModel.getKey().equals("2") || cvrLocalTFModel.getKey().equals("3")) {
                    for (Map.Entry<T, FeatureMapDo> instance : featureMap.entrySet()) {
                        if (AssertUtil.isEmpty((Object)instance.getValue()) || AssertUtil.isEmpty((Map)instance.getValue().getDynamicFeatureMap()) || !instance.getValue().getDynamicFeatureMap().getOrDefault("f115001", "0").equals(cvrLocalTFModel.getKey())) continue;
                        subFeatures.put(instance.getKey(), instance.getValue());
                    }
                } else {
                    for (Map.Entry<T, FeatureMapDo> instance : featureMap.entrySet()) {
                        if (AssertUtil.isEmpty((Object)instance.getValue()) || AssertUtil.isEmpty((Map)instance.getValue().getDynamicFeatureMap()) || instance.getValue().getDynamicFeatureMap().getOrDefault("f115001", "0").equals("2") || instance.getValue().getDynamicFeatureMap().getOrDefault("f115001", "0").equals("3")) continue;
                        subFeatures.put(instance.getKey(), instance.getValue());
                    }
                }
                if ((subCvrMap = this.cvrModel.predictWithLocalTFNew(subFeatures, cvrLocalTFModel.getValue())) == null) continue;
                subCvrMap.forEach((key, value) -> cvrMap.merge(key, value, (v1, v2) -> v1));
            }
            if (AssertUtil.isNotEmpty(cvrMap)) {
                ret.put(PredictResultType.CTR, ctrMap);
                ret.put(PredictResultType.CVR, cvrMap);
            }
        } else {
            ret = null;
        }
        return ret;
    }

    private <T> Map<PredictResultType, Map<T, Double>> predictFusingCTRsAndCVRs(Map<T, Map<String, String>> featureMap) throws Exception {
        HashMap<PredictResultType, Map<T, Double>> ret = new HashMap<PredictResultType, Map<T, Double>>(this.PB_MAX_SIZE);
        ret.put(PredictResultType.CTR, this.ctrFusingModel.predictWithTF(featureMap, null));
        ret.put(PredictResultType.CVR, this.cvrFusingModel.predictWithTF(featureMap, null));
        return ret;
    }

    private <T> Map<PredictResultType, Map<T, Double>> predictFusingCTRsAndCVRsNew(Map<T, FeatureMapDo> featureMap) throws Exception {
        HashMap<PredictResultType, Map<T, Double>> ret = new HashMap<PredictResultType, Map<T, Double>>(this.PB_MAX_SIZE);
        ret.put(PredictResultType.CTR, this.ctrFusingModel.predictWithTFNew(featureMap, null));
        ret.put(PredictResultType.CVR, this.cvrFusingModel.predictWithTFNew(featureMap, null));
        return ret;
    }

    private <T> Map<T, List<Float>> getParams(Map<T, Map<String, String>> featureMap) throws Exception {
        HashMap<T, List<Float>> ret = new HashMap<T, List<Float>>(this.PB_MAX_SIZE);
        if (AssertUtil.isNotEmpty(featureMap)) {
            for (Map.Entry<T, Map<String, String>> entry : featureMap.entrySet()) {
                List<Float> ctrP = this.ctrModel.getParam(entry.getValue());
                List<Float> cvrP = this.cvrModel.getParam(entry.getValue());
                ret.put(entry.getKey(), this.paramsSplicing(ctrP, cvrP));
            }
        }
        return ret;
    }

    private <T> Map<T, List<Float>> getParamsNew(Map<T, FeatureMapDo> featureMap) throws Exception {
        HashMap<T, List<Float>> ret = new HashMap<T, List<Float>>(this.PB_MAX_SIZE);
        if (AssertUtil.isNotEmpty(featureMap)) {
            for (Map.Entry<T, FeatureMapDo> entry : featureMap.entrySet()) {
                List<Float> ctrP = this.ctrModel.getParam(entry.getValue());
                List<Float> cvrP = this.cvrModel.getParam(entry.getValue());
                ret.put(entry.getKey(), this.paramsSplicing(ctrP, cvrP));
            }
        }
        return ret;
    }

    private List<Float> paramsSplicing(List<Float> ctrP, List<Float> cvrP) {
        ctrP.addAll(cvrP);
        return ctrP;
    }

    public int getPB_MAX_SIZE() {
        return this.PB_MAX_SIZE;
    }

    public IModel getCtrModel() {
        return this.ctrModel;
    }

    public IModel getCvrModel() {
        return this.cvrModel;
    }

    public IModel getCtrFusingModel() {
        return this.ctrFusingModel;
    }

    public IModel getCvrFusingModel() {
        return this.cvrFusingModel;
    }

    public LocalTFModel getCtrLocalTFModel() {
        return this.ctrLocalTFModel;
    }

    public Map<String, LocalTFModel> getCvrLocalTFModels() {
        return this.cvrLocalTFModels;
    }

    public TFServingClient getCtrTFServingClient() {
        return this.ctrTFServingClient;
    }

    public Map<String, TFServingClient> getCvrTFServingClients() {
        return this.cvrTFServingClients;
    }

    public MutModelType getMutModelType() {
        return this.mutModelType;
    }

    public void setPB_MAX_SIZE(int PB_MAX_SIZE) {
        this.PB_MAX_SIZE = PB_MAX_SIZE;
    }

    public void setCtrModel(IModel ctrModel) {
        this.ctrModel = ctrModel;
    }

    public void setCvrModel(IModel cvrModel) {
        this.cvrModel = cvrModel;
    }

    public void setCtrFusingModel(IModel ctrFusingModel) {
        this.ctrFusingModel = ctrFusingModel;
    }

    public void setCvrFusingModel(IModel cvrFusingModel) {
        this.cvrFusingModel = cvrFusingModel;
    }

    public void setCtrLocalTFModel(LocalTFModel ctrLocalTFModel) {
        this.ctrLocalTFModel = ctrLocalTFModel;
    }

    public void setCvrLocalTFModels(Map<String, LocalTFModel> cvrLocalTFModels) {
        this.cvrLocalTFModels = cvrLocalTFModels;
    }

    public void setCtrTFServingClient(TFServingClient ctrTFServingClient) {
        this.ctrTFServingClient = ctrTFServingClient;
    }

    public void setCvrTFServingClients(Map<String, TFServingClient> cvrTFServingClients) {
        this.cvrTFServingClients = cvrTFServingClients;
    }

    public void setMutModelType(MutModelType mutModelType) {
        this.mutModelType = mutModelType;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MOE)) {
            return false;
        }
        MOE other = (MOE)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getPB_MAX_SIZE() != other.getPB_MAX_SIZE()) {
            return false;
        }
        IModel this$ctrModel = this.getCtrModel();
        IModel other$ctrModel = other.getCtrModel();
        if (this$ctrModel == null ? other$ctrModel != null : !this$ctrModel.equals(other$ctrModel)) {
            return false;
        }
        IModel this$cvrModel = this.getCvrModel();
        IModel other$cvrModel = other.getCvrModel();
        if (this$cvrModel == null ? other$cvrModel != null : !this$cvrModel.equals(other$cvrModel)) {
            return false;
        }
        IModel this$ctrFusingModel = this.getCtrFusingModel();
        IModel other$ctrFusingModel = other.getCtrFusingModel();
        if (this$ctrFusingModel == null ? other$ctrFusingModel != null : !this$ctrFusingModel.equals(other$ctrFusingModel)) {
            return false;
        }
        IModel this$cvrFusingModel = this.getCvrFusingModel();
        IModel other$cvrFusingModel = other.getCvrFusingModel();
        if (this$cvrFusingModel == null ? other$cvrFusingModel != null : !this$cvrFusingModel.equals(other$cvrFusingModel)) {
            return false;
        }
        LocalTFModel this$ctrLocalTFModel = this.getCtrLocalTFModel();
        LocalTFModel other$ctrLocalTFModel = other.getCtrLocalTFModel();
        if (this$ctrLocalTFModel == null ? other$ctrLocalTFModel != null : !this$ctrLocalTFModel.equals(other$ctrLocalTFModel)) {
            return false;
        }
        Map<String, LocalTFModel> this$cvrLocalTFModels = this.getCvrLocalTFModels();
        Map<String, LocalTFModel> other$cvrLocalTFModels = other.getCvrLocalTFModels();
        if (this$cvrLocalTFModels == null ? other$cvrLocalTFModels != null : !((Object)this$cvrLocalTFModels).equals(other$cvrLocalTFModels)) {
            return false;
        }
        TFServingClient this$ctrTFServingClient = this.getCtrTFServingClient();
        TFServingClient other$ctrTFServingClient = other.getCtrTFServingClient();
        if (this$ctrTFServingClient == null ? other$ctrTFServingClient != null : !this$ctrTFServingClient.equals(other$ctrTFServingClient)) {
            return false;
        }
        Map<String, TFServingClient> this$cvrTFServingClients = this.getCvrTFServingClients();
        Map<String, TFServingClient> other$cvrTFServingClients = other.getCvrTFServingClients();
        if (this$cvrTFServingClients == null ? other$cvrTFServingClients != null : !((Object)this$cvrTFServingClients).equals(other$cvrTFServingClients)) {
            return false;
        }
        MutModelType this$mutModelType = this.getMutModelType();
        MutModelType other$mutModelType = other.getMutModelType();
        return !(this$mutModelType == null ? other$mutModelType != null : !((Object)((Object)this$mutModelType)).equals((Object)other$mutModelType));
    }

    protected boolean canEqual(Object other) {
        return other instanceof MOE;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getPB_MAX_SIZE();
        IModel $ctrModel = this.getCtrModel();
        result = result * 59 + ($ctrModel == null ? 43 : $ctrModel.hashCode());
        IModel $cvrModel = this.getCvrModel();
        result = result * 59 + ($cvrModel == null ? 43 : $cvrModel.hashCode());
        IModel $ctrFusingModel = this.getCtrFusingModel();
        result = result * 59 + ($ctrFusingModel == null ? 43 : $ctrFusingModel.hashCode());
        IModel $cvrFusingModel = this.getCvrFusingModel();
        result = result * 59 + ($cvrFusingModel == null ? 43 : $cvrFusingModel.hashCode());
        LocalTFModel $ctrLocalTFModel = this.getCtrLocalTFModel();
        result = result * 59 + ($ctrLocalTFModel == null ? 43 : $ctrLocalTFModel.hashCode());
        Map<String, LocalTFModel> $cvrLocalTFModels = this.getCvrLocalTFModels();
        result = result * 59 + ($cvrLocalTFModels == null ? 43 : ((Object)$cvrLocalTFModels).hashCode());
        TFServingClient $ctrTFServingClient = this.getCtrTFServingClient();
        result = result * 59 + ($ctrTFServingClient == null ? 43 : $ctrTFServingClient.hashCode());
        Map<String, TFServingClient> $cvrTFServingClients = this.getCvrTFServingClients();
        result = result * 59 + ($cvrTFServingClients == null ? 43 : ((Object)$cvrTFServingClients).hashCode());
        MutModelType $mutModelType = this.getMutModelType();
        result = result * 59 + ($mutModelType == null ? 43 : ((Object)((Object)$mutModelType)).hashCode());
        return result;
    }

    public String toString() {
        return "MOE(PB_MAX_SIZE=" + this.getPB_MAX_SIZE() + ", ctrModel=" + this.getCtrModel() + ", cvrModel=" + this.getCvrModel() + ", ctrFusingModel=" + this.getCtrFusingModel() + ", cvrFusingModel=" + this.getCvrFusingModel() + ", ctrLocalTFModel=" + this.getCtrLocalTFModel() + ", cvrLocalTFModels=" + this.getCvrLocalTFModels() + ", ctrTFServingClient=" + this.getCtrTFServingClient() + ", cvrTFServingClients=" + this.getCvrTFServingClients() + ", mutModelType=" + (Object)((Object)this.getMutModelType()) + ")";
    }
}

