package cn.com.duiba.nezha.alg.model.grpc;

import io.grpc.ManagedChannel;
import io.grpc.ManagedChannelBuilder;

import java.util.concurrent.TimeUnit;

public class GrpcClientSingle {
    private String host;
    private int port;
    private ManagedChannel channel; //一个gRPC信道

    //初始化信道和存根
    public GrpcClientSingle(String host, int port) {
        setChannel(host, port);
    }

    public void shutdown() throws InterruptedException {
        channel.shutdown().awaitTermination(5, TimeUnit.SECONDS);
    }

    public ManagedChannel getChannel() {
        validateChannel();
        return channel;
    }

    public void setChannel(String host, int port) {

        this.host = host;
        this.port = port;
        setChannel();
    }

    /**
     * 检验channel
     */
    public synchronized void validateChannel() {

        if (channel.isShutdown() || channel.isTerminated()) {
            setChannel();
        }
    }

    public synchronized void setChannel() {
        this.channel = ManagedChannelBuilder.forAddress(host, port).usePlaintext(true).build();

    }


}
