package cn.com.duiba.nezha.alg.model;

import cn.com.duiba.nezha.alg.common.util.AssertUtil;
import cn.com.duiba.nezha.alg.feature.coder.FeatureCoder;
import cn.com.duiba.nezha.alg.feature.type.FeatureBaseType;
import cn.com.duiba.nezha.alg.feature.vo.CodeResult;
import cn.com.duiba.nezha.alg.model.tf.TFServingClient;
import cn.com.duiba.nezha.alg.model.util.CollectionUtil;
import cn.com.duiba.nezha.alg.model.vo.ParamsDo;
import org.slf4j.LoggerFactory;

import java.io.Serializable;
import java.util.*;

public class CODER implements Serializable, IModel {
    private static final long serialVersionUID = -316102112618444130L;

    private static final org.slf4j.Logger logger = LoggerFactory.getLogger(CODER.class);

    /**
     * 模型ID
     */
    private String modelId;

    /**
     * 更新时间
     */
    private String updateTime;

    /**
     * 模型参数
     */
    private ParamsDo paramsDo;


    private Map<String, Map<Long, Long>> coderMap;

    private int FBT_MAX_SIZE = 64;

    private int PB_MAX_SIZE = 128;

    /**
     * 特征
     */
    private List<FeatureBaseType> featureBaseType = new ArrayList<FeatureBaseType>(FBT_MAX_SIZE);
    ;

    public void setFeatureBaseType(List<FeatureBaseType> featureBaseType) {
        this.featureBaseType = featureBaseType;
    }

    public List<FeatureBaseType> getFeatureBaseType() {
        return this.featureBaseType;
    }


    public void setModelId(String modelId) {
        this.modelId = modelId;
    }

    public String getModelId() {
        return this.modelId;
    }


    public void setUpdateTime(String updateTime) {
        this.updateTime = updateTime;
    }

    public String getUpdateTime() {
        return this.updateTime;
    }


    public void setParamsDo(ParamsDo paramsDo) {
        this.paramsDo = paramsDo;
    }

    public ParamsDo getParamsDo() {
        return this.paramsDo;
    }

    public Map<String, Map<Long, Long>> getCoderMap() {
        return coderMap;
    }

    public void setCoderMap(Map<String, Map<Long, Long>> coderMap) {
        this.coderMap = coderMap;
    }

    /**
     * @param featureMap
     * @return
     * @throws Exception
     */
    public Double predict(Map<String, String> featureMap) throws Exception {
        Double ret = null;

        return ret;
    }

    /**
     * @param featureMap
     * @return
     * @throws Exception
     */
    public String getCode(Map<String, String> featureMap) throws Exception {
        String ret = null;


        CodeResult codeResult = FeatureCoder.codeOfEachField(getFeatureBaseType(), featureMap);

        Map<String, Map<Long, Double>> fieldFeatureMap = codeResult.getFieldFeatureMap();


        List<String> fieldStringList = new ArrayList<>();
        for (FeatureBaseType featureBaseType : featureBaseType) {
            String field = featureBaseType.getName();
            Map<Long, Double> sparceCode = fieldFeatureMap.get(field);
            Map<Long, Long> denseCodeMap = coderMap.get(field);


            List<Long> fCode = new ArrayList<>();
            List<Long> sparceCodeKeyList = new ArrayList<>(sparceCode.keySet());

            Long filedDefaultValue = denseCodeMap.getOrDefault(0L, 0L);

            for (int i = 0; i < sparceCodeKeyList.size(); i++) {
                Long codeDense = denseCodeMap.getOrDefault(sparceCodeKeyList.get(i), filedDefaultValue);
                fCode.add(codeDense);
            }

            String fCodeString = CollectionUtil.toString(fCode, ",");
            String fieldString = field + ":" + fCodeString;

            fieldStringList.add(fieldString);
        }
        ret = CollectionUtil.toString(fieldStringList, ";");


        return ret;
    }


    /**
     * @param featureMap
     * @return
     * @throws Exception
     */
    public List<Float> getParam(Map<String, String> featureMap) throws Exception {
        List<Float> ret = null;

        return ret;

    }

    public <T> Map<T, Double> predicts(Map<T, Map<String, String>> featureMap) throws Exception {
        Map<T, Double> ret = new HashMap<>(PB_MAX_SIZE);
        if (AssertUtil.isNotEmpty(featureMap)) {
            for (Map.Entry<T, Map<String, String>> entry : featureMap.entrySet()) {
                ret.put(entry.getKey(), predict(entry.getValue()));
            }
        }

        return ret;
    }

    /**
     * @param featureMap
     * @return
     * @throws Exception
     */
    public <T> Map<T, List<Float>> getParams(Map<T, Map<String, String>> featureMap) throws Exception {
        Map<T, List<Float>> ret = new HashMap<>(PB_MAX_SIZE);

        return ret;

    }


    /**
     * @param featureMap
     * @return
     * @throws Exception
     */
    public <T> Map<T, String> getCodes(Map<T, Map<String, String>> featureMap) throws Exception {
        Map<T, String> ret = new HashMap<>(PB_MAX_SIZE);

        if (AssertUtil.isNotEmpty(featureMap)) {
            for (Map.Entry<T, Map<String, String>> entry : featureMap.entrySet()) {
                ret.put(entry.getKey(), getCode(entry.getValue()));
            }
        }
        return ret;

    }

    /**
     * @param featureMap
     * @param tfServingClient
     * @param <T>
     * @return
     * @throws Exception
     */
    public <T> Map<T, Double> predictWithTF(Map<T, Map<String, String>> featureMap, TFServingClient tfServingClient) throws Exception {
        Map<T, Double> ret = null;
        if (tfServingClient == null || (featureMap != null && featureMap.size() > 70)) {
            ret = predicts(featureMap);
        } else {

            try {
                ret = tfServingClient.predictString(getCodes(featureMap));
            } catch (Exception e) {
                e.printStackTrace();
                logger.warn("predictWithTF warn " + e);
                ret = null;
            }


        }


        return ret;
    }


}
