/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.alg.model;

import cn.com.duiba.nezha.alg.common.util.AssertUtil;
import cn.com.duiba.nezha.alg.feature.vo.FeatureMapDo;
import cn.com.duiba.nezha.alg.model.IModel;
import cn.com.duiba.nezha.alg.model.enums.PredictResultType;
import cn.com.duiba.nezha.alg.model.tf.LocalTFModelV2;
import cn.com.duiba.nezha.alg.model.tf.TFServingClient;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DCVRv3
implements Serializable {
    private static final Logger logger = LoggerFactory.getLogger(DCVRv3.class);
    private IModel dCvrModel;
    private IModel coderModel;
    private LocalTFModelV2 dcvrLocalTFModel;
    private TFServingClient dcvrServingClient;

    public LocalTFModelV2 getDcvrLocalTFModel() {
        return this.dcvrLocalTFModel;
    }

    public void setDcvrLocalTFModel(LocalTFModelV2 dcvrLocalTFModel) {
        this.dcvrLocalTFModel = dcvrLocalTFModel;
    }

    public IModel getDCvrModel() {
        return this.dCvrModel;
    }

    public void setDCvrModel(IModel dCvrModel) {
        this.dCvrModel = dCvrModel;
    }

    public TFServingClient getDcvrServingClient() {
        return this.dcvrServingClient;
    }

    public void setDcvrServingClient(TFServingClient dcvrServingClient) {
        this.dcvrServingClient = dcvrServingClient;
    }

    public DCVRv3() {
    }

    public DCVRv3(IModel coderModel, LocalTFModelV2 dcvrLocalTFModel) {
        this.coderModel = coderModel;
        this.dcvrLocalTFModel = dcvrLocalTFModel;
    }

    public <T> Map<PredictResultType, Map<T, Double>> predictDCvr(Map<T, FeatureMapDo> featureMap) throws Exception {
        HashMap<PredictResultType, Map<T, Double>> ret = new HashMap<PredictResultType, Map<T, Double>>();
        Map<T, Double> dcvrMap = this.dCvrModel.predictsNew(featureMap);
        if (AssertUtil.isAllNotEmpty((Object[])new Object[]{dcvrMap})) {
            ret.put(PredictResultType.TRADE_DCVR, dcvrMap);
        } else {
            ret = null;
        }
        return ret;
    }

    public <T> Map<PredictResultType, Map<T, Double>> predictDCvrWithTF(Map<T, FeatureMapDo> featureMap) throws Exception {
        HashMap<PredictResultType, Map<T, Double>> ret = new HashMap<PredictResultType, Map<T, Double>>();
        Map<T, Double> dcvrMap = this.coderModel.predictWithTFNew(featureMap, this.dcvrServingClient);
        if (AssertUtil.isAllNotEmpty((Object[])new Object[]{dcvrMap})) {
            ret.put(PredictResultType.TRADE_DCVR, dcvrMap);
        } else {
            logger.warn(this.coderModel.getModelId() + ": trade_dcvr fusing");
            dcvrMap = this.dCvrModel.predictsNew(featureMap);
            if (AssertUtil.isAllNotEmpty((Object[])new Object[]{dcvrMap})) {
                ret.put(PredictResultType.TRADE_DCVR, dcvrMap);
            } else {
                ret = null;
            }
        }
        return ret;
    }

    public <T> Map<PredictResultType, Map<T, Double>> predictDCvrWithLocalTF(Map<T, FeatureMapDo> featureMap) throws Exception {
        HashMap<PredictResultType, Map<T, Double>> ret = new HashMap<PredictResultType, Map<T, Double>>();
        Map<T, Double> dcvrMap = this.coderModel.predictWithLocalTFV3(featureMap, this.dcvrLocalTFModel);
        if (AssertUtil.isAllNotEmpty((Object[])new Object[]{dcvrMap})) {
            ret.put(PredictResultType.TRADE_DCVR, dcvrMap);
        } else {
            logger.warn(this.coderModel.getModelId() + ": trade_dcvr fusing");
            if (this.dCvrModel != null) {
                dcvrMap = this.dCvrModel.predictsNew(featureMap);
            }
            if (AssertUtil.isAllNotEmpty((Object[])new Object[]{dcvrMap})) {
                ret.put(PredictResultType.TRADE_DCVR, dcvrMap);
            } else {
                ret = null;
            }
        }
        return ret;
    }

    public <T> Map<PredictResultType, Map<T, Double>> predictDCvrAndTF(Map<T, FeatureMapDo> featureMap) throws Exception {
        if (this.dcvrServingClient != null) {
            logger.info("dcvrServingClient");
            return this.predictDCvrWithTF(featureMap);
        }
        if (this.dcvrLocalTFModel != null) {
            logger.info("dcvrLocalTFModel");
            return this.predictDCvrWithLocalTF(featureMap);
        }
        return this.predictDCvr(featureMap);
    }

    public <T> Map<PredictResultType, Map<T, Double>> predictOptDCvr(Map<T, FeatureMapDo> featureMap) throws Exception {
        HashMap<PredictResultType, Map<T, Double>> ret = new HashMap<PredictResultType, Map<T, Double>>();
        Map<T, Double> dcvrMap = this.dCvrModel.predictsNew(featureMap);
        if (AssertUtil.isAllNotEmpty((Object[])new Object[]{dcvrMap})) {
            ret.put(PredictResultType.OPT_DCVR, dcvrMap);
        } else {
            ret = null;
        }
        return ret;
    }

    public <T> Map<PredictResultType, Map<T, Double>> predictOptDCvrWithTF(Map<T, FeatureMapDo> featureMap) throws Exception {
        HashMap<PredictResultType, Map<T, Double>> ret = new HashMap<PredictResultType, Map<T, Double>>();
        Map<T, Double> dcvrMap = this.coderModel.predictWithTFNew(featureMap, this.dcvrServingClient);
        if (AssertUtil.isAllNotEmpty((Object[])new Object[]{dcvrMap})) {
            ret.put(PredictResultType.OPT_DCVR, dcvrMap);
        } else {
            logger.warn(this.coderModel.getModelId() + ": opt_dcvr fusing");
            dcvrMap = this.dCvrModel.predictsNew(featureMap);
            if (AssertUtil.isAllNotEmpty((Object[])new Object[]{dcvrMap})) {
                ret.put(PredictResultType.OPT_DCVR, dcvrMap);
            } else {
                ret = null;
            }
        }
        return ret;
    }

    public <T> Map<PredictResultType, Map<T, Double>> predictOptDCvrWithLocalTF(Map<T, FeatureMapDo> featureMap) throws Exception {
        HashMap<PredictResultType, Map<T, Double>> ret = new HashMap<PredictResultType, Map<T, Double>>();
        Map<T, Double> dcvrMap = this.coderModel.predictWithLocalTFV2(featureMap, this.dcvrLocalTFModel);
        if (AssertUtil.isAllNotEmpty((Object[])new Object[]{dcvrMap})) {
            ret.put(PredictResultType.OPT_DCVR, dcvrMap);
        } else {
            logger.warn(this.coderModel.getModelId() + ": opt_dcvr fusing");
            if (this.dCvrModel != null) {
                dcvrMap = this.dCvrModel.predictsNew(featureMap);
            }
            if (AssertUtil.isAllNotEmpty((Object[])new Object[]{dcvrMap})) {
                ret.put(PredictResultType.OPT_DCVR, dcvrMap);
            } else {
                ret = null;
            }
        }
        return ret;
    }

    public <T> Map<PredictResultType, Map<T, Double>> predictOptDCvrAndTF(Map<T, FeatureMapDo> featureMap) throws Exception {
        if (this.dcvrServingClient != null) {
            return this.predictOptDCvrWithTF(featureMap);
        }
        if (this.dcvrLocalTFModel != null) {
            return this.predictOptDCvrWithLocalTF(featureMap);
        }
        return this.predictOptDCvr(featureMap);
    }

    public <T> Map<PredictResultType, Map<T, Double>> predictWhDCvr(Map<T, FeatureMapDo> featureMap) throws Exception {
        HashMap<PredictResultType, Map<T, Double>> ret = new HashMap<PredictResultType, Map<T, Double>>();
        Map<T, Double> dcvrMap = this.dCvrModel.predictsNew(featureMap);
        if (AssertUtil.isAllNotEmpty((Object[])new Object[]{dcvrMap})) {
            ret.put(PredictResultType.WH_DCVR, dcvrMap);
        } else {
            ret = null;
        }
        return ret;
    }

    public <T> Map<PredictResultType, Map<T, Double>> predictWhDCvrWithTF(Map<T, FeatureMapDo> featureMap) throws Exception {
        HashMap<PredictResultType, Map<T, Double>> ret = new HashMap<PredictResultType, Map<T, Double>>();
        Map<T, Double> dcvrMap = this.coderModel.predictWithTFNew(featureMap, this.dcvrServingClient);
        if (AssertUtil.isAllNotEmpty((Object[])new Object[]{dcvrMap})) {
            ret.put(PredictResultType.WH_DCVR, dcvrMap);
        } else {
            logger.warn(this.coderModel.getModelId() + ": \u4ee3\u6263trade_dcvr fusing");
            dcvrMap = this.dCvrModel.predictsNew(featureMap);
            if (AssertUtil.isAllNotEmpty((Object[])new Object[]{dcvrMap})) {
                ret.put(PredictResultType.WH_DCVR, dcvrMap);
            } else {
                ret = null;
            }
        }
        return ret;
    }

    public <T> Map<PredictResultType, Map<T, Double>> predictWhDCvrWithLocalTF(Map<T, FeatureMapDo> featureMap) throws Exception {
        HashMap<PredictResultType, Map<T, Double>> ret = new HashMap<PredictResultType, Map<T, Double>>();
        Map<T, Double> dcvrMap = this.coderModel.predictWithLocalTFV3(featureMap, this.dcvrLocalTFModel);
        if (AssertUtil.isAllNotEmpty((Object[])new Object[]{dcvrMap})) {
            ret.put(PredictResultType.WH_DCVR, dcvrMap);
        } else {
            logger.warn(this.coderModel.getModelId() + ": \u4ee3\u6263trade_dcvr fusing");
            if (this.dCvrModel != null) {
                dcvrMap = this.dCvrModel.predictsNew(featureMap);
            }
            if (AssertUtil.isAllNotEmpty((Object[])new Object[]{dcvrMap})) {
                ret.put(PredictResultType.WH_DCVR, dcvrMap);
            } else {
                ret = null;
            }
        }
        return ret;
    }

    public <T> Map<PredictResultType, Map<T, Double>> predictWhDCvrAndTF(Map<T, FeatureMapDo> featureMap) throws Exception {
        if (this.dcvrServingClient != null) {
            logger.info("\u4ee3\u6263dcvrServingClient");
            return this.predictWhDCvrWithTF(featureMap);
        }
        if (this.dcvrLocalTFModel != null) {
            logger.info("\u4ee3\u6263dcvrLocalTFModel");
            return this.predictWhDCvrWithLocalTF(featureMap);
        }
        return this.predictWhDCvr(featureMap);
    }

    public <T> Map<PredictResultType, Map<T, Double>> predictKesuTradeDCvr(Map<T, FeatureMapDo> featureMap) throws Exception {
        HashMap<PredictResultType, Map<T, Double>> ret = new HashMap<PredictResultType, Map<T, Double>>();
        Map<T, Double> dcvrMap = this.dCvrModel.predictsNew(featureMap);
        if (AssertUtil.isAllNotEmpty((Object[])new Object[]{dcvrMap})) {
            ret.put(PredictResultType.KESU_TRADE_DCVR, dcvrMap);
        } else {
            ret = null;
        }
        return ret;
    }

    public <T> Map<PredictResultType, Map<T, Double>> predictKesuTradeDCvrWithTF(Map<T, FeatureMapDo> featureMap) throws Exception {
        HashMap<PredictResultType, Map<T, Double>> ret = new HashMap<PredictResultType, Map<T, Double>>();
        Map<T, Double> dcvrMap = this.coderModel.predictWithTFNew(featureMap, this.dcvrServingClient);
        if (AssertUtil.isAllNotEmpty((Object[])new Object[]{dcvrMap})) {
            ret.put(PredictResultType.KESU_TRADE_DCVR, dcvrMap);
        } else {
            logger.warn(this.coderModel.getModelId() + ": \u5ba2\u8bc9Trade_dcvr fusing");
            dcvrMap = this.dCvrModel.predictsNew(featureMap);
            if (AssertUtil.isAllNotEmpty((Object[])new Object[]{dcvrMap})) {
                ret.put(PredictResultType.KESU_TRADE_DCVR, dcvrMap);
            } else {
                ret = null;
            }
        }
        return ret;
    }

    public <T> Map<PredictResultType, Map<T, Double>> predictKesuTradeDCvrWithLocalTF(Map<T, FeatureMapDo> featureMap) throws Exception {
        HashMap<PredictResultType, Map<T, Double>> ret = new HashMap<PredictResultType, Map<T, Double>>();
        Map<T, Double> dcvrMap = this.coderModel.predictWithLocalTFV3(featureMap, this.dcvrLocalTFModel);
        if (AssertUtil.isAllNotEmpty((Object[])new Object[]{dcvrMap})) {
            ret.put(PredictResultType.KESU_TRADE_DCVR, dcvrMap);
        } else {
            logger.warn(this.coderModel.getModelId() + ": \u5ba2\u8bc9Trade_dcvr fusing");
            if (this.dCvrModel != null) {
                dcvrMap = this.dCvrModel.predictsNew(featureMap);
            }
            if (AssertUtil.isAllNotEmpty((Object[])new Object[]{dcvrMap})) {
                ret.put(PredictResultType.KESU_TRADE_DCVR, dcvrMap);
            } else {
                ret = null;
            }
        }
        return ret;
    }

    public <T> Map<PredictResultType, Map<T, Double>> predictKesuTradeDCvrAndTF(Map<T, FeatureMapDo> featureMap) throws Exception {
        if (this.dcvrServingClient != null) {
            logger.info("\u5ba2\u8bc9tradeDcvrServingClient");
            return this.predictKesuTradeDCvrWithTF(featureMap);
        }
        if (this.dcvrLocalTFModel != null) {
            logger.info("\u5ba2\u8bc9tradeDcvrLocalTFModel");
            return this.predictKesuTradeDCvrWithLocalTF(featureMap);
        }
        return this.predictKesuTradeDCvr(featureMap);
    }

    public <T> Map<PredictResultType, Map<T, Double>> predictKesuPrivateDCvr(Map<T, FeatureMapDo> featureMap) throws Exception {
        HashMap<PredictResultType, Map<T, Double>> ret = new HashMap<PredictResultType, Map<T, Double>>();
        Map<T, Double> dcvrMap = this.dCvrModel.predictsNew(featureMap);
        if (AssertUtil.isAllNotEmpty((Object[])new Object[]{dcvrMap})) {
            ret.put(PredictResultType.KESU_PRIVATE_DCVR, dcvrMap);
        } else {
            ret = null;
        }
        return ret;
    }

    public <T> Map<PredictResultType, Map<T, Double>> predictKesuPrivateDCvrWithTF(Map<T, FeatureMapDo> featureMap) throws Exception {
        HashMap<PredictResultType, Map<T, Double>> ret = new HashMap<PredictResultType, Map<T, Double>>();
        Map<T, Double> dcvrMap = this.coderModel.predictWithTFNew(featureMap, this.dcvrServingClient);
        if (AssertUtil.isAllNotEmpty((Object[])new Object[]{dcvrMap})) {
            ret.put(PredictResultType.KESU_PRIVATE_DCVR, dcvrMap);
        } else {
            logger.warn(this.coderModel.getModelId() + ": \u5ba2\u8bc9private_dcvr fusing");
            dcvrMap = this.dCvrModel.predictsNew(featureMap);
            if (AssertUtil.isAllNotEmpty((Object[])new Object[]{dcvrMap})) {
                ret.put(PredictResultType.KESU_PRIVATE_DCVR, dcvrMap);
            } else {
                ret = null;
            }
        }
        return ret;
    }

    public <T> Map<PredictResultType, Map<T, Double>> predictKesuPrivateDCvrWithLocalTF(Map<T, FeatureMapDo> featureMap) throws Exception {
        HashMap<PredictResultType, Map<T, Double>> ret = new HashMap<PredictResultType, Map<T, Double>>();
        Map<T, Double> dcvrMap = this.coderModel.predictWithLocalTFV3(featureMap, this.dcvrLocalTFModel);
        if (AssertUtil.isAllNotEmpty((Object[])new Object[]{dcvrMap})) {
            ret.put(PredictResultType.KESU_PRIVATE_DCVR, dcvrMap);
        } else {
            logger.warn(this.coderModel.getModelId() + ": \u5ba2\u8bc9private_dcvr fusing");
            if (this.dCvrModel != null) {
                dcvrMap = this.dCvrModel.predictsNew(featureMap);
            }
            if (AssertUtil.isAllNotEmpty((Object[])new Object[]{dcvrMap})) {
                ret.put(PredictResultType.KESU_PRIVATE_DCVR, dcvrMap);
            } else {
                ret = null;
            }
        }
        return ret;
    }

    public <T> Map<PredictResultType, Map<T, Double>> predictKesuPrivateDCvrAndTF(Map<T, FeatureMapDo> featureMap) throws Exception {
        if (this.dcvrServingClient != null) {
            logger.info("\u5ba2\u8bc9privateDcvrServingClient");
            return this.predictKesuPrivateDCvrWithTF(featureMap);
        }
        if (this.dcvrLocalTFModel != null) {
            logger.info("\u5ba2\u8bc9privateDcvrLocalTFModel");
            return this.predictKesuPrivateDCvrWithLocalTF(featureMap);
        }
        return this.predictKesuPrivateDCvr(featureMap);
    }

    public <T> Map<PredictResultType, Map<T, Double>> predictSignDCvr(Map<T, FeatureMapDo> featureMap) throws Exception {
        HashMap<PredictResultType, Map<T, Double>> ret = new HashMap<PredictResultType, Map<T, Double>>();
        Map<T, Double> dcvrMap = this.dCvrModel.predictsNew(featureMap);
        if (AssertUtil.isAllNotEmpty((Object[])new Object[]{dcvrMap})) {
            ret.put(PredictResultType.SIGN_DCVR, dcvrMap);
        } else {
            ret = null;
        }
        return ret;
    }

    public <T> Map<PredictResultType, Map<T, Double>> predictSignDCvrWithTF(Map<T, FeatureMapDo> featureMap) throws Exception {
        HashMap<PredictResultType, Map<T, Double>> ret = new HashMap<PredictResultType, Map<T, Double>>();
        Map<T, Double> dcvrMap = this.coderModel.predictWithTFNew(featureMap, this.dcvrServingClient);
        if (AssertUtil.isAllNotEmpty((Object[])new Object[]{dcvrMap})) {
            ret.put(PredictResultType.SIGN_DCVR, dcvrMap);
        } else {
            logger.warn(this.coderModel.getModelId() + ": \u7b7e\u6536sign_dcvr fusing");
            dcvrMap = this.dCvrModel.predictsNew(featureMap);
            if (AssertUtil.isAllNotEmpty((Object[])new Object[]{dcvrMap})) {
                ret.put(PredictResultType.SIGN_DCVR, dcvrMap);
            } else {
                ret = null;
            }
        }
        return ret;
    }

    public <T> Map<PredictResultType, Map<T, Double>> predictSignDCvrWithLocalTF(Map<T, FeatureMapDo> featureMap) throws Exception {
        HashMap<PredictResultType, Map<T, Double>> ret = new HashMap<PredictResultType, Map<T, Double>>();
        Map<T, Double> dcvrMap = this.coderModel.predictWithLocalTFV3(featureMap, this.dcvrLocalTFModel);
        if (AssertUtil.isAllNotEmpty((Object[])new Object[]{dcvrMap})) {
            ret.put(PredictResultType.SIGN_DCVR, dcvrMap);
        } else {
            logger.warn(this.coderModel.getModelId() + ": \u7b7e\u6536sign_dcvr fusing");
            if (this.dCvrModel != null) {
                dcvrMap = this.dCvrModel.predictsNew(featureMap);
            }
            if (AssertUtil.isAllNotEmpty((Object[])new Object[]{dcvrMap})) {
                ret.put(PredictResultType.SIGN_DCVR, dcvrMap);
            } else {
                ret = null;
            }
        }
        return ret;
    }

    public <T> Map<PredictResultType, Map<T, Double>> predictSignDCvrAndTF(Map<T, FeatureMapDo> featureMap) throws Exception {
        if (this.dcvrServingClient != null) {
            logger.info("\u7b7e\u6536SignDcvrServingClient");
            return this.predictSignDCvrWithTF(featureMap);
        }
        if (this.dcvrLocalTFModel != null) {
            logger.info("\u7b7e\u6536SignDcvrLocalTFModel");
            return this.predictSignDCvrWithLocalTF(featureMap);
        }
        return this.predictSignDCvr(featureMap);
    }
}

