/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.alg.model;

import cn.com.duiba.nezha.alg.common.util.AssertUtil;
import cn.com.duiba.nezha.alg.feature.coder.FeatureNewCoder2;
import cn.com.duiba.nezha.alg.feature.type.FeatureBaseType;
import cn.com.duiba.nezha.alg.feature.vo.FeatureCode;
import cn.com.duiba.nezha.alg.feature.vo.FeatureMapDo;
import cn.com.duiba.nezha.alg.model.IModel;
import cn.com.duiba.nezha.alg.model.tf.LocalTFModel;
import cn.com.duiba.nezha.alg.model.tf.TFServingClient;
import cn.com.duiba.nezha.alg.model.util.CollectionUtil;
import cn.com.duiba.nezha.alg.model.vo.ParamsDo;
import com.alibaba.fastjson.JSON;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CODER2
implements Serializable,
IModel {
    private static final Logger logger = LoggerFactory.getLogger(CODER2.class);
    private String modelId;
    private String updateTime;
    private ParamsDo paramsDo;
    private Map<String, Map<Integer, Integer>> coderMap;
    private int FBT_MAX_SIZE = 64;
    private int PB_MAX_SIZE = 128;
    private List<FeatureBaseType> featureBaseType = new ArrayList<FeatureBaseType>(this.FBT_MAX_SIZE);

    public void setFeatureBaseType(List<FeatureBaseType> featureBaseType) {
        this.featureBaseType = featureBaseType;
    }

    public List<FeatureBaseType> getFeatureBaseType() {
        return this.featureBaseType;
    }

    public void setModelId(String modelId) {
        this.modelId = modelId;
    }

    @Override
    public String getModelId() {
        return this.modelId;
    }

    public void setUpdateTime(String updateTime) {
        this.updateTime = updateTime;
    }

    public String getUpdateTime() {
        return this.updateTime;
    }

    public void setParamsDo(ParamsDo paramsDo) {
        this.paramsDo = paramsDo;
    }

    public ParamsDo getParamsDo() {
        return this.paramsDo;
    }

    public Map<String, Map<Integer, Integer>> getCoderMap() {
        return this.coderMap;
    }

    public void setCoderMap(Map<String, Map<Integer, Integer>> coderMap) {
        this.coderMap = coderMap;
    }

    @Override
    public Double predict(Map<String, String> featureMap) throws Exception {
        Double ret = null;
        return ret;
    }

    public Double predict(FeatureMapDo featureMap) throws Exception {
        Double ret = null;
        return ret;
    }

    public String getCode(Map<String, String> codeMap) throws Exception {
        ConcurrentHashMap tmpCoderCache = new ConcurrentHashMap();
        Map retMap = FeatureNewCoder2.codeOfEachFieldWithSeq(this.getFeatureBaseType(), codeMap, null, tmpCoderCache);
        return this.getCodeWithSeq(retMap);
    }

    public String getCodeWithSeq(Map<String, FeatureCode> codeMap) throws Exception {
        String ret = null;
        try {
            ArrayList<String> fieldStringList = new ArrayList<String>();
            ConcurrentHashMap tmpCoderStrCache = new ConcurrentHashMap();
            for (FeatureBaseType featureBaseType : this.featureBaseType) {
                String fieldName = featureBaseType.getName();
                int fieldType = featureBaseType.getCodeType();
                FeatureCode sparceCode = codeMap.get(fieldName);
                String featureValue = sparceCode.featureStr;
                String fCodeString = null;
                if (tmpCoderStrCache.get(fieldName) == null) {
                    tmpCoderStrCache.put(fieldName, new ConcurrentHashMap());
                }
                if (((Map)tmpCoderStrCache.get(fieldName)).get(featureValue) == null) {
                    String tmpfCodeString = this.getCoderString(sparceCode, fieldName, fieldType);
                    ((Map)tmpCoderStrCache.get(fieldName)).put(featureValue, tmpfCodeString);
                }
                fCodeString = (String)((Map)tmpCoderStrCache.get(fieldName)).get(featureValue);
                String fieldString = fieldName + ":" + fCodeString;
                fieldStringList.add(fieldString);
            }
            ret = CollectionUtil.toString(fieldStringList, ";");
        }
        catch (Exception e) {
            logger.warn("getCode is invalid ", (Throwable)e);
        }
        return ret;
    }

    public String getCoderString(FeatureCode sparceCode, String fieldName, int fieldType) throws Exception {
        String fCodeString = null;
        if (fieldType != 41) {
            ArrayList<Integer> fCodeId = new ArrayList<Integer>();
            Integer filedDefaultValue = this.coderMap.get(fieldName).getOrDefault(0, 0);
            for (int i = 0; i < sparceCode.indices.length; ++i) {
                Integer codeDense = this.coderMap.get(fieldName).getOrDefault(sparceCode.indices[i], filedDefaultValue);
                fCodeId.add(codeDense);
            }
            fCodeString = CollectionUtil.toString(fCodeId, ",");
        } else {
            fCodeString = CollectionUtil.toString(sparceCode.values, ",");
        }
        return fCodeString;
    }

    @Override
    public List<Float> getParam(Map<String, String> featureMap) throws Exception {
        List<Float> ret = null;
        return ret;
    }

    @Override
    public List<Float> getParam(FeatureMapDo featureMap) throws Exception {
        List<Float> ret = null;
        return ret;
    }

    @Override
    public <T> Map<T, Double> predicts(Map<T, Map<String, String>> featureMap) throws Exception {
        HashMap ret = new HashMap(this.PB_MAX_SIZE);
        return ret;
    }

    @Override
    public <T> Map<T, Double> predictsNew(Map<T, FeatureMapDo> featureMap) throws Exception {
        HashMap ret = new HashMap(this.PB_MAX_SIZE);
        return ret;
    }

    public <T> Map<T, String> getCodesNewWithSeq(Map<T, FeatureMapDo> featureMap) throws Exception {
        HashMap ret = new HashMap(this.PB_MAX_SIZE);
        if (AssertUtil.isNotEmpty(featureMap)) {
            ConcurrentHashMap tmpCoderCache = new ConcurrentHashMap();
            Map codeMap = FeatureNewCoder2.codeOfEachFieldWithSeq(this.getFeatureBaseType(), featureMap, tmpCoderCache);
            for (Map.Entry entry : codeMap.entrySet()) {
                ret.put(entry.getKey(), this.getCodeWithSeq((Map)entry.getValue()));
            }
        }
        if (AssertUtil.isEmpty(ret)) {
            logger.warn("getCodes is invalid, featureMap is null or {}");
        }
        return ret;
    }

    @Override
    public <T> Map<T, Double> predictWithTF(Map<T, Map<String, String>> featureMap, TFServingClient tfServingClient) throws Exception {
        Map<T, Double> ret = null;
        return ret;
    }

    @Override
    public <T> Map<T, Double> predictWithTFNew(Map<T, FeatureMapDo> featureMap, TFServingClient tfServingClient) throws Exception {
        Map<T, Double> ret = null;
        if (tfServingClient == null) {
            ret = null;
        } else {
            try {
                ret = tfServingClient.predictString(this.getCodesNewWithSeq(featureMap));
            }
            catch (Exception e) {
                e.printStackTrace();
                String logInfo = tfServingClient.modelName + " predictWithTF warn ";
                logger.warn(logInfo + e);
                ret = null;
            }
        }
        return ret;
    }

    @Override
    public <T> Map<T, Double> predictWithLocalTF(Map<T, Map<String, String>> featureMap, LocalTFModel localTFModel) throws Exception {
        Map<T, Double> ret = null;
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> Map<T, Double> predictWithLocalTFNew(Map<T, FeatureMapDo> featureMap, LocalTFModel localTFModel) throws Exception {
        Map<T, Double> ret = null;
        try {
            if (AssertUtil.isNotEmpty(featureMap)) {
                Map<T, String> fMap;
                if (localTFModel == null) {
                    logger.info("predictWithLocalTF,local model is null");
                }
                if (AssertUtil.isEmpty(fMap = this.getCodesNewWithSeq(featureMap))) {
                    logger.info("predictWithLocalTF,feature is null");
                }
                ret = localTFModel.predictStr(fMap);
            }
        }
        catch (Exception e) {
            String logInfo = "predictWithTF warn ";
            logger.info(logInfo, (Throwable)e);
            ret = this.predictsNew(featureMap);
        }
        return ret;
    }

    public static void main(String[] args) {
        CODER2 coder = new CODER2();
        HashMap<String, Map<Integer, Integer>> map = new HashMap<String, Map<Integer, Integer>>();
        HashMap<Integer, Integer> map1 = new HashMap<Integer, Integer>();
        map1.put(0, 999);
        map1.put(101, 1001);
        map1.put(102, 1002);
        map1.put(103, 1003);
        map1.put(104, 1004);
        map1.put(105, 1005);
        map.put("f1001", map1);
        HashMap<Integer, Integer> map2 = new HashMap<Integer, Integer>();
        map2.put(0, 999);
        map2.put(1, 2000);
        map2.put(2, 2002);
        map2.put(3, 2003);
        map2.put(4, 2004);
        map.put("f1002", map2);
        FeatureBaseType featureBaseType1 = new FeatureBaseType();
        featureBaseType1.setCodeType(11);
        featureBaseType1.setName("f1001");
        featureBaseType1.setDenseLen(10000);
        featureBaseType1.setSubLen(1000000);
        featureBaseType1.setHashNums(1);
        featureBaseType1.setSeq(",");
        FeatureBaseType featureBaseType2 = new FeatureBaseType();
        featureBaseType2.setCodeType(41);
        featureBaseType2.setName("f1002");
        featureBaseType2.setDenseLen(10000);
        featureBaseType2.setSubLen(4);
        featureBaseType2.setHashNums(1);
        featureBaseType2.setSeq(",");
        List<FeatureBaseType> list = Arrays.asList(featureBaseType1);
        coder.setCoderMap(map);
        coder.setFeatureBaseType(list);
        HashMap<String, String> featureMap = new HashMap<String, String>();
        featureMap.put("f1001", "100,104");
        featureMap.put("f1002", "0.9,1.0,1.1,1.34");
        HashMap<String, FeatureMapDo> featureMapDoMap = new HashMap<String, FeatureMapDo>();
        FeatureMapDo featureMapDo = new FeatureMapDo();
        featureMapDo.setStaticFeatureMap(featureMap);
        featureMapDoMap.put("s1", featureMapDo);
        try {
            System.out.println(JSON.toJSONString(coder.getCodesNewWithSeq(featureMapDoMap)));
            featureMap.put("f1001", "100,104,105");
            System.out.println(JSON.toJSONString(coder.getCodesNewWithSeq(featureMapDoMap)));
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }
}

