/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.alg.model;

import cn.com.duiba.nezha.alg.common.util.AssertUtil;
import cn.com.duiba.nezha.alg.feature.vo.FeatureMapDo;
import cn.com.duiba.nezha.alg.model.IModel;
import cn.com.duiba.nezha.alg.model.enums.MutModelType;
import cn.com.duiba.nezha.alg.model.enums.PredictResultType;
import cn.com.duiba.nezha.alg.model.tf.OneLocalTfModel;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NormalModel
implements Serializable {
    private static final long serialVersionUID = 22348095L;
    private static final Logger logger = LoggerFactory.getLogger(NormalModel.class);
    private Integer algType;
    private IModel ctrFMModel;
    private IModel cvrFMModel;
    private IModel ctrFusingFMModel;
    private IModel cvrFusingFMModel;
    private OneLocalTfModel ctrTfModel;
    private OneLocalTfModel cvrTfModel;
    private MutModelType mutModelType;

    public <T> Map<PredictResultType, Map<T, Double>> predict(Map<T, FeatureMapDo> featureMap) throws Exception {
        HashMap<PredictResultType, Map<T, Double>> result = new HashMap<PredictResultType, Map<T, Double>>();
        Map<T, Double> ctrMap = this.predictCtr(featureMap);
        Map<T, Double> cvrMap = this.predictCvr(featureMap);
        if (AssertUtil.isAllNotEmpty((Object[])new Object[]{ctrMap, cvrMap})) {
            result.put(PredictResultType.CTR, ctrMap);
            result.put(PredictResultType.CVR, cvrMap);
        } else {
            result = null;
        }
        return result;
    }

    private <T> Map<T, Double> predictCtr(Map<T, FeatureMapDo> featureMap) throws Exception {
        Map<T, Double> result;
        try {
            if (this.ctrTfModel != null) {
                Map<T, Map<String, String>> normalFeatureMap = this.processFeatureMap(featureMap);
                result = this.ctrTfModel.predict(normalFeatureMap);
            } else {
                result = this.ctrFMModel.predictsNew(featureMap);
            }
        }
        catch (Exception e) {
            logger.warn("ctr fusing.. alg type = " + this.algType, (Throwable)e);
            result = this.ctrFusingFMModel.predictsNew(featureMap);
        }
        return result;
    }

    private <T> Map<T, Double> predictCvr(Map<T, FeatureMapDo> featureMap) throws Exception {
        Map<T, Double> result;
        try {
            if (this.cvrTfModel != null) {
                Map<T, Map<String, String>> normalFeatureMap = this.processFeatureMap(featureMap);
                result = this.cvrTfModel.predict(normalFeatureMap);
            } else {
                result = this.cvrFMModel.predictsNew(featureMap);
            }
        }
        catch (Exception e) {
            logger.warn("cvr fusing.. alg type = " + this.algType, (Throwable)e);
            result = this.cvrFusingFMModel.predictsNew(featureMap);
        }
        return result;
    }

    private <T> Map<T, Map<String, String>> processFeatureMap(Map<T, FeatureMapDo> featureMap) {
        HashMap<T, Map> normalFeatureMap = new HashMap<T, Map>();
        for (Map.Entry<T, FeatureMapDo> featureMapDoEntry : featureMap.entrySet()) {
            normalFeatureMap.put(featureMapDoEntry.getKey(), featureMapDoEntry.getValue().getFeatureMap());
        }
        return normalFeatureMap;
    }

    public NormalModel(Integer algType, IModel ctrFMModel, IModel cvrFMModel, IModel ctrFusingFMModel, IModel cvrFusingFMModel, OneLocalTfModel ctrTfModel, OneLocalTfModel cvrTfModel, MutModelType mutModelType) {
        this.algType = algType;
        this.ctrFMModel = ctrFMModel;
        this.cvrFMModel = cvrFMModel;
        this.ctrFusingFMModel = ctrFusingFMModel;
        this.cvrFusingFMModel = cvrFusingFMModel;
        this.ctrTfModel = ctrTfModel;
        this.cvrTfModel = cvrTfModel;
        this.mutModelType = mutModelType;
    }

    public Integer getAlgType() {
        return this.algType;
    }

    public IModel getCtrFMModel() {
        return this.ctrFMModel;
    }

    public IModel getCvrFMModel() {
        return this.cvrFMModel;
    }

    public IModel getCtrFusingFMModel() {
        return this.ctrFusingFMModel;
    }

    public IModel getCvrFusingFMModel() {
        return this.cvrFusingFMModel;
    }

    public OneLocalTfModel getCtrTfModel() {
        return this.ctrTfModel;
    }

    public OneLocalTfModel getCvrTfModel() {
        return this.cvrTfModel;
    }

    public MutModelType getMutModelType() {
        return this.mutModelType;
    }

    public void setAlgType(Integer algType) {
        this.algType = algType;
    }

    public void setCtrFMModel(IModel ctrFMModel) {
        this.ctrFMModel = ctrFMModel;
    }

    public void setCvrFMModel(IModel cvrFMModel) {
        this.cvrFMModel = cvrFMModel;
    }

    public void setCtrFusingFMModel(IModel ctrFusingFMModel) {
        this.ctrFusingFMModel = ctrFusingFMModel;
    }

    public void setCvrFusingFMModel(IModel cvrFusingFMModel) {
        this.cvrFusingFMModel = cvrFusingFMModel;
    }

    public void setCtrTfModel(OneLocalTfModel ctrTfModel) {
        this.ctrTfModel = ctrTfModel;
    }

    public void setCvrTfModel(OneLocalTfModel cvrTfModel) {
        this.cvrTfModel = cvrTfModel;
    }

    public void setMutModelType(MutModelType mutModelType) {
        this.mutModelType = mutModelType;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof NormalModel)) {
            return false;
        }
        NormalModel other = (NormalModel)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$algType = this.getAlgType();
        Integer other$algType = other.getAlgType();
        if (this$algType == null ? other$algType != null : !((Object)this$algType).equals(other$algType)) {
            return false;
        }
        IModel this$ctrFMModel = this.getCtrFMModel();
        IModel other$ctrFMModel = other.getCtrFMModel();
        if (this$ctrFMModel == null ? other$ctrFMModel != null : !this$ctrFMModel.equals(other$ctrFMModel)) {
            return false;
        }
        IModel this$cvrFMModel = this.getCvrFMModel();
        IModel other$cvrFMModel = other.getCvrFMModel();
        if (this$cvrFMModel == null ? other$cvrFMModel != null : !this$cvrFMModel.equals(other$cvrFMModel)) {
            return false;
        }
        IModel this$ctrFusingFMModel = this.getCtrFusingFMModel();
        IModel other$ctrFusingFMModel = other.getCtrFusingFMModel();
        if (this$ctrFusingFMModel == null ? other$ctrFusingFMModel != null : !this$ctrFusingFMModel.equals(other$ctrFusingFMModel)) {
            return false;
        }
        IModel this$cvrFusingFMModel = this.getCvrFusingFMModel();
        IModel other$cvrFusingFMModel = other.getCvrFusingFMModel();
        if (this$cvrFusingFMModel == null ? other$cvrFusingFMModel != null : !this$cvrFusingFMModel.equals(other$cvrFusingFMModel)) {
            return false;
        }
        OneLocalTfModel this$ctrTfModel = this.getCtrTfModel();
        OneLocalTfModel other$ctrTfModel = other.getCtrTfModel();
        if (this$ctrTfModel == null ? other$ctrTfModel != null : !this$ctrTfModel.equals(other$ctrTfModel)) {
            return false;
        }
        OneLocalTfModel this$cvrTfModel = this.getCvrTfModel();
        OneLocalTfModel other$cvrTfModel = other.getCvrTfModel();
        if (this$cvrTfModel == null ? other$cvrTfModel != null : !this$cvrTfModel.equals(other$cvrTfModel)) {
            return false;
        }
        MutModelType this$mutModelType = this.getMutModelType();
        MutModelType other$mutModelType = other.getMutModelType();
        return !(this$mutModelType == null ? other$mutModelType != null : !((Object)((Object)this$mutModelType)).equals((Object)other$mutModelType));
    }

    protected boolean canEqual(Object other) {
        return other instanceof NormalModel;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $algType = this.getAlgType();
        result = result * 59 + ($algType == null ? 43 : ((Object)$algType).hashCode());
        IModel $ctrFMModel = this.getCtrFMModel();
        result = result * 59 + ($ctrFMModel == null ? 43 : $ctrFMModel.hashCode());
        IModel $cvrFMModel = this.getCvrFMModel();
        result = result * 59 + ($cvrFMModel == null ? 43 : $cvrFMModel.hashCode());
        IModel $ctrFusingFMModel = this.getCtrFusingFMModel();
        result = result * 59 + ($ctrFusingFMModel == null ? 43 : $ctrFusingFMModel.hashCode());
        IModel $cvrFusingFMModel = this.getCvrFusingFMModel();
        result = result * 59 + ($cvrFusingFMModel == null ? 43 : $cvrFusingFMModel.hashCode());
        OneLocalTfModel $ctrTfModel = this.getCtrTfModel();
        result = result * 59 + ($ctrTfModel == null ? 43 : $ctrTfModel.hashCode());
        OneLocalTfModel $cvrTfModel = this.getCvrTfModel();
        result = result * 59 + ($cvrTfModel == null ? 43 : $cvrTfModel.hashCode());
        MutModelType $mutModelType = this.getMutModelType();
        result = result * 59 + ($mutModelType == null ? 43 : ((Object)((Object)$mutModelType)).hashCode());
        return result;
    }

    public String toString() {
        return "NormalModel(algType=" + this.getAlgType() + ", ctrFMModel=" + this.getCtrFMModel() + ", cvrFMModel=" + this.getCvrFMModel() + ", ctrFusingFMModel=" + this.getCtrFusingFMModel() + ", cvrFusingFMModel=" + this.getCvrFusingFMModel() + ", ctrTfModel=" + this.getCtrTfModel() + ", cvrTfModel=" + this.getCvrTfModel() + ", mutModelType=" + (Object)((Object)this.getMutModelType()) + ")";
    }
}

