package cn.com.duiba.nezha.alg.model.grpc;

import org.apache.commons.pool2.impl.GenericObjectPool;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;


public class GrpcPool {
    protected Logger logger = LoggerFactory.getLogger(getClass());
    private String host;
    private int port;

    private GenericObjectPool<GrpcClientSingle> objectPool;


    public GrpcPool(String host, int port, GenericObjectPoolConfig poolConfig) {
        this.host = host;
        this.port = port;
        objectPool = new GenericObjectPool<>(new GrpcFactory(host, port), poolConfig);
    }

    /**
     * 返回连接对象
     *
     * @param grpcClientSingle
     */
    public void returnObject(GrpcClientSingle grpcClientSingle) {

        objectPool.returnObject(grpcClientSingle);
    }

    /**
     * 从连接池获取对象
     */
    public GrpcClientSingle borrowObject() throws Exception {

//        GrpcClientSingle clientSingle = objectPool.borrowObject();
//        return clientSingle;

        try {
            GrpcClientSingle clientSingle = objectPool.borrowObject();
            return clientSingle;
        } catch (Exception e) {
            logger.warn("",e);
        }

        return createClient();
    }

    /**
     * 当连接池异常,则主动创建对象
     */
    private GrpcClientSingle createClient() {
        return new GrpcClientSingle(host, port);
    }
}
