/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.alg.model;

import cn.com.duiba.nezha.alg.common.util.AssertUtil;
import cn.com.duiba.nezha.alg.common.util.DataUtil;
import cn.com.duiba.nezha.alg.common.util.MathUtil;
import cn.com.duiba.nezha.alg.feature.coder.FeatureCoder;
import cn.com.duiba.nezha.alg.feature.coder.FeatureNewCoder;
import cn.com.duiba.nezha.alg.feature.type.FeatureBaseType;
import cn.com.duiba.nezha.alg.feature.vo.CodeResult;
import cn.com.duiba.nezha.alg.feature.vo.Feature;
import cn.com.duiba.nezha.alg.feature.vo.FeatureMapDo;
import cn.com.duiba.nezha.alg.model.IModel;
import cn.com.duiba.nezha.alg.model.tf.LocalTFModel;
import cn.com.duiba.nezha.alg.model.tf.TFServingClient;
import cn.com.duiba.nezha.alg.model.vo.ParamsDo;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class FwFM
implements Serializable,
IModel {
    private String modelId;
    private String updateTime;
    private ParamsDo paramsDoffm;
    private List<FeatureBaseType> featureBaseType = new ArrayList<FeatureBaseType>();
    private int FBT_MAX_SIZE = 64;
    private int PB_MAX_SIZE = 128;

    @Override
    public String getModelId() {
        return this.modelId;
    }

    @Override
    public List<Float> getParam(Map<String, String> featureMap) throws Exception {
        ArrayList<Float> ret = null;
        double[] value = this.getParam2(featureMap);
        if (value != null) {
            ret = new ArrayList<Float>();
            for (int i = 0; i < value.length; ++i) {
                ret.add(Float.valueOf((float)value[i]));
            }
        }
        return ret;
    }

    public double[] getParam2(Map<String, String> featureMap) throws Exception {
        double[] ret = null;
        CodeResult codeResult = FeatureCoder.code(this.getFeatureBaseType(), featureMap);
        if (codeResult != null) {
            ret = this.getModelParams(codeResult.getFeatureSet());
        }
        return ret;
    }

    public double[] getParam2(FeatureMapDo featureMap) throws Exception {
        double[] ret = null;
        CodeResult codeResult = FeatureCoder.code(this.getFeatureBaseType(), (FeatureMapDo)featureMap);
        if (codeResult != null) {
            ret = this.getModelParams(codeResult.getFeatureSet());
        }
        return ret;
    }

    public double[] getModelParams(List<Set<Integer>> codeSetList) throws Exception {
        try {
            boolean status = true;
            double[] ret = null;
            return ret;
        }
        catch (Exception e) {
            System.out.println("FFM.predict error");
            throw new Exception(e);
        }
    }

    @Override
    public List<Float> getParam(FeatureMapDo featureMapDo) throws Exception {
        ArrayList<Float> ret = null;
        double[] value = this.getParam2(featureMapDo);
        if (value != null) {
            ret = new ArrayList<Float>();
            for (int i = 0; i < value.length; ++i) {
                ret.add(Float.valueOf((float)value[i]));
            }
        }
        return ret;
    }

    @Override
    public Double predict(Map<String, String> featureMap) throws Exception {
        Double ret = null;
        CodeResult codeResult = FeatureCoder.code(this.getFeatureBaseType(), featureMap);
        if (codeResult != null) {
            ret = this.predict(codeResult.getFeature());
        }
        return ret;
    }

    public Double predict(Feature feature) throws Exception {
        try {
            double ret = 0.0;
            double retW0 = 0.0;
            double retW = 0.0;
            double retV = 0.0;
            int factorNum = this.paramsDoffm.getFactorNum();
            if (feature != null) {
                HashMap tmpMap = new HashMap(1);
                HashMap tmpMap1 = new HashMap(1);
                List indices = feature.indices;
                double[] x = feature.values;
                List fields = feature.fields;
                retW0 = this.paramsDoffm.getWeight0();
                for (int i = 0; i < indices.size(); ++i) {
                    Integer vi = (Integer)indices.get(i);
                    double xi = x[i];
                    String fieldI = (String)fields.get(i);
                    retW += xi * this.paramsDoffm.getWeight().getOrDefault(vi, 0.0);
                    Map fieldIMap = this.paramsDoffm.getVectorC().getOrDefault(fieldI, tmpMap);
                    for (int j = i + 1; j < indices.size(); ++j) {
                        Integer vj = (Integer)indices.get(j);
                        double xj = x[j];
                        String fieldJ = (String)fields.get(j);
                        Double wij = fieldIMap.getOrDefault(fieldJ, 0.0);
                        double tmpProductValue = 0.0;
                        for (int k = 0; k < factorNum; ++k) {
                            Map factorKMap = this.paramsDoffm.getVector().getOrDefault(k, tmpMap1);
                            Double vifk = factorKMap.getOrDefault(vi, 0.0);
                            Double vjfk = factorKMap.getOrDefault(vj, 0.0);
                            if (vifk == null || vjfk == null) continue;
                            tmpProductValue += vifk * vjfk;
                        }
                        retV += wij * tmpProductValue * xi * xj;
                    }
                }
                ret = retW0 + retW + retV;
            }
            double pValue = MathUtil.sigmoid((double)ret);
            double pCValue = this.correctValue(pValue, this.paramsDoffm.getCorrect());
            return DataUtil.formatDouble((Double)pCValue, (int)5);
        }
        catch (Exception e) {
            System.out.println("FwFM.predict error");
            throw e;
        }
    }

    public Double predict(CodeResult codeResult) throws Exception {
        Double ret = null;
        if (codeResult != null) {
            ret = this.predict(codeResult.getFeature());
        }
        return ret;
    }

    public double correctValue(double pre_, Double correct) {
        double ret = pre_;
        if (correct != null) {
            ret = correct / (1.0 / pre_ - 1.0 + correct);
        }
        return ret;
    }

    @Override
    public <T> Map<T, Double> predicts(Map<T, Map<String, String>> featureMap) throws Exception {
        HashMap<T, Double> ret = new HashMap<T, Double>();
        if (AssertUtil.isNotEmpty(featureMap)) {
            for (Map.Entry<T, Map<String, String>> entry : featureMap.entrySet()) {
                ret.put(entry.getKey(), this.predict(entry.getValue()));
            }
        }
        return ret;
    }

    public <T> Map<T, List<Float>> getParams(Map<T, Map<String, String>> featureMap) throws Exception {
        HashMap<T, List<Float>> ret = new HashMap<T, List<Float>>(this.PB_MAX_SIZE);
        if (AssertUtil.isNotEmpty(featureMap)) {
            for (Map.Entry<T, Map<String, String>> entry : featureMap.entrySet()) {
                ret.put(entry.getKey(), this.getParam(entry.getValue()));
            }
        }
        return ret;
    }

    @Override
    public <T> Map<T, Double> predictWithTF(Map<T, Map<String, String>> featureMap, TFServingClient tfServingClient) throws Exception {
        Map<T, Double> ret = null;
        ret = tfServingClient == null ? this.predicts(featureMap) : tfServingClient.predict(this.getParams(featureMap));
        return ret;
    }

    @Override
    public <T> Map<T, Double> predictWithLocalTF(Map<T, Map<String, String>> featureMap, LocalTFModel localTFModel) throws Exception {
        return null;
    }

    @Override
    public <T> Map<T, Double> predictWithTFNew(Map<T, FeatureMapDo> featureMap, TFServingClient tfServingClient) throws Exception {
        return null;
    }

    @Override
    public <T> Map<T, Double> predictWithLocalTFNew(Map<T, FeatureMapDo> featureMap, LocalTFModel localTFModel) throws Exception {
        return null;
    }

    @Override
    public <T> Map<T, Double> predictsNew(Map<T, FeatureMapDo> featureMap) throws Exception {
        HashMap<T, Double> ret = new HashMap<T, Double>();
        if (AssertUtil.isNotEmpty(featureMap)) {
            Map codeResultMap = FeatureNewCoder.code(this.getFeatureBaseType(), featureMap);
            for (Map.Entry<T, FeatureMapDo> entry : featureMap.entrySet()) {
                CodeResult cr = (CodeResult)codeResultMap.get(entry.getKey());
                ret.put(entry.getKey(), this.predict(cr));
            }
        }
        return ret;
    }

    public void setModelId(String modelId) {
        this.modelId = modelId;
    }

    public String getUpdateTime() {
        return this.updateTime;
    }

    public void setUpdateTime(String updateTime) {
        this.updateTime = updateTime;
    }

    public ParamsDo getParamsDoffm() {
        return this.paramsDoffm;
    }

    public void setParamsDoffm(ParamsDo paramsDoffm) {
        this.paramsDoffm = paramsDoffm;
    }

    public List<FeatureBaseType> getFeatureBaseType() {
        return this.featureBaseType;
    }

    public void setFeatureBaseType(List<FeatureBaseType> featureBaseType) {
        this.featureBaseType = featureBaseType;
    }
}

