/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.alg.model;

import cn.com.duiba.nezha.alg.common.util.AssertUtil;
import cn.com.duiba.nezha.alg.feature.type.FeatureBaseType2;
import cn.com.duiba.nezha.alg.feature.vo.FeatureMapDo;
import cn.com.duiba.nezha.alg.model.util.CollectionUtil;
import cn.com.duiba.nezha.alg.model.vo.CodeDo;
import cn.com.duiba.nezha.alg.model.vo.CodeSizeDo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeepBaseModelV2 {
    private static final Logger logger = LoggerFactory.getLogger(DeepBaseModelV2.class);
    private int FBT_MAX_SIZE = 64;
    private int PB_MAX_SIZE = 128;
    private Integer S_F_IDX = 1;
    private Integer M_F_IDX = 2;
    private Integer F_F_IDX = 3;
    public static Map<String, Integer> tmpIntMap = new HashMap<String, Integer>();
    public static Map tmpMap = new HashMap();

    public <T> Map<T, CodeDo> getPredDenseCodes(Map<T, FeatureMapDo> featureMaps, Map<String, Map<String, List<Integer>>> coderCache, String modelId, boolean hasSubCache, boolean hasMultValueCache, List<FeatureBaseType2> featureList, Map<String, Map<String, Integer>> featureDenseCoderMap) throws Exception {
        HashMap<T, CodeDo> ret = new HashMap<T, CodeDo>(this.PB_MAX_SIZE);
        if (hasSubCache) {
            coderCache = new HashMap<String, Map<String, List<Integer>>>();
            hasMultValueCache = true;
        }
        if (AssertUtil.isNotEmpty(featureMaps)) {
            for (Map.Entry<T, FeatureMapDo> entry : featureMaps.entrySet()) {
                FeatureMapDo featureMapDo = entry.getValue();
                ret.put(entry.getKey(), this.getDenseCode(featureMapDo.staticFeatureMap, featureMapDo.dynamicFeatureMap, coderCache, hasMultValueCache, modelId, featureList, featureDenseCoderMap));
            }
        }
        if (AssertUtil.isEmpty(ret)) {
            logger.warn(modelId + " getCodes is invalid, featureMap is null or {}");
        }
        return ret;
    }

    public <T> Map<T, CodeDo> getSampleDenses(Map<T, Map<String, String>> featureMaps, Map<String, Map<String, List<Integer>>> coderCache, String modelId, List<FeatureBaseType2> featureList, Map<String, Map<String, Integer>> featureDenseCoderMap) throws Exception {
        HashMap<T, CodeDo> ret = new HashMap<T, CodeDo>(this.PB_MAX_SIZE);
        if (AssertUtil.isNotEmpty(featureMaps)) {
            for (Map.Entry<T, Map<String, String>> entry : featureMaps.entrySet()) {
                ret.put(entry.getKey(), this.getDenseCode(entry.getValue(), null, coderCache, false, modelId, featureList, featureDenseCoderMap));
            }
        }
        if (AssertUtil.isEmpty(ret)) {
            logger.warn(modelId + " getCodes is invalid, featureMap is null or {}");
        }
        return ret;
    }

    public CodeDo getSampleDense(Map<String, String> featureMap, Map<String, Map<String, List<Integer>>> coderCache, String modelId, List<FeatureBaseType2> featureList, Map<String, Map<String, Integer>> featureDenseCoderMap) throws Exception {
        return this.getDenseCode(featureMap, null, coderCache, false, modelId, featureList, featureDenseCoderMap);
    }

    public CodeSizeDo getCodeSize(List<FeatureBaseType2> featureList) throws Exception {
        CodeSizeDo ret = new CodeSizeDo();
        int singleSize = 0;
        int multiSize = 0;
        int floatSize = 0;
        try {
            for (FeatureBaseType2 featureBaseType : featureList) {
                if (this.S_F_IDX.equals(featureBaseType.getCodeType())) {
                    ++singleSize;
                }
                if (this.M_F_IDX.equals(featureBaseType.getCodeType())) {
                    multiSize += featureBaseType.subLen;
                }
                if (!this.F_F_IDX.equals(featureBaseType.getCodeType())) continue;
                floatSize += featureBaseType.subLen;
            }
        }
        catch (Exception e) {
            logger.warn(" getDenseCode error ", (Throwable)e);
        }
        ret.setSingleSize(singleSize);
        ret.setMultiSize(multiSize);
        ret.setFloatSize(floatSize);
        return ret;
    }

    public CodeDo getDenseCode(Map<String, String> staticFeatureMap, Map<String, String> dynamicFeatureMap, Map<String, Map<String, List<Integer>>> coderCache, boolean hasStaticMultValueCache, String modelId, List<FeatureBaseType2> featureList, Map<String, Map<String, Integer>> featureDenseCoderMap) throws Exception {
        CodeDo ret = new CodeDo();
        ArrayList<Integer> sCode = new ArrayList<Integer>();
        ArrayList<String> mCode = new ArrayList<String>();
        ArrayList<Float> fCode = new ArrayList<Float>();
        int sStartIndex = 0;
        try {
            if (staticFeatureMap == null) {
                staticFeatureMap = tmpMap;
            }
            if (dynamicFeatureMap == null) {
                dynamicFeatureMap = tmpMap;
            }
            for (FeatureBaseType2 featureBaseType : featureList) {
                List<Number> filedCode;
                String value;
                String string = value = dynamicFeatureMap.get(featureBaseType.featureId) == null ? (String)staticFeatureMap.get(featureBaseType.featureId) : (String)dynamicFeatureMap.get(featureBaseType.featureName);
                if (this.S_F_IDX.equals(featureBaseType.getCodeType())) {
                    filedCode = new ArrayList();
                    if (coderCache != null) {
                        Map<String, List<Integer>> cache = coderCache.getOrDefault(featureBaseType.featureId, tmpMap);
                        if (!cache.containsKey(value)) {
                            filedCode = this.getSingleFieldDenseCode(featureBaseType, value, sStartIndex, featureDenseCoderMap);
                            cache.put(value, filedCode);
                        }
                        filedCode = cache.get(value);
                    } else {
                        filedCode = this.getSingleFieldDenseCode(featureBaseType, value, sStartIndex, featureDenseCoderMap);
                    }
                    sCode.addAll(filedCode);
                    sStartIndex += featureBaseType.denseLen + 1;
                }
                if (this.M_F_IDX.equals(featureBaseType.getCodeType())) {
                    filedCode = this.getMultiFieldDenseCode(featureBaseType, value, featureDenseCoderMap);
                    mCode.add((String)((Object)filedCode));
                }
                if (!this.F_F_IDX.equals(featureBaseType.getCodeType())) continue;
                filedCode = this.getFloatFieldDenseCode(featureBaseType, value);
                fCode.addAll(filedCode);
            }
            ret.setFloatCode(fCode);
            ret.setSingleCode(sCode);
            ret.setMultiCode(mCode);
        }
        catch (Exception e) {
            logger.warn(modelId + " getDenseCode ", (Throwable)e);
        }
        return ret;
    }

    public void printInfo(List<FeatureBaseType2> featureList) throws Exception {
        int sMaxNums = 0;
        String sInfo = "feature_s_config=[";
        String mInfo = "feature_m_config=[";
        String fInfo = "feature_f_config=[";
        try {
            for (FeatureBaseType2 featureBaseType : featureList) {
                String fId = featureBaseType.getFeatureId();
                int denLen = featureBaseType.getDenseLen();
                int sublen = featureBaseType.getSubLen();
                if (this.S_F_IDX.equals(featureBaseType.getCodeType())) {
                    sMaxNums += featureBaseType.denseLen + 1;
                    sInfo = sInfo + "\n{\"id\":\"" + fId + "\" ,\"max_nums\":" + denLen + " ,\"sub_len\":" + sublen + "},";
                }
                if (this.M_F_IDX.equals(featureBaseType.getCodeType())) {
                    mInfo = mInfo + "\n{\"id\":\"" + fId + "\" ,\"max_nums\":" + denLen + " ,\"sub_len\":" + sublen + "},";
                }
                if (!this.F_F_IDX.equals(featureBaseType.getCodeType())) continue;
                fInfo = fInfo + "\n{\"id\":\"" + fId + "\" ,\"max_nums\":" + denLen + " ,\"sub_len\":" + sublen + "},";
            }
            sInfo = sInfo + "\n]\ns_max_nums=" + sMaxNums;
            mInfo = mInfo + "\n]";
            fInfo = fInfo + "\n]";
            System.out.println(sInfo);
            System.out.println(mInfo);
            System.out.println(fInfo);
        }
        catch (Exception e) {
            logger.warn("", (Throwable)e);
        }
    }

    public List<Integer> getSingleFieldDenseCode(FeatureBaseType2 featureBaseType, String featureValue, int startIndex, Map<String, Map<String, Integer>> featureDenseCoderMap) throws Exception {
        ArrayList<Integer> ret = new ArrayList<Integer>();
        String featureValueStd = FeatureBaseType2.std((String)featureValue);
        Integer index = featureDenseCoderMap.getOrDefault(featureBaseType.featureId, tmpIntMap).getOrDefault(featureValueStd, 0);
        if (index >= featureBaseType.denseLen) {
            index = 0;
        }
        ret.add(index + startIndex);
        return ret;
    }

    public String getMultiFieldDenseCode(FeatureBaseType2 featureBaseType, String featureValue, Map<String, Map<String, Integer>> featureDenseCoderMap) throws Exception {
        ArrayList<Integer> retInt = new ArrayList<Integer>();
        String featureValueStd = FeatureBaseType2.std((String)featureValue);
        String[] featureArray = featureBaseType.split(featureValueStd);
        int featuresSize = featureArray == null ? 0 : featureArray.length;
        int subLen = featureBaseType.subLen;
        for (int i = 0; i < featuresSize; ++i) {
            Integer index = 0;
            if (i >= subLen) continue;
            String valueStd = FeatureBaseType2.std((String)featureArray[i]);
            index = featureDenseCoderMap.getOrDefault(featureBaseType.featureId, tmpIntMap).getOrDefault(valueStd, 0);
            if (index >= featureBaseType.denseLen) {
                index = 0;
            }
            retInt.add(index);
        }
        if (featuresSize == 0) {
            retInt.add(0);
        }
        return CollectionUtil.toString(retInt, ",");
    }

    public List<Float> getFloatFieldDenseCode(FeatureBaseType2 featureBaseType, String featureValue) throws Exception {
        ArrayList<Float> ret = new ArrayList<Float>();
        String featureValueStd = FeatureBaseType2.std((String)featureValue);
        if (featureBaseType.getSplitChar() != null) {
            String[] featureArray = featureBaseType.split(featureValueStd);
            int featuresSize = featureArray == null ? 0 : featureArray.length;
            for (int i = 0; i < featureBaseType.denseLen; ++i) {
                if (i < featuresSize) {
                    String valueStd = FeatureBaseType2.std((String)featureArray[i]);
                    if (valueStd != null) {
                        Float idx = Float.valueOf(Float.parseFloat(valueStd));
                        ret.add(idx);
                        continue;
                    }
                    ret.add(Float.valueOf(0.0f));
                    continue;
                }
                ret.add(Float.valueOf(0.0f));
            }
        } else {
            Float idx = Float.valueOf(Float.parseFloat(featureValueStd));
            ret.add(idx);
        }
        return ret;
    }

    public int getFBT_MAX_SIZE() {
        return this.FBT_MAX_SIZE;
    }

    public int getPB_MAX_SIZE() {
        return this.PB_MAX_SIZE;
    }

    public Integer getS_F_IDX() {
        return this.S_F_IDX;
    }

    public Integer getM_F_IDX() {
        return this.M_F_IDX;
    }

    public Integer getF_F_IDX() {
        return this.F_F_IDX;
    }

    public void setFBT_MAX_SIZE(int FBT_MAX_SIZE) {
        this.FBT_MAX_SIZE = FBT_MAX_SIZE;
    }

    public void setPB_MAX_SIZE(int PB_MAX_SIZE) {
        this.PB_MAX_SIZE = PB_MAX_SIZE;
    }

    public void setS_F_IDX(Integer S_F_IDX) {
        this.S_F_IDX = S_F_IDX;
    }

    public void setM_F_IDX(Integer M_F_IDX) {
        this.M_F_IDX = M_F_IDX;
    }

    public void setF_F_IDX(Integer F_F_IDX) {
        this.F_F_IDX = F_F_IDX;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DeepBaseModelV2)) {
            return false;
        }
        DeepBaseModelV2 other = (DeepBaseModelV2)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getFBT_MAX_SIZE() != other.getFBT_MAX_SIZE()) {
            return false;
        }
        if (this.getPB_MAX_SIZE() != other.getPB_MAX_SIZE()) {
            return false;
        }
        Integer this$S_F_IDX = this.getS_F_IDX();
        Integer other$S_F_IDX = other.getS_F_IDX();
        if (this$S_F_IDX == null ? other$S_F_IDX != null : !((Object)this$S_F_IDX).equals(other$S_F_IDX)) {
            return false;
        }
        Integer this$M_F_IDX = this.getM_F_IDX();
        Integer other$M_F_IDX = other.getM_F_IDX();
        if (this$M_F_IDX == null ? other$M_F_IDX != null : !((Object)this$M_F_IDX).equals(other$M_F_IDX)) {
            return false;
        }
        Integer this$F_F_IDX = this.getF_F_IDX();
        Integer other$F_F_IDX = other.getF_F_IDX();
        return !(this$F_F_IDX == null ? other$F_F_IDX != null : !((Object)this$F_F_IDX).equals(other$F_F_IDX));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DeepBaseModelV2;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getFBT_MAX_SIZE();
        result = result * 59 + this.getPB_MAX_SIZE();
        Integer $S_F_IDX = this.getS_F_IDX();
        result = result * 59 + ($S_F_IDX == null ? 43 : ((Object)$S_F_IDX).hashCode());
        Integer $M_F_IDX = this.getM_F_IDX();
        result = result * 59 + ($M_F_IDX == null ? 43 : ((Object)$M_F_IDX).hashCode());
        Integer $F_F_IDX = this.getF_F_IDX();
        result = result * 59 + ($F_F_IDX == null ? 43 : ((Object)$F_F_IDX).hashCode());
        return result;
    }

    public String toString() {
        return "DeepBaseModelV2(FBT_MAX_SIZE=" + this.getFBT_MAX_SIZE() + ", PB_MAX_SIZE=" + this.getPB_MAX_SIZE() + ", S_F_IDX=" + this.getS_F_IDX() + ", M_F_IDX=" + this.getM_F_IDX() + ", F_F_IDX=" + this.getF_F_IDX() + ")";
    }
}

