/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.alg.model.tf;

import cn.com.duiba.nezha.alg.common.util.NumberUtil;
import java.io.File;
import org.tensorflow.SavedModelBundle;
import org.tensorflow.framework.MetaGraphDef;
import org.tensorflow.framework.SignatureDef;
import org.tensorflow.framework.TensorInfo;

public class TensorflowUtils {
    public static SavedModelBundle getModelBundle(String path, String version) throws Exception {
        System.out.println("local model path =" + path + ",version=" + version);
        SavedModelBundle bundle = SavedModelBundle.load((String)(path + version), (String[])new String[]{"serve"});
        return bundle;
    }

    public static SavedModelBundle loadModelV1(String modelpath, String version) {
        String path = modelpath.endsWith("/") ? modelpath + version : modelpath + "/" + version;
        System.out.println("local model path =" + path);
        SavedModelBundle bundle = SavedModelBundle.load((String)path, (String[])new String[]{"serve"});
        return bundle;
    }

    public static String getLastVersion(String path) throws Exception {
        String ret = null;
        Long tmpVersion = null;
        File file = new File(path);
        if (file.isDirectory()) {
            File[] listFiles = file.listFiles();
            for (int i = 0; i < listFiles.length; ++i) {
                File f = listFiles[i];
                String fName = f.getName();
                if (!NumberUtil.isNumber((String)fName)) continue;
                Long version = Long.valueOf(fName);
                if (tmpVersion != null && tmpVersion >= version) continue;
                tmpVersion = version;
            }
        }
        ret = tmpVersion + "";
        return ret;
    }

    public static String getOutputName(String output, SavedModelBundle bundle, String SIGNATURE_DEF) throws Exception {
        SignatureDef sig = MetaGraphDef.parseFrom((byte[])bundle.metaGraphDef()).getSignatureDefOrThrow(SIGNATURE_DEF);
        String outputName = ((TensorInfo)sig.getOutputsMap().get(output)).getName();
        return outputName;
    }

    public static String getInputName(String input, SavedModelBundle bundle, String SIGNATURE_DEF) throws Exception {
        String inputName = null;
        SignatureDef sig = MetaGraphDef.parseFrom((byte[])bundle.metaGraphDef()).getSignatureDefOrThrow(SIGNATURE_DEF);
        if (sig.getInputsMap().get(input) != null) {
            inputName = ((TensorInfo)sig.getInputsMap().get(input)).getName();
        }
        return inputName;
    }
}

