/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.alg.stat;

import cn.com.duiba.nezha.alg.stat.dto.StatDto;
import cn.com.duiba.nezha.alg.stat.utils.AssertUtil;
import cn.com.duiba.nezha.alg.stat.utils.MathUtil;
import cn.com.duiba.nezha.alg.stat.utils.MergerUtil;
import com.alibaba.fastjson.JSON;
import java.util.HashMap;
import java.util.Map;

public class StatMerger {
    public static StatDto dimsMerge(StatDto appDto, StatDto activityDto, StatDto slotDto, StatDto globalDto) throws Exception {
        StatDto ret = null;
        Boolean isNewAdvert = true;
        if (globalDto != null && globalDto.getLaunchCnt() > 50L) {
            ret = globalDto;
            isNewAdvert = StatMerger.isNewAdvert(globalDto.getLaunchCnt());
        }
        if (activityDto != null && activityDto.getLaunchCnt() > 50L) {
            ret = activityDto;
        }
        if (appDto != null && appDto.getLaunchCnt() > 50L) {
            ret = appDto;
        }
        if (slotDto != null && slotDto.getLaunchCnt() > 50L) {
            ret = slotDto;
        }
        return ret;
    }

    public static Boolean isNewAdvert(Long launchCnt) {
        if (launchCnt != null && launchCnt > 500L) {
            return false;
        }
        return true;
    }

    public static StatDto dimMerge(StatDto dimDto, StatDto globalDto, StatDto appDto) throws Exception {
        if (dimDto != null && dimDto.getLaunchCnt() > 20L) {
            return dimDto;
        }
        if (appDto != null && appDto.getLaunchCnt() > 20L) {
            return appDto;
        }
        if (globalDto != null && globalDto.getLaunchCnt() > 50L) {
            return globalDto;
        }
        return null;
    }

    public static StatDto intervalMerge(Map<Long, StatDto> statDtoHourMap, Map<Long, StatDto> statDtoDayMap) throws Exception {
        StatDto ret = null;
        if (AssertUtil.isAllEmpty(statDtoHourMap, statDtoDayMap)) {
            return ret;
        }
        ret = new StatDto();
        StatDto hourMergeDto = StatMerger.intervalMerge(statDtoHourMap, 6, 1L);
        StatDto dayMergeDto = StatMerger.intervalMerge(statDtoDayMap, 4, 2L);
        long hourLaunchCnt = 0L;
        long hourChargeCnt = 0L;
        long hourActClickCnt = 0L;
        long hourActExpCnt = 0L;
        long dayLaunchCnt = 0L;
        long dayChargeCnt = 0L;
        long dayActClickCnt = 0L;
        long dayActExpCnt = 0L;
        if (hourMergeDto != null) {
            hourLaunchCnt = MathUtil.tolong(hourMergeDto.getLaunchCnt());
            hourChargeCnt = MathUtil.tolong(hourMergeDto.getChargeCnt());
            hourActClickCnt = MathUtil.tolong(hourMergeDto.getActClickCnt());
            hourActExpCnt = MathUtil.tolong(hourMergeDto.getActExpCnt());
        }
        if (dayMergeDto != null) {
            dayLaunchCnt = MathUtil.tolong(dayMergeDto.getLaunchCnt());
            dayChargeCnt = MathUtil.tolong(dayMergeDto.getChargeCnt());
            dayActClickCnt = MathUtil.tolong(dayMergeDto.getActClickCnt());
            dayActExpCnt = MathUtil.tolong(dayMergeDto.getActExpCnt());
        }
        double historyCtr = MergerUtil.getCtrWithBias(dayChargeCnt, dayLaunchCnt, 100L, (Double)0.5, 100L, 6);
        double historyCvr = MergerUtil.getCtrWithBias(dayActClickCnt, dayChargeCnt, 200L, (Double)0.05, 100L, 6);
        double mergeCtr = MergerUtil.getCtrWithBias(hourChargeCnt, hourLaunchCnt, 100L, (Double)historyCtr, 100L, 6);
        double mergeCvr = MergerUtil.getCtrWithBias(hourActClickCnt, hourChargeCnt, 200L, (Double)historyCvr, 100L, 6);
        if (hourLaunchCnt > 50000L) {
            ret.setLaunchCnt(hourLaunchCnt);
            ret.setChargeCnt(hourChargeCnt);
            ret.setActClickCnt(hourActClickCnt);
            ret.setActExpCnt(hourActExpCnt);
            ret.setBackendCntMap(hourMergeDto.getBackendCntMap());
        } else {
            ret.setLaunchCnt(dayLaunchCnt);
            ret.setChargeCnt(dayChargeCnt);
            ret.setActClickCnt(dayActClickCnt);
            ret.setActExpCnt(dayActExpCnt);
            ret.setBackendCntMap(dayMergeDto.getBackendCntMap());
        }
        ret.setMergeCtr(mergeCtr);
        ret.setMergeCvr(mergeCvr);
        return ret;
    }

    private static StatDto intervalMerge(Map<Long, StatDto> statDtoMap, int upLimit, Long type) throws Exception {
        StatDto ret = new StatDto();
        if (AssertUtil.isEmpty(statDtoMap) || type == null) {
            return ret;
        }
        Long weightCnt = 0L;
        Long launchCnt = 0L;
        Long chargeCnt = 0L;
        Long actClickCnt = 0L;
        Long actExpCnt = 0L;
        HashMap<String, Long> backendMap = new HashMap<String, Long>();
        int i = 0;
        for (Map.Entry<Long, StatDto> entry : statDtoMap.entrySet()) {
            Long lcnt;
            Long index = entry.getKey();
            Long weight = StatMerger.mergeWeight(index, type, upLimit);
            StatDto dto = entry.getValue();
            if (weight == null || !((double)weight.longValue() > 0.0) || dto == null || (lcnt = dto.getLaunchCnt()) == null || lcnt <= 0L) continue;
            Map<String, Long> backendMapTmp = dto.getBackendCntMap();
            if (AssertUtil.isNotEmpty(backendMapTmp)) {
                for (Map.Entry<String, Long> entry1 : backendMapTmp.entrySet()) {
                    String subType = entry1.getKey();
                    Long beCnt = entry1.getValue();
                    if (backendMap.containsKey(subType)) {
                        backendMap.put(subType, MathUtil.add(MathUtil.dot(beCnt, weight), (Long)backendMap.get(subType)));
                        continue;
                    }
                    backendMap.put(subType, MathUtil.dot(beCnt, weight));
                }
            }
            weightCnt = weightCnt + weight;
            launchCnt = MathUtil.add(MathUtil.dot(dto.getLaunchCnt(), weight), launchCnt);
            chargeCnt = MathUtil.add(MathUtil.dot(dto.getChargeCnt(), weight), chargeCnt);
            actClickCnt = MathUtil.add(MathUtil.dot(dto.getActClickCnt(), weight), actClickCnt);
            actExpCnt = MathUtil.add(MathUtil.dot(dto.getActExpCnt(), weight), actExpCnt);
            ++i;
        }
        System.out.println(i);
        System.out.println(weightCnt);
        if (i > 0) {
            ret.setLaunchCnt(MathUtil.division(launchCnt, (Long)(weightCnt / (long)i)));
            ret.setChargeCnt(MathUtil.division(chargeCnt, (Long)(weightCnt / (long)i)));
            ret.setActExpCnt(MathUtil.division(actExpCnt, (Long)(weightCnt / (long)i)));
            ret.setActClickCnt(MathUtil.division(actClickCnt, (Long)(weightCnt / (long)i)));
            for (Map.Entry<Long, StatDto> entry : backendMap.entrySet()) {
                backendMap.put((String)((Object)entry.getKey()), MathUtil.division((Long)((Object)entry.getValue()), (Long)(weightCnt / (long)i)));
            }
            ret.setBackendCntMap(backendMap);
        }
        System.out.println("r=" + JSON.toJSONString((Object)ret));
        return ret;
    }

    public static Long mergeWeight(Long lastNum, Long type, long upLimit) {
        Long ret = null;
        if (lastNum > upLimit) {
            return ret;
        }
        if (type.equals(1L)) {
            ret = MergerUtil.hourMergeWeight(lastNum);
        }
        if (type.equals(2L)) {
            ret = MergerUtil.dayMergeWeight(lastNum);
        }
        return ret;
    }

    public static void main(String[] args) {
        HashMap<Long, StatDto> statDtoHourMap = new HashMap<Long, StatDto>();
        HashMap<Long, StatDto> statDtoDayMap = new HashMap<Long, StatDto>();
        StatDto d0 = new StatDto();
        d0.setLaunchCnt(2095L);
        d0.setActClickCnt(89L);
        d0.setChargeCnt(1696L);
        statDtoDayMap.put(0L, d0);
        StatDto d1 = new StatDto();
        d1.setLaunchCnt(0L);
        d1.setActClickCnt(0L);
        d1.setChargeCnt(0L);
        statDtoDayMap.put(1L, d1);
        StatDto d2 = new StatDto();
        d2.setLaunchCnt(0L);
        d2.setActClickCnt(0L);
        d2.setChargeCnt(0L);
        statDtoDayMap.put(2L, d2);
        statDtoDayMap.put(1L, d2);
        StatDto d3 = new StatDto();
        d3.setLaunchCnt(0L);
        d3.setActClickCnt(0L);
        d3.setChargeCnt(0L);
        statDtoDayMap.put(3L, d3);
        StatDto d4 = new StatDto();
        d4.setLaunchCnt(118L);
        d4.setActClickCnt(1L);
        d4.setChargeCnt(118L);
        statDtoDayMap.put(4L, d4);
        StatDto d5 = new StatDto();
        d5.setLaunchCnt(100L);
        d5.setActClickCnt(0L);
        d5.setChargeCnt(25L);
        statDtoHourMap.put(0L, d5);
        statDtoHourMap.put(1L, d5);
        statDtoHourMap.put(2L, d5);
        statDtoHourMap.put(3L, d5);
        try {
            StatDto ret = StatMerger.intervalMerge(statDtoHourMap, statDtoDayMap);
            System.out.println(JSON.toJSONString((Object)ret));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

