package feedback;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class BlackWhiteNameListRule {
    public BlackWhiteNameListRule() {
    }

    public static Map<String, String> whiteBlackNameListRule(List<CostConvertInfo> infoList) {
        Map<String, String> nameListMap = new HashMap();

        for(int i = 0; i < infoList.size(); ++i) {
            CostConvertInfo costConvertInfo = (CostConvertInfo)infoList.get(i);
            String type = costConvertInfo.type;
            String tag = costConvertInfo.tag;
            Integer grained = costConvertInfo.grained;
            String whiteBlackKey = costConvertInfo.appId + "_" + costConvertInfo.slotId + "_" + costConvertInfo.activityId + "_" + costConvertInfo.orientationId + "_" + costConvertInfo.advertId;
            String fuseKey = costConvertInfo.orientationId + "_" + costConvertInfo.advertId;
            Float costConvertAd = costConvertInfo.adCostConvert;
            long luanch_cnt;
            Long costKey1d;
            Long convertKey1d;
            Long costConvertKey1d;
            Float diffR1d;
            if (type.equals("day") && tag.equals("2") && grained == 1 && costConvertAd > 0.0F) {
                luanch_cnt = costConvertInfo.launchCnt;
                costKey1d = costConvertInfo.cost;
                convertKey1d = costConvertInfo.convert;
                if (convertKey1d == 0L && costKey1d > 1000L) {
                    nameListMap.put(fuseKey, "fuse_1");
                } else if (convertKey1d > 0L) {
                    costConvertKey1d = costKey1d / convertKey1d;
                    diffR1d = (float)costConvertKey1d / costConvertAd;
                    if (diffR1d >= 3.0F) {
                        nameListMap.put(fuseKey, "fuse_1");
                    }
                }
            } else if (type.equals("hour") && tag.equals("2") && grained == 0 && costConvertAd > 0.0F) {
                luanch_cnt = costConvertInfo.launchCnt;
                costKey1d = costConvertInfo.cost;
                convertKey1d = costConvertInfo.convert;
                if (convertKey1d == 0L && costKey1d > 1000L) {
                    nameListMap.put(whiteBlackKey, "b3_1");
                } else if (convertKey1d > 0L) {
                    costConvertKey1d = costKey1d / convertKey1d;
                    diffR1d = (float)costConvertKey1d / costConvertAd;
                    if (diffR1d >= 2.0F) {
                        nameListMap.put(whiteBlackKey, "b3_1");
                    }
                }
            } else if (type.equals("day") && tag.equals("2") && grained == 0 && costConvertAd > 0.0F) {
                luanch_cnt = costConvertInfo.launchCnt;
                costKey1d = costConvertInfo.cost;
                convertKey1d = costConvertInfo.convert;
                if (convertKey1d == 0L && costKey1d > 5000L) {
                    nameListMap.put(whiteBlackKey, "b1_5");
                } else if (convertKey1d == 0L && costKey1d > 1000L) {
                    nameListMap.put(whiteBlackKey, "b2_3");
                } else if (convertKey1d > 0L) {
                    costConvertKey1d = costKey1d / convertKey1d;
                    diffR1d = (float)costConvertKey1d / costConvertAd;
                    if ((double)diffR1d > 2.5D && (double)diffR1d <= 3.5D) {
                        nameListMap.put(whiteBlackKey, "b1_5");
                    } else if ((double)diffR1d >= 1.5D && (double)diffR1d < 2.5D) {
                        nameListMap.put(whiteBlackKey, "b2_3");
                    } else if ((double)diffR1d < 0.5D) {
                        nameListMap.put(whiteBlackKey, "w_1");
                    }
                }
            }
        }

        return nameListMap;
    }
}

