package feedback;


import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SlotFeedBack {
    public SlotFeedBack() {
    }

    public static Map<String, String> slotFeedBack(List<SlotFeedBackInfo> infoList) {
        Map<String, String> blackMap = new HashMap();

        for(int i = 0; i < infoList.size(); ++i) {
            SlotFeedBackInfo SlotFeedBackInfo = (SlotFeedBackInfo)infoList.get(i);
            String slotId = SlotFeedBackInfo.slotId;
            String advertId = SlotFeedBackInfo.advertId;
            String orientationId = SlotFeedBackInfo.orientationId;
            String type = SlotFeedBackInfo.type;
            Integer chargeType = SlotFeedBackInfo.chargeType;
            Long slotOrientCost = SlotFeedBackInfo.slotOrientCost;
            Long slotOrientConvert = SlotFeedBackInfo.slotOrientConvert;
            Long targetCostConvert = SlotFeedBackInfo.targetCostConvert;
            Float slotOrientCostConvert = (slotOrientConvert!=0) ? (float)slotOrientCost / (float)slotOrientConvert : 0;
            Float confidence=Math.max((float)slotOrientCost/(targetCostConvert*5),1);
            Float slotCostConvertBias=(slotOrientConvert!=0) ? slotOrientCostConvert/targetCostConvert:slotOrientCost/targetCostConvert;
            String blackKey = "NZ_K077_" + SlotFeedBackInfo.slotId + "_" + SlotFeedBackInfo.advertId + "_" + SlotFeedBackInfo.orientationId + "_" + SlotFeedBackInfo.targetCostConvert;

            if ("hour".equals(type) & confidence>=0.4 && slotCostConvertBias > 2) {
                blackMap.put(blackKey, "b0");
            } else if ("hour".equals(type) & confidence>=0.4  && slotCostConvertBias > 1.5) {
                blackMap.put(blackKey, "b1");
            } else if ("hour".equals(type) & confidence>=0.4  && slotCostConvertBias > 1.2) {
                blackMap.put(blackKey, "b2");
            } else if ("day".equals(type) & confidence>=0.6  && slotCostConvertBias > 2) {
                blackMap.put(blackKey, "b0");
            } else if ("day".equals(type) & confidence>=0.6  && slotCostConvertBias > 1.5) {
                blackMap.put(blackKey, "b1");
            } else if ("day".equals(type) & confidence>=0.6  && slotCostConvertBias > 1.2) {
                blackMap.put(blackKey, "b2");
            }

        }

        return blackMap;
    }
}