/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.compute.alg;

import cn.com.duiba.nezha.compute.api.dto.CorrectionInfo;
import cn.com.duiba.nezha.compute.api.dto.NezhaStatDto;
import cn.com.duiba.nezha.compute.common.util.AssertUtil;
import java.util.List;
import org.apache.log4j.Logger;

public class ModelPredRectifier {
    private static Logger logger = Logger.getLogger(ModelPredRectifier.class);
    private static Double lndWeight = 0.5;
    private static Double ndWeight = 0.5;

    public static void getCorrectionFactor(List<CorrectionInfo> advertCorrectionInfoList) throws Exception {
        if (AssertUtil.isEmpty(advertCorrectionInfoList)) {
            return;
        }
        for (CorrectionInfo info : advertCorrectionInfoList) {
            if (info == null) continue;
            info.setCorrectionFactor(Double.valueOf(1.0));
            info.setReconstructionFactor(Double.valueOf(1.0));
            ModelPredRectifier.setCorrectionFactor(info);
        }
    }

    public static void getCorrectionReconstructionFactor(List<CorrectionInfo> advertCorrectionInfoList) throws Exception {
        if (AssertUtil.isEmpty(advertCorrectionInfoList)) {
            return;
        }
        for (CorrectionInfo info : advertCorrectionInfoList) {
            if (info == null) continue;
            info.setCorrectionFactor(Double.valueOf(1.0));
            info.setReconstructionFactor(Double.valueOf(1.0));
            ModelPredRectifier.setCorrectionFactor(info);
            ModelPredRectifier.setReconstructionFactor(info);
        }
    }

    public static void setCorrectionFactor(CorrectionInfo info) throws Exception {
        if (info == null) {
            logger.warn((Object)"setCorrectionFactor input invalid,with info = null");
            return;
        }
        if (info.getCurrentPreValue() == null) {
            logger.warn((Object)"setCorrectionFactor input invalid,with info.getCurrentPreValue() = null");
            return;
        }
        if (info.getCurrentPreValue() < 1.0E-10) {
            return;
        }
        if (info.getNezhaStatDto() == null) {
            return;
        }
        Long type = info.getType();
        Double currentPreValue = info.getCurrentPreValue();
        NezhaStatDto nezhaStatDto = info.getNezhaStatDto();
        Double avgPreValue = null;
        Double avgFeedbackValue = null;
        Double vUpperLimit = null;
        Double vLowerLimit = null;
        Double fUpperLimit = null;
        Double fLowerLimit = null;
        if (type.equals(1L)) {
            avgPreValue = nezhaStatDto.getPreCtrAvg();
            avgFeedbackValue = nezhaStatDto.getStatCtrAvg();
            vUpperLimit = 0.99;
            vLowerLimit = 0.01;
            fUpperLimit = 4.0;
            fLowerLimit = 0.25;
        }
        if (type.equals(2L)) {
            avgPreValue = nezhaStatDto.getPreCvrAvg();
            avgFeedbackValue = nezhaStatDto.getStatCvrAvg();
            vUpperLimit = 0.99;
            vLowerLimit = 5.0E-4;
            fUpperLimit = 4.0;
            fLowerLimit = 0.1;
        }
        Double newCurrentPreValue = ModelPredRectifier.correctionValue(currentPreValue, avgPreValue, avgFeedbackValue, vLowerLimit, vUpperLimit);
        Double currentPreFactor = ModelPredRectifier.noiseSmoother(newCurrentPreValue / currentPreValue, fLowerLimit, fUpperLimit);
        info.setCorrectionFactor(currentPreFactor);
    }

    public static void setReconstructionFactor(CorrectionInfo info) throws Exception {
        if (info == null) {
            logger.warn((Object)"setReconstructionFactor input invalid,with info = null");
            return;
        }
        if (info.getCurrentPreValue() == null) {
            logger.warn((Object)"setReconstructionFactor input invalid,with info.getCurrentPreValue() = null");
            return;
        }
        if (info.getNezhaStatDto() == null) {
            return;
        }
        Long type = info.getType();
        Double currentPreValue = info.getCurrentPreValue();
        NezhaStatDto nezhaStatDto = info.getNezhaStatDto();
        Double avgFeedbackValue = null;
        Double lowerLimit = null;
        Double upperLimit = null;
        if (type.equals(1L)) {
            avgFeedbackValue = nezhaStatDto.getStatCtrAvg();
            lowerLimit = 0.5;
            upperLimit = 1.0;
        }
        if (type.equals(2L)) {
            avgFeedbackValue = nezhaStatDto.getStatCvrAvg();
            lowerLimit = 0.8;
            upperLimit = 1.0;
            return;
        }
        Double correctionFactor = info.getCorrectionFactor();
        Double newCurrentPreValue = currentPreValue * correctionFactor;
        Double reconstructionValue = ModelPredRectifier.reconstructionValue(newCurrentPreValue, avgFeedbackValue, lowerLimit, upperLimit);
        Double reconstructionFactor = ModelPredRectifier.noiseSmoother(reconstructionValue / newCurrentPreValue, lowerLimit, upperLimit);
        info.setReconstructionFactor(reconstructionFactor);
    }

    public static Double noiseSmoother(Double point, Double lowerLimit, Double upperLimit) throws Exception {
        Double ret = point;
        if (AssertUtil.isAnyEmpty((Object[])new Object[]{upperLimit, lowerLimit})) {
            logger.warn((Object)("noiseSmoother input invalid,with upperLimit=" + upperLimit + ",lowerLimit=" + lowerLimit));
            return ret;
        }
        if (point != null) {
            ret = point > upperLimit ? upperLimit : (point < lowerLimit ? lowerLimit : point);
        }
        return ret;
    }

    public static Double correctionValue(Double currentPreValue, Double avgPreValue, Double avgFeedbackValue, Double lowerLimit, Double upperLimit) throws Exception {
        Double ret = currentPreValue;
        if (AssertUtil.isAnyEmpty((Object[])new Object[]{currentPreValue, avgPreValue, avgFeedbackValue, upperLimit, lowerLimit})) {
            return ret;
        }
        if (currentPreValue > 0.0 && avgPreValue > 0.0 && avgFeedbackValue > 0.0) {
            Double lndValue = ModelPredRectifier.noiseSmoother(currentPreValue * avgFeedbackValue / avgPreValue, lowerLimit, upperLimit);
            Double ndValue = ModelPredRectifier.noiseSmoother(currentPreValue + avgFeedbackValue - avgPreValue, lowerLimit, upperLimit);
            ret = avgPreValue > avgFeedbackValue ? Double.valueOf(Math.max(lndValue, ndValue)) : Double.valueOf(Math.min(lndValue, ndValue));
        }
        return ret;
    }

    public static Double reconstructionValue(Double newCurrentPreValue, Double avgFeedbackValue, Double lowerLimit, Double upperLimit) throws Exception {
        Double ret = newCurrentPreValue;
        if (AssertUtil.isAnyEmpty((Object[])new Object[]{newCurrentPreValue, avgFeedbackValue, upperLimit, lowerLimit})) {
            return ret;
        }
        if (newCurrentPreValue > 0.0 && avgFeedbackValue > 0.0 && newCurrentPreValue < avgFeedbackValue) {
            Double reconstructionValue;
            Double ratio = newCurrentPreValue / avgFeedbackValue;
            ret = reconstructionValue = Double.valueOf(newCurrentPreValue * ModelPredRectifier.sigmoidWithZoomAndIntervalMap(ratio - 0.5, lowerLimit, upperLimit, 10.0));
        }
        return ret;
    }

    public static Double sigmoidWithZoomAndIntervalMap(double x, double lowerLimit, double upperLimit, double zoom) {
        return lowerLimit + (upperLimit - lowerLimit) * ModelPredRectifier.sigmoidWithZoom(x, zoom);
    }

    public static Double sigmoidWithZoom(double x, double zoom) {
        return ModelPredRectifier.sigmoid(x * zoom);
    }

    public static Double sigmoid(double x) {
        return 1.0 / (1.0 + Math.exp(-x));
    }
}

