/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.compute.common.util;

import cn.com.duiba.nezha.compute.common.AssertUtil;
import cn.com.duiba.nezha.compute.common.dict.CategoryFeatureDict;
import cn.com.duiba.nezha.compute.common.util.OneHotUtil;
import cn.com.duiba.nezha.compute.common.util.SerializeTool;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CategoryFeatureDictUtil
implements Serializable {
    private Logger logger = LoggerFactory.getLogger((String)this.getClass().getName());
    private static final long serialVersionUID = -316102112618444930L;
    private CategoryFeatureDict dict = null;

    public void setFeatureDict(CategoryFeatureDict dict) {
        this.dict = dict;
    }

    public void setFeatureDict(String dictStr) {
        this.dict = this.getFeatureDict(dictStr);
    }

    public CategoryFeatureDict getFeatureDict() {
        return this.dict;
    }

    public CategoryFeatureDict getFeatureDict(String dictStr) {
        CategoryFeatureDict dict = (CategoryFeatureDict)SerializeTool.getObjectFromString(dictStr);
        return dict;
    }

    public String featureIdxList2Str(List<String> idxStr) {
        return SerializeTool.object2String(idxStr);
    }

    public List<String> getFeatureIdxList(String featureIdxStr) {
        return (List)SerializeTool.getObjectFromStr(featureIdxStr);
    }

    public String getFeatureDictStr(CategoryFeatureDict dict) {
        String ret = null;
        ret = SerializeTool.object2String(dict);
        return ret;
    }

    public String getFeatureDictStr() {
        String ret = null;
        ret = SerializeTool.object2String(this.dict);
        return ret;
    }

    public List<String> getFeature(String featureIdx) {
        if (this.dict == null) {
            this.logger.warn("dict is null");
            return null;
        }
        if (AssertUtil.isEmpty(featureIdx)) {
            this.logger.warn("getFeature param invalid");
            return null;
        }
        return this.dict.getFeatureDict().get(featureIdx);
    }

    public int getFeatureIdx(String featureIdx, String category) {
        int ret = -1;
        List<String> featureMap = this.getFeature(featureIdx);
        if (AssertUtil.isNotEmpty(featureMap)) {
            ret = featureMap.indexOf(category);
        }
        return ret;
    }

    public int getFeatureListSize(String featureIdx) {
        int ret = 0;
        List<String> featureMap = this.getFeature(featureIdx);
        if (AssertUtil.isNotEmpty(featureMap)) {
            ret = featureMap.size();
        }
        return ret;
    }

    public double[] featureOneHotDoubleEncode(String featureIdx, String category) {
        double[] ret = null;
        int idx = this.getFeatureIdx(featureIdx, category);
        int size = this.getFeatureListSize(featureIdx);
        if (AssertUtil.isNotEmpty(idx)) {
            ret = OneHotUtil.getOneHotDouble(idx, size);
        }
        return ret;
    }

    public int[] featureOneHotIntEncode(String featureIdx, String category) {
        int[] ret = null;
        int idx = this.getFeatureIdx(featureIdx, category);
        int size = this.getFeatureListSize(featureIdx);
        if (AssertUtil.isNotEmpty(idx)) {
            ret = OneHotUtil.getOneHotInt(idx, size);
        }
        return ret;
    }

    public double[] oneHotDoubleEncode(List<String> featureIdxList, List<String> categoryList) {
        double[] ret = null;
        if (AssertUtil.isAnyEmpty(featureIdxList, categoryList) || categoryList.size() != featureIdxList.size()) {
            return null;
        }
        try {
            for (int i = 0; i < featureIdxList.size(); ++i) {
                String category;
                String featureIdx = featureIdxList.get(i);
                double[] partRet = this.featureOneHotDoubleEncode(featureIdx, category = categoryList.get(i));
                if (partRet == null) {
                    return null;
                }
                ret = ArrayUtils.addAll(ret, (double[])partRet);
            }
        }
        catch (Exception e) {
            this.logger.error("oneHotDoubleEncode happend error", (Throwable)e);
        }
        return ret;
    }

    public double[] oneHotDoubleEncodeWithMap(List<String> featureIdxList, Map<String, String> categoryMap) {
        double[] ret = null;
        if (AssertUtil.isAnyEmpty(featureIdxList, categoryMap)) {
            return null;
        }
        try {
            int status = 1;
            ArrayList<String> categoryList = new ArrayList<String>();
            for (int i = 0; i < featureIdxList.size(); ++i) {
                String featureIdx = featureIdxList.get(i);
                if (!categoryMap.containsKey(featureIdx)) {
                    status = -1;
                    break;
                }
                String category = categoryMap.get(featureIdx);
                if (category != null) {
                    category = category.toLowerCase();
                }
                categoryList.add(category);
            }
            if (status == 1) {
                ret = this.oneHotDoubleEncode(featureIdxList, categoryList);
            }
        }
        catch (Exception e) {
            this.logger.error("oneHotIntEncode happend error", (Throwable)e);
        }
        return ret;
    }

    public int[] oneHotIntEncode(List<String> featureIdxList, List<String> categoryList) {
        int[] ret = null;
        if (AssertUtil.isAnyEmpty(featureIdxList, categoryList) || categoryList.size() != featureIdxList.size()) {
            return null;
        }
        try {
            for (int i = 0; i < featureIdxList.size(); ++i) {
                String category;
                String featureIdx = featureIdxList.get(i);
                int[] partRet = this.featureOneHotIntEncode(featureIdx, category = categoryList.get(i));
                if (partRet == null) {
                    return null;
                }
                ret = ArrayUtils.addAll(ret, (int[])partRet);
            }
        }
        catch (Exception e) {
            this.logger.error("oneHotIntEncode . happend error", (Throwable)e);
        }
        return ret;
    }

    public int[] oneHotIntEncodeWithMap(List<String> featureIdxList, Map<String, String> categoryMap) {
        int[] ret = null;
        if (AssertUtil.isAnyEmpty(featureIdxList, categoryMap)) {
            return null;
        }
        try {
            int status = 1;
            ArrayList<String> categoryList = new ArrayList<String>();
            for (int i = 0; i < featureIdxList.size(); ++i) {
                String featureIdx = featureIdxList.get(i);
                if (!categoryMap.containsKey(featureIdx)) {
                    status = -1;
                    break;
                }
                String category = categoryMap.get(featureIdx);
                categoryList.add(category);
            }
            if (status == 1) {
                ret = this.oneHotIntEncode(featureIdxList, categoryList);
            }
        }
        catch (Exception e) {
            this.logger.error("oneHotIntEncode happend error", (Throwable)e);
        }
        return ret;
    }
}

