/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.compute.common.util.es;

import cn.com.duiba.nezha.compute.common.util.MyStringUtil2;
import cn.com.duiba.nezha.compute.common.util.es.ESConfig;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.List;
import org.elasticsearch.client.transport.TransportClient;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.transport.InetSocketTransportAddress;
import org.elasticsearch.common.transport.TransportAddress;

public class ESPool {
    public static TransportClient client;

    private ESPool() {
    }

    public static ESPool getInstance() {
        return ESUtilHolder.instance;
    }

    public static void setPool(ESConfig esConfig) {
        String clusterName = esConfig.getClusterName();
        String clusterHostStr = esConfig.getClusterHostList();
        try {
            List<InetSocketTransportAddress> addressList = ESPool.getAddressList(clusterHostStr);
            if (addressList != null && clusterName != null) {
                Settings settings = Settings.builder().put("cluster.name", clusterName).build();
                client = TransportClient.builder().settings(settings).build().addTransportAddresses((TransportAddress[])addressList.toArray(new InetSocketTransportAddress[addressList.size()]));
                System.out.println("set es client");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static TransportClient getClient(ESConfig esConfig) {
        if (client == null) {
            ESPool.setPool(esConfig);
        }
        return client;
    }

    public static List<InetSocketTransportAddress> getAddressList(String nodesStrList) {
        ArrayList<InetSocketTransportAddress> addressList = null;
        try {
            List<String> nodeStrList;
            if (nodesStrList != null && (nodeStrList = MyStringUtil2.stringToList(nodesStrList, ",")) != null) {
                addressList = new ArrayList<InetSocketTransportAddress>();
                for (String nodeStr : nodeStrList) {
                    List<String> node = MyStringUtil2.stringToList(nodeStr, ":");
                    if (node == null || node.size() != 2) continue;
                    addressList.add(new InetSocketTransportAddress(InetAddress.getByName(node.get(0)), Integer.valueOf(node.get(1)).intValue()));
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return addressList;
    }

    private static class ESUtilHolder {
        private static final ESPool instance = new ESPool();

        private ESUtilHolder() {
        }
    }
}

