/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.compute.common.model;

import cn.com.duiba.nezha.compute.common.model.BernoulliMachine;
import cn.com.duiba.nezha.compute.common.model.BetaDistribution;
import java.util.ArrayList;

public class BayesianBandit {
    private ArrayList<BernoulliMachine> machines = new ArrayList();
    private ArrayList<Double> rewards = new ArrayList();
    private ArrayList<Double> counts = new ArrayList();
    private ArrayList<Double> averageReward = new ArrayList();
    private ArrayList<Double> alphas = new ArrayList();
    private ArrayList<Double> betas = new ArrayList();
    private int numMachines;
    public int curMachine;
    private int bestMachine;
    private double totalRewards = 0.0;
    private double decay = 0.9;

    public MaterialInfo selectMaterial(ArrayList<MaterialInfo> materialList, Long appId) {
        MaterialInfo material = new MaterialInfo();
        BayesianBandit bandit = new BayesianBandit();
        this.numMachines = materialList.size();
        int i = 0;
        for (MaterialInfo m : materialList) {
            ++i;
        }
        return materialList.get(this.numMachines - 1);
    }

    public double PullOnce() {
        int machineId = this.selectMachine();
        double reward = this.pullMachine(machineId);
        this.curMachine = machineId;
        this.updateBestMachine();
        return reward;
    }

    private int selectMachine() {
        int selectMachine = 0;
        double maxTheta = 0.0;
        for (int i = 0; i < this.numMachines; ++i) {
            double theta = BetaDistribution.BetaDist(1.0 + this.rewards.get(i), 1.0 + this.counts.get(i) - this.rewards.get(i));
            if (!(theta > maxTheta)) continue;
            maxTheta = theta;
            selectMachine = i;
        }
        return selectMachine;
    }

    private double pullMachine(int machineId) {
        this.counts.set(machineId, this.counts.get(machineId) * this.decay + 1.0);
        double reward = this.machines.get(machineId).Pull();
        this.rewards.set(machineId, this.rewards.get(machineId) * this.decay + reward);
        this.averageReward.set(machineId, this.rewards.get(machineId) / this.counts.get(machineId));
        this.totalRewards += reward;
        return reward;
    }

    private void updateBestMachine() {
        double highestAverageReward = 0.0;
        int bestMachine = 0;
        for (int i = 0; i < this.numMachines; ++i) {
            if (!(this.averageReward.get(i) > highestAverageReward)) continue;
            highestAverageReward = this.averageReward.get(i);
            bestMachine = i;
        }
        this.bestMachine = bestMachine;
    }

    private void SetMachine(int machineId, BernoulliMachine machine) {
        this.machines.add(machineId, machine);
    }

    public void AddMachine(BernoulliMachine machine) {
        this.machines.add(machine);
        this.rewards.add(1.0);
        this.counts.add(100.0);
        this.averageReward.add(0.0);
        this.alphas.add(0.0);
        this.betas.add(0.0);
        ++this.numMachines;
        if (this.numMachines == 1) {
            this.bestMachine = 0;
        }
    }

    private void RemoveMachine(int machineId) {
        this.machines.remove(machineId);
        this.rewards.remove(machineId);
        this.counts.remove(machineId);
        this.averageReward.remove(machineId);
        this.alphas.remove(machineId);
        this.betas.remove(machineId);
        --this.numMachines;
    }

    private void BatchPull(int times) {
        for (int i = 0; i < this.numMachines; ++i) {
            this.alphas.set(i, 1.0 + this.rewards.get(i));
            this.betas.set(i, 1.0 + this.counts.get(i) - this.rewards.get(i));
        }
        for (int t = 0; t < times; ++t) {
            int selectMachine = 0;
            double maxTheta = 0.0;
            for (int i = 0; i < this.numMachines; ++i) {
                double theta = BetaDistribution.BetaDist(this.alphas.get(i), this.betas.get(i));
                if (!(theta > maxTheta)) continue;
                maxTheta = theta;
                selectMachine = i;
            }
            this.pullMachine(selectMachine);
        }
        this.updateBestMachine();
    }

    private double TotalReward() {
        return this.totalRewards;
    }

    public int BestMachine() {
        return this.bestMachine;
    }

    public static class MaterialInfo {
        long materialId;
        long appId;
        double alpha;
        double beta;
        double reward;
        double count;
        ArrayList<Long> click;
        ArrayList<Long> exposure;
        long lastClick;
        long lastExposure;

        public void setAlpha(double alpha) {
            this.alpha = alpha;
        }

        public void setAppId(long appId) {
            this.appId = appId;
        }

        public void setBeta(double beta) {
            this.beta = beta;
        }

        public void setClick(ArrayList<Long> click) {
            this.click = click;
        }

        public void setCount(double count) {
            this.count = count;
        }

        public void setExposure(ArrayList<Long> exposure) {
            this.exposure = exposure;
        }

        public void setLastClick(long lastClick) {
            this.lastClick = lastClick;
        }

        public void setLastExposure(long lastExposure) {
            this.lastExposure = lastExposure;
        }

        public void setMaterialId(long materialId) {
            this.materialId = materialId;
        }

        public void setReward(double reward) {
            this.reward = reward;
        }

        public ArrayList<Long> getClick() {
            return this.click;
        }

        public ArrayList<Long> getExposure() {
            return this.exposure;
        }

        public double getAlpha() {
            return this.alpha;
        }

        public double getBeta() {
            return this.beta;
        }

        public double getCount() {
            return this.count;
        }

        public double getReward() {
            return this.reward;
        }

        public long getAppId() {
            return this.appId;
        }

        public long getLastClick() {
            return this.lastClick;
        }

        public long getLastExposure() {
            return this.lastExposure;
        }

        public long getMaterialId() {
            return this.materialId;
        }
    }
}

