/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.compute.common.model;

public class RoiPidController {
    private double P = 0.0;
    private double I = 0.0;
    private double D = 0.0;
    private double F = 0.0;
    private boolean firstRun = true;
    private double errorSum = 0.0;
    private double lastOutput = 0.0;
    private double lastActual = 0.0;
    private double lastFactor = 0.0;
    private double maxIOutput = 0.0;
    private double maxError = 0.0;
    private double maxOutput = 0.0;
    private double minOutput = 0.0;
    private double outputRampRate = 0.0;
    private double outputFilter = 0.0;

    public RoiPidController() {
        this.P = 0.5;
        this.I = 0.01;
        this.D = 0.5;
        this.checkSigns();
    }

    public double getSensitivity(double factor, double targetCpa, double budget) {
        double senitivity = 1.0;
        if (budget <= 0.0) {
            return 1.0;
        }
        if (budget / targetCpa < 30.0 || targetCpa > 4000.0 || factor < 0.5 || factor > 1.5) {
            senitivity = 1.15;
        }
        return senitivity;
    }

    public double getPriceFactor(double sumFee, double sumConv, double lastSumFee, double lastSumConv, double factor, double targetCpa, double budget) {
        if (sumFee <= 0.0 || sumConv <= 0.0 || lastSumFee < 0.0 || lastSumConv < 0.0 || factor <= 0.0 || targetCpa <= 0.0) {
            return 1.0;
        }
        if (sumFee < 20000.0 && sumConv <= 5.0) {
            return 1.0;
        }
        this.reset();
        double actual = sumFee / sumConv;
        this.setOutputLimits(targetCpa);
        double senitivity = 1.0;
        this.firstRun = lastSumFee == 0.0;
        this.lastFactor = factor;
        this.lastOutput = lastSumConv > 0.0 ? this.lastFactor * targetCpa - 1.0 : 0.0;
        this.lastActual = lastSumConv > 0.0 ? lastSumFee / lastSumConv : actual;
        this.maxError = 100.0;
        this.errorSum = this.constrain(lastSumConv * targetCpa - lastSumFee, -this.maxError, this.maxError);
        senitivity = this.getSensitivity(factor, targetCpa, budget);
        double output = this.getOutput(actual, targetCpa);
        if (output < 0.0) {
            factor = this.lastFactor * Math.max(1.0 + output / targetCpa, 0.9 / senitivity);
            factor = targetCpa < actual ? Math.max(factor, 0.5 * targetCpa / actual) : Math.max(factor, 0.5);
        } else {
            factor = this.lastFactor * Math.min(1.0 + output / targetCpa, 1.1 * senitivity);
            factor = targetCpa > actual ? Math.min(factor, 2.0 * targetCpa / actual) : Math.min(factor, 2.0);
        }
        return factor;
    }

    private RoiPidController(double p, double i, double d) {
        this.P = p;
        this.I = i;
        this.D = d;
        this.checkSigns();
    }

    private RoiPidController(double p, double i, double d, double f) {
        this.P = p;
        this.I = i;
        this.D = d;
        this.F = f;
        this.checkSigns();
    }

    private void setI(double i) {
        if (this.I != 0.0) {
            this.errorSum = this.errorSum * this.I / i;
        }
        if (this.maxIOutput != 0.0) {
            this.maxError = this.maxIOutput / i;
        }
        this.I = i;
        this.checkSigns();
    }

    private void setPID(double p, double i, double d) {
        this.P = p;
        this.D = d;
        this.setI(i);
        this.checkSigns();
    }

    private void setPID(double p, double i, double d, double f) {
        this.P = p;
        this.D = d;
        this.F = f;
        this.setI(i);
        this.checkSigns();
    }

    private void setMaxIOutput(double maximum) {
        this.maxIOutput = maximum;
        if (this.I != 0.0) {
            this.maxError = this.maxIOutput / this.I;
        }
    }

    private void setOutputLimits(double output) {
        this.setOutputLimits(-output, output);
    }

    private void setOutputLimits(double minimum, double maximum) {
        if (maximum < minimum) {
            return;
        }
        this.maxOutput = maximum;
        this.minOutput = minimum;
        if (this.maxIOutput == 0.0 || this.maxIOutput > maximum - minimum) {
            this.setMaxIOutput(maximum - minimum);
        }
    }

    private double getOutput(double actual, double setpoint) {
        double error = setpoint - actual;
        double Foutput = this.F * setpoint;
        double Poutput = this.P * error;
        if (this.firstRun) {
            this.lastActual = actual;
            this.lastOutput = Poutput + Foutput;
            this.firstRun = false;
        }
        double Doutput = -this.D * (actual - this.lastActual);
        this.lastActual = actual;
        double Ioutput = this.I * this.errorSum;
        if (this.maxIOutput != 0.0) {
            Ioutput = this.constrain(Ioutput, -this.maxIOutput, this.maxIOutput);
        }
        double output = Foutput + Poutput + Ioutput + Doutput;
        this.errorSum = this.minOutput != this.maxOutput && !this.bounded(output, this.minOutput, this.maxOutput) ? error : (this.outputRampRate != 0.0 && !this.bounded(output, this.lastOutput - this.outputRampRate, this.lastOutput + this.outputRampRate) ? error : (this.maxIOutput != 0.0 ? this.constrain(this.errorSum + error, -this.maxError, this.maxError) : (this.errorSum += error)));
        if (this.outputRampRate != 0.0) {
            output = this.constrain(output, this.lastOutput - this.outputRampRate, this.lastOutput + this.outputRampRate);
        }
        if (this.minOutput != this.maxOutput) {
            output = this.constrain(output, this.minOutput, this.maxOutput);
        }
        if (this.outputFilter != 0.0) {
            output = this.lastOutput * this.outputFilter + output * (1.0 - this.outputFilter);
        }
        this.lastOutput = output;
        return output;
    }

    private void reset() {
        this.firstRun = true;
        this.errorSum = 0.0;
    }

    private void setOutputRampRate(double rate) {
        this.outputRampRate = rate;
    }

    private void setOutputFilter(double strength) {
        if (strength == 0.0 || this.bounded(strength, 0.0, 1.0)) {
            this.outputFilter = strength;
        }
    }

    private double constrain(double value, double min, double max) {
        if (value > max) {
            return max;
        }
        if (value < min) {
            return min;
        }
        return value;
    }

    private boolean bounded(double value, double min, double max) {
        return min < value && value < max;
    }

    private void checkSigns() {
        if (this.P < 0.0) {
            this.P *= -1.0;
        }
        if (this.I < 0.0) {
            this.I *= -1.0;
        }
        if (this.D < 0.0) {
            this.D *= -1.0;
        }
        if (this.F < 0.0) {
            this.F *= -1.0;
        }
    }

    public static void main(String[] args) {
        RoiPidController PID = new RoiPidController();
        double sumPrice = 1000.0;
        double sumConv = 2.0;
        double lastSumPrice = 800.0;
        double lastSumConv = 1.0;
        double factor = 1.0;
        double bidOld = 1500.0;
        double maxConv = 100.0;
        double targetCpa = 3000.0;
        double actualCpa = sumPrice / sumConv;
        System.err.printf("Target\tActual\tFactor\tBid\tsumFee\tsumConv\n", new Object[0]);
        for (int i = 0; i < 200; ++i) {
            double random2;
            if (i == 60) {
                targetCpa = 3000.0;
            }
            factor = PID.getPriceFactor(sumPrice, sumConv, lastSumPrice, lastSumConv, factor, targetCpa, 30000.0);
            double random = 1.0;
            double random1 = Math.random();
            random = random1 > (random2 = Math.random()) ? 1.0 + random1 : 1.0 - random2;
            double bid = bidOld * factor;
            bid = Math.max(bid, 1.0);
            bid = Math.min(3000.0, bid);
            System.err.printf("%3.2f\t%3.2f\t%3.2f\t%3.2f\t%3.0f\t%3.0f\n", targetCpa, actualCpa, factor, bid, sumPrice, sumConv);
            lastSumConv = sumConv;
            lastSumPrice = sumPrice;
            double conv = Math.min(Math.pow(1.5, bid), maxConv);
            actualCpa = (sumPrice += bid * conv) / (sumConv += conv);
        }
    }
}

