package cn.com.duiba.nezha.compute.common.model;

import java.util.List;

/**
 * Created by jiali on 2017/6/7.
 */
public class RoiPidController {

    private double P = 0;
    private double I = 0;
    private double D = 0;
    private double F = 0;

    private boolean firstRun=true;
    private double errorSum=0;
    private double lastOutput=0;
    private double lastActual=0;
    private double lastFactor=0;

    private double maxIOutput=0;
    private double maxError=0;
    private double maxOutput=0;
    private double minOutput=0;

    private double outputRampRate=0;
    private double outputFilter=0;

    static class Constant{

        //默认调价因子
        static  double DEFAULT_FACTOR = 1;

        //控制器参数
        static double DEFAULT_P = 0.5;
        static double DEFAULT_I = 0.01;
        static double DEFAULT_D = 0.5;

        //控制器敏感度
        static double SENSITIVITY_DEFAULT = 1.0;
        static double SENSITIVITY_USE = 1.15;
    }

    public RoiPidController(){
        P = Constant.DEFAULT_P;
        I = Constant.DEFAULT_I;
        D = Constant.DEFAULT_D;
        checkSigns();
    }

    public double getSensitivity(double factor, double targetCpa, double budget)
    {
        double senitivity = 1;
        if(budget <= 0)
            return 1;
        if(budget/targetCpa < 30 || targetCpa > 4000 || factor<0.5 || factor > 1.5 )
        {
            senitivity = Constant.SENSITIVITY_USE;
        }
        return senitivity;
    }



    public void newGetPriceFactor(StatInfo packageInfo, List<StatInfo> appInfo, List<StatInfo> slotInfo,List<StatInfo> activityInfo, double targetCpa)
    {
        //优先级控制
        for(StatInfo info : activityInfo)
        {
            if(!checkDataVolume(info, targetCpa)) {
                info.factor = 1;
                continue;
            }

            //info.factor = getOnePriceFactor(info, targetCpa);
        }
    }

    private boolean checkDataVolume(StatInfo info, double targetCpa)
    {
        boolean isValid = true;
        if(info.sumFee <= 0 || info.sumConv <=0 || info.lastSumFee < 0 || info.lastSumConv <0 || info.factor <= 0 || targetCpa <= 0)
        {
            isValid = false;
        }

        if(isColdStarting(info.sumFee, info.sumConv))
        {
            isValid = false;
        }

        return isValid;
    }

    private boolean isColdStarting(double sumFee,double sumConv)
    {
        if(sumFee < 20000 && sumConv <= 5)
            return true;
        return false;
    }

    public double getPriceFactor(double sumFee, double sumConv, double lastSumFee, double lastSumConv, double factor, double targetCpa, double budget)
    {
        //1、check param
        if(sumFee <= 0 || sumConv <=0 || lastSumFee < 0 || lastSumConv <0 || factor <= 0 || targetCpa <= 0)
        {
            return Constant.DEFAULT_FACTOR;
        }

        if(isColdStarting(sumFee,sumConv))
        {
            return Constant.DEFAULT_FACTOR;
        }

        //2、初始化控制器
        reset();
        double actual = sumFee / sumConv;
        setOutputLimits(targetCpa);
        double senitivity = 1;
        //3、计算上一次调控的状态
        if(lastSumFee == 0)
        {
            firstRun = true;
        }
        else
        {
            firstRun = false;
        }
        lastFactor = factor;
        lastOutput = lastSumConv > 0 ? lastFactor * targetCpa - 1 : 0; //近似算法
        lastActual = lastSumConv > 0 ? lastSumFee / lastSumConv : actual;
        maxError = 100;
        errorSum = constrain(lastSumConv * targetCpa - lastSumFee,-maxError,maxError);//近似算法
        senitivity = getSensitivity(factor, targetCpa, budget);

        //4、调控
        double output = getOutput(actual, targetCpa);

        //5、调价因子平滑
        if(output < 0) {
            factor = lastFactor * Math.max(1 + output / targetCpa, 0.9/senitivity);
            if(targetCpa < actual)
                factor = Math.max(factor, 0.5*targetCpa/actual);
            else
                factor = Math.max(factor, 0.5);
        }
        else {
            factor = lastFactor * Math.min(1 + output / targetCpa, 1.1*senitivity);
            if(targetCpa > actual)
                factor = Math.min(factor, 2*targetCpa/actual);
            else
                factor = Math.min(factor, 2);
        }

        return factor;
    }

    private RoiPidController(double p, double i, double d){
        P=p; I=i; D=d;
        checkSigns();
    }

    private RoiPidController(double p, double i, double d, double f){
        P=p; I=i; D=d; F=f;
        checkSigns();
    }

    private void setI(double i){  /*I翻倍，累计错误减半*/
        if(I != 0){
            errorSum = errorSum * I / i;
        }
        if(maxIOutput!=0){
            maxError = maxIOutput / i;
        }
        I = i;
        checkSigns();
    }


    private void setPID(double p, double i, double d){
        P=p;D=d;
        setI(i);    //积分项具有额外的计算，需要专门set
        checkSigns();
    }
    private void setPID(double p, double i, double d,double f){
        P=p;D=d;F=f;
        setI(i);
        checkSigns();
    }

    private void setMaxIOutput(double maximum){
        maxIOutput = maximum;
        if(I!=0){
            maxError = maxIOutput/I;
        }
    }

    private void setOutputLimits(double output){
        setOutputLimits(-output,output);
    }

    private void setOutputLimits(double minimum,double maximum){
        if(maximum < minimum)return;
        maxOutput=maximum;
        minOutput=minimum;

        // Ensure the bounds of the I term are within the bounds of the allowable output swing
        if(maxIOutput==0 || maxIOutput>(maximum-minimum) ){
            setMaxIOutput(maximum-minimum);
        }
    }

    private double getOutput(double actual, double setpoint){
        double output;
        double Poutput;
        double Ioutput;
        double Doutput;
        double Foutput;

        double error = setpoint - actual;

        Foutput = F * setpoint;
        Poutput = P * error;

        if(firstRun){
            lastActual = actual;
            lastOutput = Poutput + Foutput;
            firstRun = false;
        }

        // D：负数，减缓控制系统，防止调整信号突变与超调
        Doutput = - D * (actual - lastActual);
        lastActual = actual;

        // I: 积分项
        // 1. maxIoutput 限制了I项的权重。
        // 2. prevent windup by not increasing errorSum if we're already running against our max Ioutput
        // 3. prevent windup by not increasing errorSum if output is output= maxOutput
        Ioutput = I * errorSum;
        if(maxIOutput != 0){
            Ioutput = constrain(Ioutput, -maxIOutput, maxIOutput);
        }

        output = Foutput + Poutput + Ioutput + Doutput;

        // error平滑
        if(minOutput != maxOutput && !bounded(output, minOutput,maxOutput) ){ //error超出限制重置，让系统更平滑。P充分大，I开始作用。
            errorSum = error;
        }
        else if(outputRampRate!=0 && !bounded(output, lastOutput-outputRampRate,lastOutput+outputRampRate) ){
            errorSum = error;
        }
        else if(maxIOutput!=0){
            errorSum = constrain(errorSum + error,-maxError,maxError);
        }
        else{
            errorSum += error;
        }

        // 控制信号平滑
        if(outputRampRate!=0){
            output = constrain(output, lastOutput - outputRampRate,lastOutput + outputRampRate);
        }
        if(minOutput!=maxOutput){
            output = constrain(output, minOutput,maxOutput);
        }
        if(outputFilter!=0){
            output = lastOutput*outputFilter+output*(1-outputFilter);
        }

        lastOutput = output;
        return output;
    }

    private void reset(){
        firstRun=true;
        errorSum=0;
    }

    private void setOutputRampRate(double rate){
        outputRampRate=rate;
    }


    private void setOutputFilter(double strength){
        if(strength==0 || bounded(strength,0,1)){
            outputFilter=strength;
        }
    }

    private double constrain(double value, double min, double max){
        if(value > max){ return max;}
        if(value < min){ return min;}
        return value;
    }

    private boolean bounded(double value, double min, double max){
        return (min<value) && (value < max);
    }

    private void checkSigns(){
        if(P<0) P *= -1;
        if(I<0) I *= -1;
        if(D<0) D *= -1;
        if(F<0) F *= -1;
    }

    public static void main(String[] args) {

        RoiPidController PID = new RoiPidController();
        double sumPrice = 1000;
       // var budget = 300000;
        double sumConv = 2;
        double lastSumPrice = 800;
        double lastSumConv = 1;
        double factor = 1;
        double bidOld = 1500;
        double maxConv = 100;
        double targetCpa = 3000;
        double actualCpa = sumPrice / sumConv;

        System.err.printf("Target\tActual\tFactor\tBid\tsumFee\tsumConv\n");

        for (int i = 0; i < 200; i++){

            if (i == 60)
                targetCpa = 3000;
            factor = PID.getPriceFactor(sumPrice, sumConv, lastSumPrice, lastSumConv, factor, targetCpa, 30000);

            double random = 1;
            double random1 = Math.random();
            double random2 = Math.random();
            if(random1 > random2)
                random = 1 + random1;
            else
                random = 1 - random2;
            double bid = bidOld * factor ;

            bid = Math.max(bid,1);
            bid = Math.min(3000,bid);

            //System.err.printf("%3.2f\t%3.2f\t%3.2f\t%3.2f\t%3.0f\t%3.0f\n", targetCpa, actualCpa, factor, bid, sumPrice, sumConv);
            lastSumConv = sumConv;
            lastSumPrice = sumPrice;

            double conv = Math.min(Math.pow(1.5, bid), maxConv);
            sumPrice += bid * conv;
            sumConv += conv;
            actualCpa =  sumPrice / sumConv;
        }
    }
}

