package cn.com.duiba.nezha.compute.common.model;
import java.util.ArrayList;

/**
 * Created by jiali on 2017/6/9.
 */

public class BayesianBandit {
    private ArrayList<Double> rewards;
    private ArrayList<Double> counts;
    private ArrayList<Double> clicks;
    private ArrayList<Double> exposures;
    private ArrayList<Double> alphas;
    private ArrayList<Double> betas;
    private int numMachines;
    private double decay = 1;

    static class Constant{
        static double RT_CTR_WEIGHT = 0.3;
        static double BATCH_SIZE = 1;
        static long MAX_CLICK = 1000;
        static long DISCOUNT = 2;
        static double DECAY = 0.9995;  //2000次以前的观察，无效
    }

    public MaterialInfo selectMaterial(ArrayList<MaterialInfo> materialList, Long appId)
    {
        //1、init
        clear();
        MaterialInfo material = new MaterialInfo();
        this.decay = Constant.DECAY;
        numMachines = materialList.size();

        //2、update
        for(MaterialInfo m : materialList)
        {
            double click = 0.0;
            double exposure = 0.0;
            for(Long clk: m.click)           //最多存24小时
            {
                click += clk;
            }
            clicks.add(click);
            for(Long exp: m.exposure)
            {
                exposure += exp;
            }
            exposures.add(exposure);

            if(exposure > 0) {

                if (m.lastClick > Constant.MAX_CLICK) {
                    m.lastClick = m.lastClick / Constant.DISCOUNT;
                    m.lastExposure = m.lastExposure / Constant.DISCOUNT;
                }

                if (m.lastClick == 0) {
                    m.lastClick = m.lastClick + (long) click;
                    m.lastExposure = m.lastExposure + (long) exposure;
                } else if (Math.random() < 1.0 / (1 + click))          //sample history
                {
                    m.lastClick = m.lastClick + (long) click;
                    m.lastExposure = m.lastExposure + (long) exposure;
                }

                double rtCtr = exposure > 0 ? click * 1.0 / exposure : 0; //最近ctr会低估
                double hisCtr = m.lastExposure > 0 ? m.lastClick * 1.0 / m.lastExposure : 0;
                double reward = click > 0 ? Constant.RT_CTR_WEIGHT * rtCtr + (1-Constant.RT_CTR_WEIGHT) * hisCtr : hisCtr;
                reward = Math.max(reward, 0.01);
                m.reward = m.reward * decay + reward;
                m.count = m.count * decay + 1.0;
                m.alpha = 1.0 + m.reward / Constant.BATCH_SIZE;
                m.beta = 1.0 + (m.count - m.reward) / Constant.BATCH_SIZE;

                if (m.beta > Constant.MAX_CLICK / Constant.BATCH_SIZE) {
                    m.reward = m.reward / Constant.DISCOUNT;
                    m.count = m.count / Constant.DISCOUNT;
                }
            }

            rewards.add(m.reward);
            counts.add(m.count);
            alphas.add(m.alpha);
            betas.add(m.beta);
        }

        //3、select
        int index = selectMachine();
        material = materialList.get(index);

        return material;
    }


    public BayesianBandit() { //下周
        rewards = new ArrayList<Double>();
        counts = new ArrayList<Double>();
        clicks = new ArrayList<Double>();
        exposures = new ArrayList<Double>();
        alphas = new ArrayList<Double>();
        betas = new ArrayList<Double>();
    }

    private void clear()
    {
        rewards = new ArrayList<Double>();
        counts = new ArrayList<Double>();
        clicks = new ArrayList<Double>();
        exposures = new ArrayList<Double>();
        alphas = new ArrayList<Double>();
        betas = new ArrayList<Double>();
    }


    /*对各个备选策略的后验Beta分布采样得到当次最优策略*/
    private int selectMachine() {
        int selectMachine = 0;
        double maxTheta = 0;
        for (int i = 0; i < numMachines; i++) {
            double theta = BetaDistribution.BetaDist(alphas.get(i), betas.get(i));
            if (theta > maxTheta) {
                maxTheta = theta;
                selectMachine = i;
            }
        }

        return selectMachine;
    }

}