/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.compute.common.model;

import cn.com.duiba.nezha.compute.common.model.BetaDistribution;
import cn.com.duiba.nezha.compute.common.model.MaterialInfo;
import java.util.ArrayList;

public class BayesianBandit {
    private ArrayList<Double> rewards = new ArrayList();
    private ArrayList<Double> counts = new ArrayList();
    private ArrayList<Double> clicks = new ArrayList();
    private ArrayList<Double> exposures = new ArrayList();
    private ArrayList<Double> alphas = new ArrayList();
    private ArrayList<Double> betas = new ArrayList();
    private int numMachines;
    private double decay = 1.0;

    public MaterialInfo selectMaterial(ArrayList<MaterialInfo> materialList, Long appId) {
        this.clear();
        MaterialInfo material = new MaterialInfo();
        this.decay = Constant.DECAY;
        this.numMachines = materialList.size();
        for (MaterialInfo m : materialList) {
            double click = 0.0;
            double exposure = 0.0;
            for (Long clk : m.click) {
                click += (double)clk.longValue();
            }
            this.clicks.add(click);
            for (Long exp : m.exposure) {
                exposure += (double)exp.longValue();
            }
            this.exposures.add(exposure);
            if (exposure > 0.0) {
                if (m.lastClick == 0.0) {
                    m.reward = 0.0;
                    m.count = 0.0;
                }
                if (m.lastClick > (double)Constant.VALID_CLICK_THRESHOLD) {
                    m.lastClick /= (double)Constant.DISCOUNT;
                    m.lastExposure /= (double)Constant.DISCOUNT;
                }
                m.lastClick += this.getCtr(exposure, click);
                m.lastExposure += 1.0;
                double rtCtr = this.getCtr(exposure, click);
                double hisCtr = this.getCtr(m.lastExposure, m.lastClick);
                double reward = click > 0.0 ? Constant.RT_CTR_WEIGHT * rtCtr + (1.0 - Constant.RT_CTR_WEIGHT) * hisCtr : hisCtr;
                reward = Math.max(reward, Constant.MIN_REWARD);
                m.reward = m.reward * this.decay + reward;
                m.count = m.count * this.decay + 1.0;
                m.alpha = 1.0 + m.reward / Constant.BATCH_SIZE;
                m.beta = 1.0 + (m.count - m.reward) / Constant.BATCH_SIZE;
                if (m.beta > (double)Constant.VALID_CLICK_THRESHOLD / (Constant.BATCH_SIZE * 10.0)) {
                    m.reward /= (double)Constant.DISCOUNT;
                    m.count /= (double)Constant.DISCOUNT;
                }
            }
            this.rewards.add(m.reward);
            this.counts.add(m.count);
            this.alphas.add(m.alpha);
            this.betas.add(m.beta);
        }
        material = materialList.get(this.selectMachine());
        return material;
    }

    private void clear() {
        this.rewards = new ArrayList();
        this.counts = new ArrayList();
        this.clicks = new ArrayList();
        this.exposures = new ArrayList();
        this.alphas = new ArrayList();
        this.betas = new ArrayList();
    }

    private int selectMachine() {
        int selectMachine = 0;
        double maxTheta = 0.0;
        for (int i = 0; i < this.numMachines; ++i) {
            double theta = BetaDistribution.BetaDist(this.alphas.get(i), this.betas.get(i));
            if (!(theta > maxTheta)) continue;
            maxTheta = theta;
            selectMachine = i;
        }
        return selectMachine;
    }

    private double getCtr(double exp, double clk) {
        return exp > 0.0 ? clk / exp : 0.0;
    }

    static class Constant {
        static double RT_CTR_WEIGHT = 0.03;
        static double BATCH_SIZE = 1.0;
        static double MIN_REWARD = 0.01;
        static long VALID_CLICK_THRESHOLD = 1000L;
        static long DISCOUNT = 2L;
        static double DECAY = 0.9995;

        Constant() {
        }
    }
}

