/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.compute.common.model;

import cn.com.duiba.nezha.compute.common.model.StatInfo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class RoiPidController {
    private double P = 0.0;
    private double I = 0.0;
    private double D = 0.0;
    private double F = 0.0;
    private boolean firstRun = true;
    private double errorSum = 0.0;
    private double lastOutput = 0.0;
    private double lastActual = 0.0;
    private double lastFactor = 0.0;
    private double maxIOutput = 0.0;
    private double maxError = 0.0;
    private double maxOutput = 0.0;
    private double minOutput = 0.0;
    private double outputRampRate = 0.0;
    private double outputFilter = 0.0;

    public RoiPidController() {
        this.P = Constant.DEFAULT_P;
        this.I = Constant.DEFAULT_I;
        this.D = Constant.DEFAULT_D;
        this.checkSigns();
    }

    public double getSensitivity(double factor, double targetCpa, double budget) {
        double senitivity = Constant.SENSITIVITY_DEFAULT;
        if (budget <= 0.0 || targetCpa <= 0.0) {
            return senitivity;
        }
        if (budget / targetCpa < 30.0 || targetCpa > 4000.0 || factor < 0.5 || factor > 1.5) {
            senitivity = Constant.SENSITIVITY_USE;
        }
        return senitivity;
    }

    public List<StatInfo> getPriceFactor(List<StatInfo> infos, double targetCpa, double budget) {
        ArrayList<StatInfo> newInfos = new ArrayList<StatInfo>();
        HashMap<String, Double> factorMap = new HashMap<String, Double>();
        for (StatInfo info : infos) {
            if (!(info.lastSumFee > 0.0)) continue;
            factorMap.put(info.id, info.factor);
        }
        for (StatInfo info : infos) {
            if (!(info.sumFee - info.lastSumFee > 2000.0) || !this.checkDataVolume(info, targetCpa) && !info.id.contains("DEFAULT")) continue;
            if (info.lastSumFee == 0.0) {
                String prefix;
                if (info.id.contains("SLOT")) {
                    prefix = info.id.split("SLOT")[0];
                    info.factor = factorMap.containsKey(prefix + "DEFAULT") ? (Double)factorMap.get(prefix + "DEFAULT") : 1.0;
                } else if (info.id.contains("ACTIVITY")) {
                    prefix = info.id.split("ACTIVITY")[0];
                    info.factor = factorMap.containsKey(prefix + "DEFAULT") ? (Double)factorMap.get(prefix + "DEFAULT") : 1.0;
                    String[] array = info.id.split("_");
                    if (array.length >= 4) {
                        String postfix = array[3];
                        info.factor = factorMap.containsKey(prefix + "APP_" + postfix) ? (Double)factorMap.get(prefix + "APP_" + postfix) : info.factor;
                    }
                } else if (info.id.contains("APP")) {
                    prefix = info.id.split("APP")[0];
                    info.factor = factorMap.containsKey(prefix + "DEFAULT") ? (Double)factorMap.get(prefix + "DEFAULT") : 1.0;
                }
            }
            info.factor = this.getOnePriceFactor(info, targetCpa, budget);
            info.lastSumFee = info.sumFee;
            info.lastSumConv = info.sumConv;
            newInfos.add(info);
        }
        factorMap.clear();
        return newInfos;
    }

    private double getOnePriceFactor(StatInfo info, double targetCpa, double budget) {
        if (!this.checkDataVolume(info, targetCpa)) {
            info.factor = 1.0;
            return info.factor;
        }
        this.reset();
        double actual = info.sumFee / info.sumConv;
        this.setOutputLimits(targetCpa);
        double senitivity = Constant.SENSITIVITY_DEFAULT;
        this.firstRun = info.lastSumFee == 0.0;
        this.lastFactor = info.factor;
        this.lastOutput = info.lastSumConv > 0.0 ? this.lastFactor * targetCpa - 1.0 : 0.0;
        this.lastActual = info.lastSumConv > 0.0 ? info.lastSumFee / info.lastSumConv : actual;
        this.maxError = 100.0;
        this.errorSum = this.constrain(info.lastSumConv * targetCpa - info.lastSumFee, -this.maxError, this.maxError);
        senitivity = this.getSensitivity(info.factor, targetCpa, budget);
        double output = this.getOutput(actual, targetCpa);
        if (output < 0.0) {
            info.factor = this.lastFactor * Math.max(1.0 + output / targetCpa, 0.9 / senitivity);
            info.factor = targetCpa < actual ? Math.max(info.factor, 0.3 * targetCpa / actual) : Math.max(info.factor, 0.3);
        } else {
            info.factor = this.lastFactor * Math.min(1.0 + output / targetCpa, 1.1 * senitivity);
            info.factor = targetCpa > actual ? Math.min(info.factor, 3.0 * targetCpa / actual) : Math.min(info.factor, 3.0);
        }
        return info.factor;
    }

    private boolean checkDataVolume(StatInfo info, double targetCpa) {
        boolean isValid = true;
        if (info.sumFee <= 0.0 || info.sumConv <= 0.0 || info.lastSumFee < 0.0 || info.lastSumConv < 0.0 || info.factor <= 0.0 || targetCpa <= 0.0) {
            isValid = false;
        }
        if (this.isColdStarting(info.sumFee, info.sumConv, targetCpa)) {
            isValid = false;
        }
        return isValid;
    }

    private boolean isColdStarting(double sumFee, double sumConv, double targetCpa) {
        return sumFee <= targetCpa * 5.0 && sumConv <= 3.0;
    }

    public double getPriceFactor(double sumFee, double sumConv, double lastSumFee, double lastSumConv, double factor, double targetCpa, double budget) {
        if (sumFee <= 0.0 || sumConv <= 0.0 || lastSumFee < 0.0 || lastSumConv < 0.0 || factor <= 0.0 || targetCpa <= 0.0) {
            return Constant.DEFAULT_FACTOR;
        }
        if (this.isColdStarting(sumFee, sumConv, targetCpa)) {
            return Constant.DEFAULT_FACTOR;
        }
        this.reset();
        double actual = sumFee / sumConv;
        this.setOutputLimits(targetCpa);
        double senitivity = 1.0;
        this.firstRun = lastSumFee == 0.0;
        this.lastFactor = factor;
        this.lastOutput = lastSumConv > 0.0 ? this.lastFactor * targetCpa - 1.0 : 0.0;
        this.lastActual = lastSumConv > 0.0 ? lastSumFee / lastSumConv : actual;
        this.maxError = 100.0;
        this.errorSum = this.constrain(lastSumConv * targetCpa - lastSumFee, -this.maxError, this.maxError);
        senitivity = this.getSensitivity(factor, targetCpa, budget);
        double output = this.getOutput(actual, targetCpa);
        if (output < 0.0) {
            factor = this.lastFactor * Math.max(1.0 + output / targetCpa, 0.9 / senitivity);
            factor = targetCpa < actual ? Math.max(factor, 0.5 * targetCpa / actual) : Math.max(factor, 0.5);
        } else {
            factor = this.lastFactor * Math.min(1.0 + output / targetCpa, 1.1 * senitivity);
            factor = targetCpa > actual ? Math.min(factor, 2.0 * targetCpa / actual) : Math.min(factor, 2.0);
        }
        return factor;
    }

    private RoiPidController(double p, double i, double d) {
        this.P = p;
        this.I = i;
        this.D = d;
        this.checkSigns();
    }

    private RoiPidController(double p, double i, double d, double f) {
        this.P = p;
        this.I = i;
        this.D = d;
        this.F = f;
        this.checkSigns();
    }

    private void setI(double i) {
        if (this.I != 0.0) {
            this.errorSum = this.errorSum * this.I / i;
        }
        if (this.maxIOutput != 0.0) {
            this.maxError = this.maxIOutput / i;
        }
        this.I = i;
        this.checkSigns();
    }

    private void setPID(double p, double i, double d) {
        this.P = p;
        this.D = d;
        this.setI(i);
        this.checkSigns();
    }

    private void setPID(double p, double i, double d, double f) {
        this.P = p;
        this.D = d;
        this.F = f;
        this.setI(i);
        this.checkSigns();
    }

    private void setMaxIOutput(double maximum) {
        this.maxIOutput = maximum;
        if (this.I != 0.0) {
            this.maxError = this.maxIOutput / this.I;
        }
    }

    private void setOutputLimits(double output) {
        this.setOutputLimits(-output, output);
    }

    private void setOutputLimits(double minimum, double maximum) {
        if (maximum < minimum) {
            return;
        }
        this.maxOutput = maximum;
        this.minOutput = minimum;
        if (this.maxIOutput == 0.0 || this.maxIOutput > maximum - minimum) {
            this.setMaxIOutput(maximum - minimum);
        }
    }

    private double getOutput(double actual, double setpoint) {
        double error = setpoint - actual;
        double Foutput = this.F * setpoint;
        double Poutput = this.P * error;
        if (this.firstRun) {
            this.lastActual = actual;
            this.lastOutput = Poutput + Foutput;
            this.firstRun = false;
        }
        double Doutput = -this.D * (actual - this.lastActual);
        this.lastActual = actual;
        double Ioutput = this.I * this.errorSum;
        if (this.maxIOutput != 0.0) {
            Ioutput = this.constrain(Ioutput, -this.maxIOutput, this.maxIOutput);
        }
        double output = Foutput + Poutput + Ioutput + Doutput;
        this.errorSum = this.minOutput != this.maxOutput && !this.bounded(output, this.minOutput, this.maxOutput) ? error : (this.outputRampRate != 0.0 && !this.bounded(output, this.lastOutput - this.outputRampRate, this.lastOutput + this.outputRampRate) ? error : (this.maxIOutput != 0.0 ? this.constrain(this.errorSum + error, -this.maxError, this.maxError) : (this.errorSum += error)));
        if (this.outputRampRate != 0.0) {
            output = this.constrain(output, this.lastOutput - this.outputRampRate, this.lastOutput + this.outputRampRate);
        }
        if (this.minOutput != this.maxOutput) {
            output = this.constrain(output, this.minOutput, this.maxOutput);
        }
        if (this.outputFilter != 0.0) {
            output = this.lastOutput * this.outputFilter + output * (1.0 - this.outputFilter);
        }
        this.lastOutput = output;
        return output;
    }

    private void reset() {
        this.firstRun = true;
        this.errorSum = 0.0;
    }

    private void setOutputRampRate(double rate) {
        this.outputRampRate = rate;
    }

    private void setOutputFilter(double strength) {
        if (strength == 0.0 || this.bounded(strength, 0.0, 1.0)) {
            this.outputFilter = strength;
        }
    }

    private double constrain(double value, double min, double max) {
        if (value > max) {
            return max;
        }
        if (value < min) {
            return min;
        }
        return value;
    }

    private boolean bounded(double value, double min, double max) {
        return min < value && value < max;
    }

    private void checkSigns() {
        if (this.P < 0.0) {
            this.P *= -1.0;
        }
        if (this.I < 0.0) {
            this.I *= -1.0;
        }
        if (this.D < 0.0) {
            this.D *= -1.0;
        }
        if (this.F < 0.0) {
            this.F *= -1.0;
        }
    }

    public static void main(String[] args) {
        String test = "11789_0_ACTIVITY_23032_1_1092";
        System.out.print(test.split("_")[3]);
        RoiPidController PID = new RoiPidController();
        StatInfo s1 = new StatInfo();
        s1.id = "11789_0_APP_23032";
        s1.sumFee = 3000.0;
        s1.sumConv = 20.0;
        s1.lastSumConv = 1.0;
        s1.lastSumFee = 800.0;
        s1.factor = 0.5;
        StatInfo s2 = new StatInfo();
        s2.id = "11789_0_ACTIVITY_23032_1_1092";
        s2.sumFee = 3000.0;
        s2.sumConv = 0.0;
        s2.lastSumConv = 0.0;
        s2.lastSumFee = 0.0;
        s2.factor = 1.0;
        ArrayList<StatInfo> infos = new ArrayList<StatInfo>();
        infos.add(s1);
        infos.add(s2);
        double bidOld = 1500.0;
        double maxConv = 100.0;
        double targetCpa = 1000.0;
        double actualCpa = s2.sumFee / s2.sumConv;
        double budget = 30000.0;
        for (int i = 0; i < 200; ++i) {
            double random2;
            if (i == 60) {
                targetCpa = 3000.0;
            }
            double factor = 1.0;
            double bid = bidOld;
            System.err.printf("%3.2f\t%3.2f\t%3.2f\t%3.2f\t%3.0f\t%3.0f\t%3.0f\t%3.0f\t%3.0f\n", targetCpa, actualCpa, s1.factor, s2.factor, bid, s2.sumFee, s2.sumConv, s2.lastSumFee, s2.lastSumConv);
            List<StatInfo> newinfos = PID.getPriceFactor(infos, targetCpa, budget);
            for (StatInfo newinfo : newinfos) {
                if (!newinfo.id.equals("11789_0_ACTIVITY_23032_1_1092")) continue;
                factor = newinfo.factor;
            }
            double random = 1.0;
            double random1 = Math.random();
            random = random1 > (random2 = Math.random()) ? 1.0 + random1 : 1.0 - random2;
            bid = bidOld * factor;
            bid = Math.max(bid, 1.0);
            bid = Math.min(3000.0, bid);
            double conv = Math.min(Math.pow(1.5, bid / 100.0), maxConv);
            s2.sumFee += bid * conv;
            s2.sumConv += conv;
            actualCpa = s2.sumFee / s2.sumConv;
        }
    }

    static class Constant {
        static double DEFAULT_FACTOR = 1.0;
        static double DEFAULT_P = 0.5;
        static double DEFAULT_I = 0.01;
        static double DEFAULT_D = 0.5;
        static double SENSITIVITY_DEFAULT = 1.0;
        static double SENSITIVITY_USE = 1.15;

        Constant() {
        }
    }
}

